/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator;

import dev.fitko.fitconnect.jwkvalidator.FullJWKValidatorBuilderSteps;
import dev.fitko.fitconnect.jwkvalidator.JWKValidator;
import dev.fitko.fitconnect.jwkvalidator.JWKValidatorBuilder;
import dev.fitko.fitconnect.jwkvalidator.exceptions.LogLevel;
import java.net.Proxy;
import java.security.cert.TrustAnchor;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class FullJWKValidatorBuilder
extends JWKValidatorBuilder
implements FullJWKValidatorBuilderSteps.JWKValidatorWithX5CValidation,
FullJWKValidatorBuilderSteps.JWKValidatorWithTrustAnchors,
FullJWKValidatorBuilderSteps.JWKValidatorWithDate,
FullJWKValidatorBuilderSteps.JWKValidatorWithOCSPResponseSignatureAlgorithms,
FullJWKValidatorBuilderSteps.JWKValidatorWithCRLSignatureAlgorithms,
FullJWKValidatorBuilderSteps.JWKValidatorX5CErrorHandling,
FullJWKValidatorBuilderSteps.JWKValidatorErrorLogLevel,
FullJWKValidatorBuilderSteps.JWKValidatorCreator {
    private final boolean withX5CValidation;
    private Proxy proxy = null;
    private Set<TrustAnchor> trustAnchors = null;
    private Date defaultValidationDate = null;
    private List<String> validOCSPResponseSignatureAlgorithms = null;
    private List<String> validCRLSignatureAlgorithms = null;
    private boolean isX5cValidationSilent = true;
    private LogLevel logLevel = LogLevel.ERROR;

    FullJWKValidatorBuilder(boolean withX5CValidation) {
        this.withX5CValidation = withX5CValidation;
    }

    @Override
    public FullJWKValidatorBuilderSteps.JWKValidatorWithTrustAnchors withProxy(Proxy proxy) throws IllegalArgumentException {
        FullJWKValidatorBuilder.assertNotNull(proxy, "Proxy value cannot be null");
        this.proxy = proxy;
        return this;
    }

    @Override
    public FullJWKValidatorBuilderSteps.JWKValidatorWithTrustAnchors withoutProxy() {
        this.proxy = Proxy.NO_PROXY;
        return this;
    }

    @Override
    public FullJWKValidatorBuilderSteps.JWKValidatorWithDate withTrustAnchors(Set<TrustAnchor> trustAnchors) throws IllegalArgumentException {
        FullJWKValidatorBuilder.assertNotNullOrEmpty(trustAnchors, "TrustAnchors value cannot be null or empty");
        FullJWKValidatorBuilder.assertNoNullValues(trustAnchors, "TrustAnchor values cannot be null");
        this.trustAnchors = trustAnchors;
        return this;
    }

    @Override
    public FullJWKValidatorBuilderSteps.JWKValidatorWithDate withRootCertificatesAsPEM(List<String> rootCertificatesAsPEM) throws RuntimeException {
        FullJWKValidatorBuilder.assertNotNullOrEmpty(rootCertificatesAsPEM, "Root certificates value cannot be null or empty");
        FullJWKValidatorBuilder.assertNoNullValues(rootCertificatesAsPEM, "Root certificate values cannot be null");
        this.trustAnchors = FullJWKValidatorBuilder.generateTrustAnchorsFromPEM(rootCertificatesAsPEM);
        return this;
    }

    @Override
    public FullJWKValidatorBuilderSteps.JWKValidatorWithOCSPResponseSignatureAlgorithms withDefaultValidationDateOfNow() {
        this.defaultValidationDate = null;
        return this;
    }

    @Override
    public FullJWKValidatorBuilderSteps.JWKValidatorWithOCSPResponseSignatureAlgorithms withDefaultValidationDateOf(Date defaultDate) throws IllegalArgumentException {
        FullJWKValidatorBuilder.assertNotNull(defaultDate, "A default date cannot be null");
        this.defaultValidationDate = defaultDate;
        return this;
    }

    @Override
    public FullJWKValidatorBuilderSteps.JWKValidatorWithCRLSignatureAlgorithms withDefaultOCSPResponseSignatureAlgorithms() {
        this.validOCSPResponseSignatureAlgorithms = DEFAULT_OCSP_RESPONSE_SIGNATURE_ALGORITHMS;
        return this;
    }

    @Override
    public FullJWKValidatorBuilderSteps.JWKValidatorWithCRLSignatureAlgorithms withOCSPResponseSignatureAlgorithms(List<String> signatureAlgorithmOIDs) {
        this.validOCSPResponseSignatureAlgorithms = signatureAlgorithmOIDs;
        return this;
    }

    @Override
    public FullJWKValidatorBuilderSteps.JWKValidatorX5CErrorHandling withDefaultCRLSignatureAlgorithms() {
        this.validCRLSignatureAlgorithms = DEFAULT_CRL_SIGNATURE_ALGORITHMS;
        return this;
    }

    @Override
    public FullJWKValidatorBuilderSteps.JWKValidatorX5CErrorHandling withCRLSignatureAlgorithms(List<String> signatureAlgorithmOIDs) {
        this.validCRLSignatureAlgorithms = signatureAlgorithmOIDs;
        return this;
    }

    @Override
    public FullJWKValidatorBuilderSteps.JWKValidatorErrorLogLevel withoutThrowingExceptions() {
        this.isX5cValidationSilent = true;
        return this;
    }

    @Override
    public FullJWKValidatorBuilderSteps.JWKValidatorErrorLogLevel withThrowingExceptions() {
        this.isX5cValidationSilent = false;
        return this;
    }

    @Override
    public FullJWKValidatorBuilderSteps.JWKValidatorCreator withDefaultErrorLogLevel() {
        this.logLevel = DEFAULT_ERROR_LOG_LEVEL;
        return this;
    }

    @Override
    public FullJWKValidatorBuilderSteps.JWKValidatorCreator withErrorLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    @Override
    public JWKValidator build() {
        if (this.withX5CValidation) {
            return JWKValidator.withX5CValidation(this.proxy, this.trustAnchors, this.defaultValidationDate, this.validOCSPResponseSignatureAlgorithms, this.validCRLSignatureAlgorithms, this.isX5cValidationSilent, this.logLevel);
        }
        return JWKValidator.withoutX5CValidation(this.logLevel);
    }
}

