/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.AsposeUtils;
import dev.fileformat.drako.HashBuilder;
import dev.fileformat.drako.ICornerTable;
import dev.fileformat.drako.Struct;
import java.io.Serializable;

final class VertexCornersIterator
implements Struct<VertexCornersIterator>,
Serializable {
    private ICornerTable corner_table_;
    private int start_corner_;
    private int corner_;
    private boolean left_traversal_;
    static final long serialVersionUID = -1504785517L;

    public static VertexCornersIterator fromVertex(ICornerTable table, int vert_id) {
        VertexCornersIterator ret = new VertexCornersIterator();
        ret.corner_table_ = table;
        ret.corner_ = ret.start_corner_ = table.leftMostCorner(vert_id);
        ret.left_traversal_ = true;
        return ret;
    }

    public static VertexCornersIterator fromCorner(ICornerTable table, int corner_id) {
        VertexCornersIterator ret = new VertexCornersIterator();
        ret.corner_table_ = table;
        ret.corner_ = ret.start_corner_ = corner_id;
        ret.left_traversal_ = true;
        return ret;
    }

    public int getCorner() {
        return this.corner_;
    }

    public boolean getEnd() {
        return this.corner_ == -1;
    }

    public void next() {
        if (this.left_traversal_) {
            this.corner_ = this.corner_table_.swingLeft(this.corner_);
            if (this.corner_ == -1) {
                this.corner_ = this.corner_table_.swingRight(this.start_corner_);
                this.left_traversal_ = false;
            } else if (this.corner_ == this.start_corner_) {
                this.corner_ = -1;
            }
        } else {
            this.corner_ = this.corner_table_.swingRight(this.corner_);
        }
    }

    public VertexCornersIterator() {
    }

    private VertexCornersIterator(VertexCornersIterator other) {
        this.corner_table_ = other.corner_table_;
        this.start_corner_ = other.start_corner_;
        this.corner_ = other.corner_;
        this.left_traversal_ = other.left_traversal_;
    }

    @Override
    public VertexCornersIterator clone() {
        return new VertexCornersIterator(this);
    }

    @Override
    public void copyFrom(VertexCornersIterator src) {
        if (src == null) {
            return;
        }
        this.corner_table_ = src.corner_table_;
        this.start_corner_ = src.start_corner_;
        this.corner_ = src.corner_;
        this.left_traversal_ = src.left_traversal_;
    }

    public int hashCode() {
        HashBuilder builder = new HashBuilder();
        builder.hash(this.corner_table_);
        builder.hash(this.start_corner_);
        builder.hash(this.corner_);
        builder.hash(this.left_traversal_);
        return builder.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VertexCornersIterator)) {
            return false;
        }
        VertexCornersIterator rhs = (VertexCornersIterator)obj;
        if (!AsposeUtils.equals(this.corner_table_, rhs.corner_table_)) {
            return false;
        }
        if (this.start_corner_ != rhs.start_corner_) {
            return false;
        }
        if (this.corner_ != rhs.corner_) {
            return false;
        }
        return this.left_traversal_ == rhs.left_traversal_;
    }
}

