/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.IOUtils;
import dev.fileformat.drako.Internal;
import dev.fileformat.drako.Stream;
import dev.fileformat.drako.TextWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

@Internal
class StreamWriter
extends TextWriter {
    private boolean autoFlush;
    private Stream stream;
    private CharBuffer chars = CharBuffer.allocate(20);
    private ByteBuffer bytes = ByteBuffer.allocate(50);

    public StreamWriter(Stream stream) {
        this(stream, StandardCharsets.UTF_8);
    }

    public StreamWriter(Stream stream, Charset charset) {
        super(charset);
        this.stream = stream;
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public void setAutoFlush(boolean val) {
        this.autoFlush = val;
    }

    @Override
    public void write(CharSequence value) throws IOException {
        if (value == null || value.length() == 0) {
            return;
        }
        ByteBuffer bytes = this.encoder.encode(CharBuffer.wrap(value));
        this.encoder.reset();
        byte[] arr = bytes.array();
        int len = bytes.limit();
        this.stream.write(arr, 0, len);
    }

    private void resetBuffers() {
        IOUtils.clear(this.bytes);
        IOUtils.clear(this.chars);
    }

    private void encodeBuffer() throws IOException {
        IOUtils.flip(this.chars);
        this.encoder.encode(this.chars, this.bytes, false);
        this.encoder.reset();
        byte[] arr = this.bytes.array();
        int len = this.bytes.position();
        this.stream.write(arr, 0, len);
    }

    @Override
    public void write(char ch) throws IOException {
        this.resetBuffers();
        this.chars.put(ch);
        this.encodeBuffer();
    }

    @Override
    public void write(float i) throws IOException {
        this.resetBuffers();
        this.chars.put(Float.toString(i));
        this.encodeBuffer();
    }

    @Override
    public void write(double i) throws IOException {
        this.resetBuffers();
        this.chars.put(Double.toString(i));
        Object bytes = null;
        this.encodeBuffer();
    }

    @Override
    public void write(boolean bool) throws IOException {
        this.resetBuffers();
        this.chars.put(bool ? "true" : "false");
        this.encodeBuffer();
    }

    @Override
    public void write(int i) throws IOException {
        this.resetBuffers();
        this.chars.put(Integer.toString(i));
        this.encodeBuffer();
    }

    @Override
    public void write(long i) throws IOException {
        this.resetBuffers();
        this.chars.put(Long.toString(i));
        this.encodeBuffer();
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    @Override
    public void setNewLine(String newLine) {
        this.eol = newLine;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

