/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.ByteSpan;
import dev.fileformat.drako.Internal;
import dev.fileformat.drako.MemoryStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Stream
implements Closeable {
    public static final int SEEK_SET = 0;
    public static final int SEEK_CURRENT = 1;
    public static final int SEEK_END = 2;

    protected Stream() {
    }

    public int readByte() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Internal
    public int read(ByteSpan bytes) throws IOException {
        return this.read(bytes.array, bytes.offset, bytes.length);
    }

    public int read(byte[] buf, int start, int len) throws IOException {
        for (int i = start; i < start + len; ++i) {
            buf[i] = (byte)this.readByte();
        }
        return len;
    }

    @Internal
    public void write(ByteSpan bytes) throws IOException {
        this.write(bytes.array, bytes.offset, bytes.length);
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int start, int len) throws IOException {
        for (int i = start; i < start + len; ++i) {
            this.writeByte(buf[i]);
        }
    }

    public void writeByte(int b) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long seek(long offset, int seek) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void copyTo(Stream output) throws IOException {
        int n;
        byte[] buffer = new byte[40960];
        while ((n = this.read(buffer)) > 0) {
            output.write(buffer, 0, n);
        }
    }

    @Override
    public void close() throws IOException {
    }

    public void flush() throws IOException {
    }

    public long getLength() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setLength(long len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public InputStream getInputStream() {
        return new InputStreamAdapter();
    }

    public OutputStream getOutputStream() {
        return new OutputStreamAdapter();
    }

    public static Stream wrap(OutputStream stream) {
        return new MemoryStreamAdapter(stream);
    }

    public static Stream wrap(InputStream stream) throws IOException {
        int len;
        ByteArrayOutputStream mem = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        while ((len = stream.read(buffer)) > 0) {
            mem.write(buffer, 0, len);
        }
        return new MemoryStream(mem.toByteArray());
    }

    static class MemoryStreamAdapter
    extends MemoryStream {
        private OutputStream stream;

        public MemoryStreamAdapter(OutputStream stream) {
            this.stream = stream;
        }

        @Override
        public void close() throws IOException {
            try (OutputStream s = this.stream;){
                if (this.data != null) {
                    s.write(this.data, 0, this.cursor);
                }
            }
        }
    }

    class OutputStreamAdapter
    extends OutputStream {
        OutputStreamAdapter() {
        }

        @Override
        public void write(int val) throws IOException {
            Stream.this.writeByte(val);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Stream.this.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            Stream.this.flush();
        }
    }

    class InputStreamAdapter
    extends InputStream {
        InputStreamAdapter() {
        }

        @Override
        public int read() throws IOException {
            return Stream.this.readByte();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            int ret = Stream.this.read(b, off, len);
            if (ret <= 0) {
                return -1;
            }
            return ret;
        }

        @Override
        public long skip(long n) throws IOException {
            Stream.this.seek(n, 1);
            return n;
        }

        @Override
        public int available() throws IOException {
            long length = Stream.this.getLength();
            long pos = Stream.this.seek(0L, 1);
            return (int)(length - pos);
        }
    }
}

