/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.AttributeOctahedronTransform;
import dev.fileformat.drako.ByteSpan;
import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.MeshDecoder;
import dev.fileformat.drako.PointCloudDecoder;
import dev.fileformat.drako.PredictionScheme;
import dev.fileformat.drako.PredictionSchemeNormalOctahedronCanonicalizedTransform;
import dev.fileformat.drako.PredictionSchemeNormalOctahedronTransform;
import dev.fileformat.drako.PredictionSchemeTransform;
import dev.fileformat.drako.SequentialIntegerAttributeDecoder;

class SequentialNormalAttributeDecoder
extends SequentialIntegerAttributeDecoder {
    private int quantizationBits;

    @Override
    protected int getNumValueComponents() {
        return 2;
    }

    @Override
    public void initialize(PointCloudDecoder decoder, int attributeId) throws DrakoException {
        super.initialize(decoder, attributeId);
        if (this.getAttribute().getComponentsCount() != 3) {
            throw DracoUtils.failed();
        }
        if (this.getAttribute().getDataType() != 9) {
            throw DracoUtils.failed();
        }
    }

    @Override
    public void decodeIntegerValues(int[] pointIds, DecoderBuffer inBuffer) throws DrakoException {
        if (this.decoder.getBitstreamVersion() < 20) {
            byte quantizationBits = inBuffer.decodeU8();
            this.quantizationBits = 0xFF & quantizationBits;
        }
        super.decodeIntegerValues(pointIds, inBuffer);
    }

    @Override
    public void decodeDataNeededByPortableTransform(int[] pointIds, DecoderBuffer in_buffer) throws DrakoException {
        if (this.decoder.getBitstreamVersion() >= 20) {
            byte quantization_bits = in_buffer.decodeU8();
            this.quantizationBits = 0xFF & quantization_bits;
        }
        AttributeOctahedronTransform octahedral_transform = new AttributeOctahedronTransform(this.quantizationBits);
        octahedral_transform.transferToAttribute(this.getPortableAttribute());
    }

    @Override
    protected void storeValues(int numPoints) {
        int maxQuantizedValue = (1 << this.quantizationBits) - 1;
        float maxQuantizedValueF = maxQuantizedValue;
        int numComponents = this.getAttribute().getComponentsCount();
        int entrySize = 4 * numComponents;
        float[] attVal = new float[3];
        int quantValId = 0;
        int outBytePos = 0;
        IntSpan values = ByteSpan.wrap(this.getPortableAttribute().getBuffer().getBuffer(), 0, numPoints * 2 * 4).asIntSpan();
        for (int i = 0; i < numPoints; ++i) {
            int s = values.get(quantValId++);
            int t = values.get(quantValId++);
            this.quantizedOctaherdalCoordsToUnitVector(s, t, maxQuantizedValueF, attVal);
            this.getAttribute().getBuffer().write(outBytePos, attVal);
            outBytePos += entrySize;
        }
    }

    void octaherdalCoordsToUnitVector(float inS, float inT, float[] outVector) {
        float s = inS;
        float t = inT;
        float spt = s + t;
        float smt = s - t;
        float xSign = 1.0f;
        if (!(spt >= 0.5f && spt <= 1.5f && smt >= -0.5f && smt <= 0.5f)) {
            xSign = -1.0f;
            if ((double)spt <= 0.5) {
                s = 0.5f - inT;
                t = 0.5f - inS;
            } else if (spt >= 1.5f) {
                s = 1.5f - inT;
                t = 1.5f - inS;
            } else if (smt <= -0.5f) {
                s = inT - 0.5f;
                t = inS + 0.5f;
            } else {
                s = inT + 0.5f;
                t = inS - 0.5f;
            }
            spt = s + t;
            smt = s - t;
        }
        float y = 2.0f * s - 1.0f;
        float z = 2.0f * t - 1.0f;
        float x = Math.min(Math.min(2.0f * spt - 1.0f, 3.0f - 2.0f * spt), Math.min(2.0f * smt + 1.0f, 1.0f - 2.0f * smt)) * xSign;
        float normSquared = x * x + y * y + z * z;
        if ((double)normSquared < 1.0E-6) {
            outVector[0] = 0.0f;
            outVector[1] = 0.0f;
            outVector[2] = 0.0f;
        } else {
            float d = 1.0f / (float)Math.sqrt(normSquared);
            outVector[0] = x * d;
            outVector[1] = y * d;
            outVector[2] = z * d;
        }
    }

    void quantizedOctaherdalCoordsToUnitVector(int inS, int inT, float maxQuantizedValue, float[] outVector) {
        this.octaherdalCoordsToUnitVector((float)inS / (maxQuantizedValue -= 1.0f), (float)inT / maxQuantizedValue, outVector);
    }

    @Override
    protected PredictionScheme createIntPredictionScheme(int method, int transformType) {
        if (transformType == 2) {
            return PredictionScheme.create((MeshDecoder)this.getDecoder(), method, this.getAttributeId(), (PredictionSchemeTransform)new PredictionSchemeNormalOctahedronTransform());
        }
        if (transformType == 3) {
            return PredictionScheme.create(this.getDecoder(), method, this.getAttributeId(), (PredictionSchemeTransform)new PredictionSchemeNormalOctahedronCanonicalizedTransform());
        }
        return null;
    }

    public SequentialNormalAttributeDecoder() {
        this.$initFields$();
    }

    private void $initFields$() {
        try {
            this.quantizationBits = -1;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

