/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.ByteSpan;
import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.Decoding;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.MeshDecoder;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.PointCloudDecoder;
import dev.fileformat.drako.PredictionScheme;
import dev.fileformat.drako.PredictionSchemeDeltaDecoder;
import dev.fileformat.drako.PredictionSchemeTransform;
import dev.fileformat.drako.PredictionSchemeWrapTransform;
import dev.fileformat.drako.SequentialAttributeDecoder;

class SequentialIntegerAttributeDecoder
extends SequentialAttributeDecoder {
    private PredictionScheme predictionScheme;

    SequentialIntegerAttributeDecoder() {
    }

    @Override
    protected void decodeValues(int[] pointIds, DecoderBuffer inBuffer) throws DrakoException {
        int numValues = pointIds.length;
        byte predictionSchemeMethod = inBuffer.decodeI8();
        if (predictionSchemeMethod != -2) {
            byte predictionTransformType = inBuffer.decodeI8();
            this.predictionScheme = this.createIntPredictionScheme(predictionSchemeMethod, predictionTransformType);
        }
        if (this.predictionScheme != null) {
            this.initPredictionScheme(this.predictionScheme);
        }
        this.decodeIntegerValues(pointIds, inBuffer);
        if (this.getDecoder() != null && this.getDecoder().getBitstreamVersion() < 20) {
            this.storeValues(numValues);
        }
    }

    protected PredictionScheme createIntPredictionScheme(int method, int transformType) {
        if (transformType != 1) {
            return null;
        }
        return this.createPredictionSchemeForDecoder(method, this.getAttributeId(), this.getDecoder());
    }

    PredictionScheme createPredictionSchemeForDecoder(int method, int attId, PointCloudDecoder decoder) {
        return this.createPredictionSchemeForDecoder(method, attId, decoder, new PredictionSchemeWrapTransform());
    }

    PredictionScheme createPredictionSchemeForDecoder(int method, int attId, PointCloudDecoder decoder, PredictionSchemeTransform transform) {
        MeshDecoder meshDecoder;
        PredictionScheme ret;
        PointAttribute att = decoder.getPointCloud().attribute(attId);
        if (decoder.getGeometryType() == 1 && (ret = PredictionScheme.create(meshDecoder = (MeshDecoder)decoder, method, attId, transform)) != null) {
            return ret;
        }
        return new PredictionSchemeDeltaDecoder(att, transform);
    }

    private void preparePortableAttribute(int num_entries, int num_components) {
        PointAttribute va = new PointAttribute();
        va.setAttributeType(this.attribute.getAttributeType());
        va.setComponentsCount(this.attribute.getComponentsCount());
        va.setDataType(5);
        va.setByteStride(num_components * DracoUtils.dataTypeLength(5));
        va.setIdentityMapping(true);
        va.reset(num_entries);
        this.setPortableAttribute(va);
    }

    protected int getNumValueComponents() {
        return this.attribute.getComponentsCount();
    }

    private IntSpan getValues(int numEntries) {
        int numComponents = this.getNumValueComponents();
        int numValues = numEntries * numComponents;
        if (numComponents <= 0) {
            return null;
        }
        this.preparePortableAttribute(numEntries, numComponents);
        if (this.getPortableAttribute().getNumUniqueEntries() == 0) {
            return null;
        }
        byte[] buf = this.getPortableAttribute().getBuffer().getBuffer();
        return ByteSpan.wrap(buf, 0, numValues * 4).asIntSpan();
    }

    public void decodeIntegerValues(int[] pointIds, DecoderBuffer inBuffer) throws DrakoException {
        int numComponents = this.getNumValueComponents();
        int numEntries = pointIds.length;
        int numValues = numEntries * numComponents;
        if (numComponents <= 0) {
            throw DracoUtils.failed();
        }
        IntSpan values = this.getValues(numEntries);
        if (values == null) {
            throw DracoUtils.failed();
        }
        byte compressed = inBuffer.decodeU8();
        if ((0xFF & compressed) > 0) {
            Decoding.decodeSymbols(numValues, numComponents, inBuffer, values);
        } else {
            byte numBytes = inBuffer.decodeU8();
            for (int i = 0; i < values.size(); ++i) {
                values.put(i, inBuffer.decodeI32());
            }
        }
        if (this.predictionScheme == null || !this.predictionScheme.areCorrectionsPositive()) {
            Decoding.convertSymbolsToSignedInts(values, values);
        }
        if (this.predictionScheme != null) {
            this.predictionScheme.decodePredictionData(inBuffer);
            this.predictionScheme.computeOriginalValues(values, values, values.size(), numComponents, pointIds);
        }
    }

    @Override
    public void transformAttributeToOriginalFormat(int[] pointIds) throws DrakoException {
        if (this.decoder != null && this.decoder.getBitstreamVersion() < 20) {
            return;
        }
        this.storeValues(pointIds.length);
    }

    protected void storeValues(int numValues) throws DrakoException {
        switch (this.getAttribute().getDataType()) {
            case 1: 
            case 2: {
                this.store8BitsValues(numValues);
                break;
            }
            case 3: 
            case 4: {
                this.store16BitsValues(numValues);
                break;
            }
            case 5: 
            case 6: {
                this.store32BitsValues(numValues);
                break;
            }
            default: {
                throw DracoUtils.failed();
            }
        }
    }

    private void store8BitsValues(int numValues) {
        int vals = this.getAttribute().getComponentsCount() * numValues;
        IntSpan values = this.getValues(numValues);
        int outBytePos = 0;
        for (int i = 0; i < vals; ++i) {
            this.getAttribute().getBuffer().write(outBytePos, (byte)values.get(i));
            ++outBytePos;
        }
    }

    private void store16BitsValues(int numValues) {
        int vals = this.getAttribute().getComponentsCount() * numValues;
        IntSpan values = this.getValues(numValues);
        int outBytePos = 0;
        for (int i = 0; i < vals; ++i) {
            this.getAttribute().getBuffer().write3(outBytePos, (short)values.get(i));
            outBytePos += 2;
        }
    }

    private void store32BitsValues(int numValues) {
        int vals = this.getAttribute().getComponentsCount() * numValues;
        IntSpan values = this.getValues(numValues);
        int outBytePos = 0;
        for (int i = 0; i < vals; ++i) {
            this.getAttribute().getBuffer().write(outBytePos, values.get(i));
            outBytePos += 4;
        }
    }
}

