/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.IntList;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.PointCloudEncoder;
import dev.fileformat.drako.PredictionScheme;

class SequentialAttributeEncoder {
    private PointCloudEncoder encoder;
    protected PointAttribute attribute;
    PointAttribute portableAttribute;
    private int attributeId;
    private IntList parentAttributes;
    private boolean isParentEncoder;

    public void initialize(PointCloudEncoder encoder, int attributeId) throws DrakoException {
        this.encoder = encoder;
        this.attribute = encoder.getPointCloud().attribute(attributeId);
        this.attributeId = attributeId;
    }

    public void initializeStandalone(PointAttribute attribute) {
        this.attribute = attribute;
        this.attributeId = -1;
    }

    public void transformAttributeToPortableFormat(int[] point_ids) {
    }

    public void encodePortableAttribute(int[] point_ids, EncoderBuffer out_buffer) throws DrakoException {
        this.encodeValues(point_ids, out_buffer);
    }

    public void encodeDataNeededByPortableTransform(EncoderBuffer out_buffer) throws DrakoException {
    }

    protected void setPredictionSchemeParentAttributes(PredictionScheme ps) throws DrakoException {
        for (int i = 0; i < ps.getNumParentAttributes(); ++i) {
            int att_id = this.encoder.getPointCloud().getNamedAttributeId(ps.getParentAttributeType(i));
            if (att_id == -1) {
                throw DracoUtils.failed();
            }
            ps.setParentAttribute(this.encoder.getPortableAttribute(att_id));
        }
    }

    public boolean encode(int[] pointIds, EncoderBuffer outBuffer) throws DrakoException {
        this.encodeValues(pointIds, outBuffer);
        return !this.isParentEncoder || !this.isLossyEncoder() || this.prepareLossyAttributeData();
    }

    public boolean isLossyEncoder() {
        return false;
    }

    public int getNumParentAttributes() {
        return this.parentAttributes.getCount();
    }

    public int getParentAttributeId(int i) {
        return this.parentAttributes.get(i);
    }

    public void markParentAttribute() {
        this.isParentEncoder = true;
    }

    public int getUniqueId() {
        return 0;
    }

    public PointAttribute getAttribute() {
        return this.attribute;
    }

    public int getAttributeId() {
        return this.attributeId;
    }

    public PointCloudEncoder getEncoder() {
        return this.encoder;
    }

    protected void initPredictionScheme(PredictionScheme ps) throws DrakoException {
        for (int i = 0; i < ps.getNumParentAttributes(); ++i) {
            int attId = this.encoder.getPointCloud().getNamedAttributeId(ps.getParentAttributeType(i));
            if (attId == -1) {
                throw DracoUtils.failed();
            }
            this.parentAttributes.add(attId);
            this.encoder.markParentAttribute(attId);
        }
    }

    protected void encodeValues(int[] pointIds, EncoderBuffer outBuffer) throws DrakoException {
        int entrySize = this.attribute.getByteStride();
        byte[] valueData = new byte[entrySize];
        for (int i = 0; i < pointIds.length; ++i) {
            int entryId = this.attribute.mappedIndex(pointIds[i]);
            this.attribute.getValue(entryId, valueData);
            outBuffer.encode(valueData, entrySize);
        }
    }

    protected boolean prepareLossyAttributeData() {
        return false;
    }

    protected boolean isParentEncoder() {
        return this.isParentEncoder;
    }

    protected static int selectPredictionMethod(int att_id, PointCloudEncoder encoder) {
        int speed = encoder.getOptions().getSpeed();
        if (speed >= 10) {
            return 0;
        }
        if (encoder.getGeometryType() == 1) {
            PointAttribute att = encoder.getPointCloud().attribute(att_id);
            if (att.getAttributeType() == 3 && speed < 4) {
                return 5;
            }
            if (att.getAttributeType() == 1) {
                if (speed < 4) {
                    return 6;
                }
                return 0;
            }
            if (speed >= 8) {
                return 0;
            }
            if (speed >= 2 || encoder.getPointCloud().getNumPoints() < 40) {
                return 1;
            }
            return 4;
        }
        return 0;
    }

    public SequentialAttributeEncoder() {
        this.$initFields$();
    }

    private void $initFields$() {
        try {
            this.attributeId = -1;
            this.parentAttributes = new IntList();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

