/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.PointCloudDecoder;
import dev.fileformat.drako.PredictionScheme;

class SequentialAttributeDecoder {
    protected PointCloudDecoder decoder;
    protected PointAttribute attribute;
    PointAttribute portableAttribute;
    private int attributeId;

    public void initialize(PointCloudDecoder decoder, int attributeId) throws DrakoException {
        this.decoder = decoder;
        this.attribute = decoder.getPointCloud().attribute(attributeId);
        this.attributeId = attributeId;
    }

    public void initializeStandalone(PointAttribute attribute) {
        this.attribute = attribute;
        this.attributeId = -1;
    }

    public void decode(int[] pointIds, DecoderBuffer inBuffer) throws DrakoException {
        this.attribute.reset(pointIds.length);
        this.decodeValues(pointIds, inBuffer);
    }

    public PointAttribute getAttribute() {
        return this.attribute;
    }

    public int getAttributeId() {
        return this.attributeId;
    }

    public PointCloudDecoder getDecoder() {
        return this.decoder;
    }

    protected void initPredictionScheme(PredictionScheme ps) throws DrakoException {
        for (int i = 0; i < ps.getNumParentAttributes(); ++i) {
            int attId = this.decoder.getPointCloud().getNamedAttributeId(ps.getParentAttributeType(i));
            if (attId == -1) {
                throw DracoUtils.failed();
            }
            PointAttribute parentAttribute = this.decoder.getBitstreamVersion() < 20 ? this.decoder.getPointCloud().attribute(attId) : this.decoder.getPortableAttribute(attId);
            if (parentAttribute == null) {
                throw DracoUtils.failed();
            }
            ps.setParentAttribute(parentAttribute);
        }
    }

    protected void decodeValues(int[] pointIds, DecoderBuffer inBuffer) throws DrakoException {
        int numValues = pointIds.length;
        int entrySize = this.attribute.getByteStride();
        byte[] valueData = new byte[entrySize];
        int outBytePos = 0;
        for (int i = 0; i < numValues; ++i) {
            if (!inBuffer.decode(valueData, entrySize)) {
                throw DracoUtils.failed();
            }
            this.attribute.getBuffer().write(outBytePos, valueData, entrySize);
            outBytePos += entrySize;
        }
    }

    public void decodePortableAttribute(int[] pointIds, DecoderBuffer in_buffer) throws DrakoException {
        if (this.attribute.getComponentsCount() <= 0) {
            throw DracoUtils.failed();
        }
        this.attribute.reset(pointIds.length);
        this.decodeValues(pointIds, in_buffer);
    }

    public void decodeDataNeededByPortableTransform(int[] pointIds, DecoderBuffer in_buffer) throws DrakoException {
    }

    public void transformAttributeToOriginalFormat(int[] pointIds) throws DrakoException {
    }

    public PointAttribute getPortableAttribute() {
        if (!this.attribute.getIdentityMapping() && this.portableAttribute != null && this.portableAttribute.getIdentityMapping()) {
            int indiceMapSize = this.attribute.getIndicesMap().length;
            this.portableAttribute.setExplicitMapping(indiceMapSize);
            for (int i = 0; i < indiceMapSize; ++i) {
                this.portableAttribute.setPointMapEntry(i, this.attribute.mappedIndex(i));
            }
        }
        return this.portableAttribute;
    }

    public void setPortableAttribute(PointAttribute value) {
        this.portableAttribute = value;
    }

    public SequentialAttributeDecoder() {
        this.$initFields$();
    }

    private void $initFields$() {
        try {
            this.attributeId = -1;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

