/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.CornerTable;
import dev.fileformat.drako.MeshAttributeIndicesEncodingObserver;
import dev.fileformat.drako.TraverserBase;
import java.util.Stack;

class PredictionDegreeTraverser
extends TraverserBase<CornerTable> {
    static final int K_MAX_PRIORITY = 3;
    private Stack<Integer>[] traversal_stacks_;
    int best_priority_;
    private int[] prediction_degree_;
    CornerTable cornerTable;
    private MeshAttributeIndicesEncodingObserver<CornerTable> observer;

    public PredictionDegreeTraverser(MeshAttributeIndicesEncodingObserver<CornerTable> observer) {
        this.$initFields$();
        this.cornerTable = observer.getCornerTable();
        this.observer = observer;
        this.init(this.cornerTable, observer);
        for (int i = 0; i < 3; ++i) {
            this.traversal_stacks_[i] = new Stack();
        }
    }

    @Override
    public void onTraversalStart() {
        this.prediction_degree_ = new int[this.cornerTable.getNumVertices()];
    }

    @Override
    public void onTraversalEnd() {
    }

    @Override
    public void traverseFromCorner(int corner_id) {
        int tip_vertex;
        if (this.prediction_degree_.length == 0) {
            return;
        }
        this.traversal_stacks_[0].push(corner_id);
        this.best_priority_ = 0;
        int next_vert = this.cornerTable.vertex(this.cornerTable.next(corner_id));
        int prev_vert = this.cornerTable.vertex(this.cornerTable.previous(corner_id));
        if (!this.isVertexVisited(next_vert)) {
            this.markVertexVisited(next_vert);
            this.observer.onNewVertexVisited(next_vert, this.cornerTable.next(corner_id));
        }
        if (!this.isVertexVisited(prev_vert)) {
            this.markVertexVisited(prev_vert);
            this.observer.onNewVertexVisited(prev_vert, this.cornerTable.previous(corner_id));
        }
        if (!this.isVertexVisited(tip_vertex = this.cornerTable.vertex(corner_id))) {
            this.markVertexVisited(tip_vertex);
            this.observer.onNewVertexVisited(tip_vertex, corner_id);
        }
        block0: while ((corner_id = this.popNextCornerToTraverse()) != -1) {
            int priority;
            int right_corner_id;
            int face_id = corner_id / 3;
            if (this.isFaceVisited(face_id)) continue;
            while (true) {
                face_id = corner_id / 3;
                this.markFaceVisited(face_id);
                this.observer.onNewFaceVisited(face_id);
                int vert_id = this.cornerTable.vertex(corner_id);
                if (!this.isVertexVisited(vert_id)) {
                    this.markVertexVisited(vert_id);
                    this.observer.onNewVertexVisited(vert_id, corner_id);
                }
                right_corner_id = this.cornerTable.getRightCorner(corner_id);
                int left_corner_id = this.cornerTable.getLeftCorner(corner_id);
                int right_face_id = right_corner_id == -1 ? -1 : right_corner_id / 3;
                int left_face_id = left_corner_id == -1 ? -1 : left_corner_id / 3;
                boolean is_right_face_visited = this.isFaceVisited(right_face_id);
                boolean is_left_face_visited = this.isFaceVisited(left_face_id);
                if (!is_left_face_visited) {
                    priority = this.computePriority(left_corner_id);
                    if (is_right_face_visited && priority <= this.best_priority_) {
                        corner_id = left_corner_id;
                        continue;
                    }
                    this.addCornerToTraversalStack(left_corner_id, priority);
                }
                if (is_right_face_visited) continue block0;
                priority = this.computePriority(right_corner_id);
                if (priority > this.best_priority_) break;
                corner_id = right_corner_id;
            }
            this.addCornerToTraversalStack(right_corner_id, priority);
        }
    }

    private int popNextCornerToTraverse() {
        for (int i = this.best_priority_; i < 3; ++i) {
            if (this.traversal_stacks_[i].isEmpty()) continue;
            int ret = this.traversal_stacks_[i].peek();
            this.traversal_stacks_[i].pop();
            this.best_priority_ = i;
            return ret;
        }
        return -1;
    }

    private void addCornerToTraversalStack(int ci, int priority) {
        this.traversal_stacks_[priority].push(ci);
        if (priority < this.best_priority_) {
            this.best_priority_ = priority;
        }
    }

    private int computePriority(int corner_id) {
        int v_tip = this.cornerTable.vertex(corner_id);
        int priority = 0;
        if (!this.isVertexVisited(v_tip)) {
            int n = v_tip;
            int n2 = this.prediction_degree_[n] + 1;
            this.prediction_degree_[n] = n2;
            int degree = n2;
            int n3 = priority = degree > 1 ? 1 : 2;
        }
        if (priority >= 3) {
            priority = 2;
        }
        return priority;
    }

    private void $initFields$() {
        try {
            this.traversal_stacks_ = new Stack[3];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

