/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.AsposeUtils;
import dev.fileformat.drako.AttributeTransformData;
import dev.fileformat.drako.BitUtils;
import dev.fileformat.drako.ByteSpan;
import dev.fileformat.drako.DataBuffer;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.FloatSpan;
import dev.fileformat.drako.GeometryAttribute;
import dev.fileformat.drako.LongVector3;
import dev.fileformat.drako.Struct;
import dev.fileformat.drako.Unsafe;
import dev.fileformat.drako.Vector2;
import dev.fileformat.drako.Vector3;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;

public class PointAttribute
extends GeometryAttribute {
    private static final int K_INVALID_ATTRIBUTE_VALUE_INDEX = -1;
    private int[] indicesMap;
    private int numUniqueEntries;
    private DataBuffer buffer;
    private AttributeTransformData attributeTransformData;

    public DataBuffer getBuffer() {
        return this.buffer;
    }

    public int getNumUniqueEntries() {
        return this.numUniqueEntries;
    }

    public void setNumUniqueEntries(int value) {
        this.numUniqueEntries = value;
    }

    public PointAttribute() {
    }

    public PointAttribute(int type, int dataType, int components, boolean normalized, int byteStride, int byteOffset, DataBuffer buffer) {
        this.setAttributeType(type);
        this.setComponentsCount(components);
        this.setDataType(dataType);
        this.setNormalized(normalized);
        this.setByteOffset(byteOffset);
        this.buffer = buffer;
        if (byteStride == -1) {
            this.setByteStride(DracoUtils.dataTypeLength(dataType) * components);
        } else {
            this.setByteStride(byteStride);
        }
        if (buffer != null) {
            this.numUniqueEntries = buffer.getLength() / this.getByteStride();
        }
    }

    public PointAttribute(int type, int dataType, int components, boolean normalized) {
        this(type, dataType, components, normalized, -1, 0, null);
    }

    public PointAttribute(int type, int dataType, int components, boolean normalized, int byteStride) {
        this(type, dataType, components, normalized, byteStride, 0, null);
    }

    public PointAttribute(int type, int dataType, int components, boolean normalized, int byteStride, int byteOffset) {
        this(type, dataType, components, normalized, byteStride, byteOffset, null);
    }

    public static PointAttribute wrap(int type, Vector2[] vectors) {
        byte[] bytes = new byte[8 * vectors.length];
        int p = 0;
        for (int i = 0; i < vectors.length; ++i) {
            Unsafe.putLE32(bytes, p, Unsafe.floatToUInt32(vectors[i].x));
            Unsafe.putLE32(bytes, p + 4, Unsafe.floatToUInt32(vectors[i].y));
            p += 8;
        }
        return new PointAttribute(type, 9, 2, false, -1, 0, new DataBuffer(bytes));
    }

    public static PointAttribute wrap(int type, Vector3[] vectors) {
        byte[] bytes = new byte[12 * vectors.length];
        int p = 0;
        for (int i = 0; i < vectors.length; ++i) {
            Unsafe.putLE32(bytes, p, Unsafe.floatToUInt32(vectors[i].x));
            Unsafe.putLE32(bytes, p + 4, Unsafe.floatToUInt32(vectors[i].y));
            Unsafe.putLE32(bytes, p + 8, Unsafe.floatToUInt32(vectors[i].z));
            p += 12;
        }
        return new PointAttribute(type, 9, 3, false, -1, 0, new DataBuffer(bytes));
    }

    public void getValue(int attIndex, byte[] outData) {
        int bytePos = this.getByteOffset() + this.getByteStride() * attIndex;
        this.buffer.read(bytePos, outData, this.getByteStride());
    }

    public int getBytePos(int attIndex) {
        return this.getByteOffset() + this.getByteStride() * attIndex;
    }

    public void getValue(int attIndex, short[] v) {
        int bytePos = this.getByteOffset() + this.getByteStride() * attIndex;
        byte[] data = this.buffer.getBuffer();
        for (int i = 0; i < v.length; ++i) {
            v[i] = Unsafe.getLE16(data, bytePos);
            bytePos += 2;
        }
    }

    public void getValue(int attIndex, int[] v) {
        int bytePos = this.getByteOffset() + this.getByteStride() * attIndex;
        byte[] data = this.buffer.getBuffer();
        for (int i = 0; i < v.length; ++i) {
            v[i] = Unsafe.getLE32(data, bytePos);
            bytePos += 4;
        }
    }

    public void getValue(int attIndex, float[] v) {
        int bytePos = this.getByteOffset() + this.getByteStride() * attIndex;
        for (int i = 0; i < v.length; ++i) {
            v[i] = this.buffer.readFloat(bytePos);
            bytePos += 4;
        }
    }

    public void getValue(int attIndex, FloatSpan v) {
        int bytePos = this.getByteOffset() + this.getByteStride() * attIndex;
        for (int i = 0; i < v.size(); ++i) {
            v.put(i, this.buffer.readFloat(bytePos));
            bytePos += 4;
        }
    }

    public Vector3 getValueAsVector3(int attIndex) {
        int bytePos = this.getByteOffset() + this.getByteStride() * attIndex;
        Vector3 v = new Vector3();
        v.x = this.buffer.readFloat(bytePos);
        v.y = this.buffer.readFloat(bytePos += 4);
        v.z = this.buffer.readFloat(bytePos += 4);
        return v;
    }

    public void reset(int numAttributeValues) {
        if (this.buffer == null) {
            this.buffer = new DataBuffer();
        }
        int entrySize = DracoUtils.dataTypeLength(this.getDataType()) * this.getComponentsCount();
        this.buffer.setCapacity(numAttributeValues * entrySize);
        this.buffer.setLength(numAttributeValues * entrySize);
        this.setByteStride(entrySize);
        this.setByteOffset(0);
        this.numUniqueEntries = numAttributeValues;
    }

    public int mappedIndex(int pointIndex) {
        if (this.indicesMap == null) {
            return pointIndex;
        }
        return this.indicesMap[pointIndex];
    }

    public void resize(int newNumUniqueEntries) {
        this.numUniqueEntries = newNumUniqueEntries;
    }

    public boolean getIdentityMapping() {
        return this.indicesMap == null;
    }

    public void setIdentityMapping(boolean value) {
        if (value) {
            this.indicesMap = null;
        } else if (this.indicesMap == null) {
            this.indicesMap = new int[0];
        }
    }

    public int[] getIndicesMap() {
        return this.indicesMap;
    }

    AttributeTransformData getAttributeTransformData() {
        return this.attributeTransformData;
    }

    void setAttributeTransformData(AttributeTransformData value) {
        this.attributeTransformData = value;
    }

    public void setExplicitMapping(int numPoints) {
        int fillStart = 0;
        if (this.indicesMap == null) {
            this.indicesMap = new int[numPoints];
        } else {
            fillStart = this.indicesMap.length;
            this.indicesMap = this.indicesMap == null ? new int[numPoints] : Arrays.copyOf(this.indicesMap, numPoints);
        }
        for (int i = fillStart; i < numPoints; ++i) {
            this.indicesMap[i] = -1;
        }
    }

    public void setPointMapEntry(int pointIndex, int entryIndex) {
        this.indicesMap[pointIndex] = entryIndex;
    }

    public void convertValue(int attId, int[] i) {
        int pos = this.getByteOffset() + this.getByteStride() * attId;
        i[0] = this.buffer.readInt(pos);
    }

    LongVector3 convertValue(int attId) {
        int pos = this.getByteOffset() + this.getByteStride() * attId;
        if (this.getDataType() == 5 || this.getDataType() == 6) {
            long x = this.buffer.readInt(pos);
            long y = this.buffer.readInt(pos + 4);
            long z = this.buffer.readInt(pos + 8);
            return new LongVector3(x, y, z);
        }
        throw new UnsupportedOperationException("Unsupported type cast");
    }

    public void deduplicateValues() {
        int offset = this.getByteOffset();
        int stride = this.getByteStride();
        HashMap<ValueKey, Integer> indiceMap = new HashMap<ValueKey, Integer>();
        HashMap<Integer, Integer> valueMap = new HashMap<Integer, Integer>();
        int uniqueValues = 0;
        byte[] tmp = this.buffer.toArray();
        Integer[] ref0 = new Integer[1];
        int i = 0;
        while (i < this.getNumUniqueEntries()) {
            int idx;
            ValueKey k = new ValueKey(this, tmp, i);
            if (!AsposeUtils.tryGetValue(indiceMap, k, ref0)) {
                idx = ref0[0] == null ? 0 : ref0[0];
                this.setAttributeValue(uniqueValues, this.getBuffer().getBuffer(), k.getOffset());
                idx = uniqueValues++;
                indiceMap.put(Struct.byVal(k), idx);
            } else {
                idx = ref0[0] == null ? 0 : ref0[0];
            }
            valueMap.put(i, idx);
            ++i;
            offset += stride;
        }
        if (uniqueValues == this.numUniqueEntries) {
            return;
        }
        if (this.getIdentityMapping()) {
            this.setExplicitMapping(this.numUniqueEntries);
            for (i = 0; i < this.numUniqueEntries; ++i) {
                this.setPointMapEntry(i, (Integer)valueMap.get(i));
            }
        } else {
            for (i = 0; i < this.indicesMap.length; ++i) {
                this.setPointMapEntry(i, (Integer)valueMap.get(this.indicesMap[i]));
            }
        }
        this.numUniqueEntries = uniqueValues;
    }

    public void setAttributeValue(int index, byte[] buffer, int offset) {
        int dstOffset = this.getByteOffset() + this.getByteStride() * index;
        byte[] dst = this.buffer.getBuffer();
        System.arraycopy(buffer, offset, dst, dstOffset, this.getByteStride());
    }

    void setAttributeValue(int index, int[] vals) {
        int offset = this.getByteOffset() + this.getByteStride() * index;
        byte[] dst = this.buffer.getBuffer();
        for (int i = 0; i < vals.length; ++i) {
            Unsafe.putLE32(dst, offset, vals[i]);
            offset += 4;
        }
    }

    void setAttributeValue(int index, short[] vals) {
        int offset = this.getByteOffset() + this.getByteStride() * index;
        byte[] dst = this.buffer.getBuffer();
        for (int i = 0; i < vals.length; ++i) {
            Unsafe.putLE16(dst, offset, vals[i]);
            offset += 2;
        }
    }

    @Override
    public void copyFrom(GeometryAttribute attr) {
        if (this.buffer == null) {
            this.buffer = new DataBuffer();
            this.setByteStride(0);
            this.setByteOffset(0);
        }
        super.copyFrom(attr);
        PointAttribute pa = (PointAttribute)attr;
        this.numUniqueEntries = pa.numUniqueEntries;
        if (pa.indicesMap != null) {
            this.indicesMap = (int[])pa.indicesMap.clone();
        }
    }

    ByteSpan getAddress(int attIndex) {
        int byte_pos = this.getBytePos(attIndex);
        return this.buffer.asSpan().slice(byte_pos);
    }

    static final class ValueKey
    implements Comparable<ValueKey>,
    Struct<ValueKey>,
    Serializable {
        private byte[] data;
        private int offset;
        private int size;
        private long hashCode;
        static final long serialVersionUID = -1950792636L;

        public int getOffset() {
            return this.offset;
        }

        public ValueKey(PointAttribute attribute, byte[] data, int index) {
            this.size = attribute.getByteStride();
            this.offset = attribute.getByteOffset() + attribute.getByteStride() * index;
            this.data = data;
            this.hashCode = DracoUtils.hashCode(data, this.offset, this.size);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%f, ", Float.valueOf(BitUtils.getFloat(this.data, this.offset))));
            sb.append(String.format("%f, ", Float.valueOf(BitUtils.getFloat(this.data, this.offset + 4))));
            sb.append(String.format("%f", Float.valueOf(BitUtils.getFloat(this.data, this.offset + 8))));
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ValueKey)) {
                return false;
            }
            return this.compareTo((ValueKey)obj) == 0;
        }

        @Override
        public int compareTo(ValueKey rhs) {
            if (rhs.hashCode != this.hashCode) {
                return -1;
            }
            if (rhs.offset == this.offset) {
                return -1;
            }
            int ret = DracoUtils.compare(this.data, this.offset, this.data, rhs.offset, this.size);
            return ret;
        }

        public ValueKey() {
        }

        private ValueKey(ValueKey other) {
            this.data = other.data;
            this.offset = other.offset;
            this.size = other.size;
            this.hashCode = other.hashCode;
        }

        @Override
        public ValueKey clone() {
            return new ValueKey(this);
        }

        @Override
        public void copyFrom(ValueKey src) {
            if (src == null) {
                return;
            }
            this.data = src.data;
            this.offset = src.offset;
            this.size = src.size;
            this.hashCode = src.hashCode;
        }

        public int hashCode() {
            return (int)this.hashCode;
        }
    }
}

