/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DracoMesh;
import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.IMeshEdgeBreakerEncoder;
import dev.fileformat.drako.ITraversalEncoder;
import dev.fileformat.drako.RAnsBitEncoder;
import java.util.ArrayList;

class MeshEdgeBreakerTraversalEncoder
implements ITraversalEncoder {
    private static final int[] EDGE_BREAKER_TOPOLOGY_BIT_PATTERN_LENGTH = new int[]{1, 3, 0, 3, 0, 3, 0, 3};
    private RAnsBitEncoder start_face_encoder_;
    private EncoderBuffer traversalBuffer;
    IMeshEdgeBreakerEncoder encoderImpl;
    private ArrayList<Integer> symbols;
    private RAnsBitEncoder[] attributeConnectivityEncoders;

    @Override
    public void init(IMeshEdgeBreakerEncoder encoder) {
        this.encoderImpl = encoder;
    }

    @Override
    public void start() {
        DracoMesh mesh = this.encoderImpl.getEncoder().getMesh();
        this.start_face_encoder_.startEncoding();
        if (mesh.getNumAttributes() > 1) {
            this.attributeConnectivityEncoders = new RAnsBitEncoder[mesh.getNumAttributes() - 1];
            for (int i = 0; i < mesh.getNumAttributes() - 1; ++i) {
                this.attributeConnectivityEncoders[i] = new RAnsBitEncoder();
                this.attributeConnectivityEncoders[i].startEncoding();
            }
        }
    }

    @Override
    public void encodeStartFaceConfiguration(boolean interior) {
        this.start_face_encoder_.encodeBit(interior);
    }

    protected void encodeStartFaces() {
        this.start_face_encoder_.endEncoding(this.traversalBuffer);
    }

    protected void encodeTraversalSymbols() {
        this.traversalBuffer.startBitEncoding(this.encoderImpl.getEncoder().getMesh().getNumFaces() * 3, true);
        for (int i = this.symbols.size() - 1; i >= 0; --i) {
            this.traversalBuffer.encodeLeastSignificantBits32(EDGE_BREAKER_TOPOLOGY_BIT_PATTERN_LENGTH[this.symbols.get(i)], this.symbols.get(i));
        }
        this.traversalBuffer.endBitEncoding();
    }

    protected void encodeAttributeSeams() {
        if (this.attributeConnectivityEncoders != null) {
            for (int i = 0; i < this.attributeConnectivityEncoders.length; ++i) {
                this.attributeConnectivityEncoders[i].endEncoding(this.traversalBuffer);
            }
        }
    }

    @Override
    public void newCornerReached(int corner) {
    }

    @Override
    public void encodeSymbol(int symbol) {
        this.symbols.add(symbol);
    }

    @Override
    public void encodeAttributeSeam(int attribute, boolean isSeam) {
        this.attributeConnectivityEncoders[attribute].encodeBit(isSeam);
    }

    @Override
    public void done() {
        this.encodeTraversalSymbols();
        this.encodeStartFaces();
        this.encodeAttributeSeams();
    }

    @Override
    public int getNumEncodedSymbols() {
        return this.symbols.size();
    }

    @Override
    public EncoderBuffer getBuffer() {
        return this.traversalBuffer;
    }

    protected EncoderBuffer getOutputBuffer() {
        return this.traversalBuffer;
    }

    public MeshEdgeBreakerTraversalEncoder() {
        this.$initFields$();
    }

    private void $initFields$() {
        try {
            this.start_face_encoder_ = new RAnsBitEncoder();
            this.traversalBuffer = new EncoderBuffer();
            this.symbols = new ArrayList();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

