/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.BitEncoder;
import dev.fileformat.drako.BytePointer;
import dev.fileformat.drako.ByteSpan;
import dev.fileformat.drako.DataBuffer;
import dev.fileformat.drako.Encoding;
import dev.fileformat.drako.IntList;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.Unsafe;

class EncoderBuffer {
    private BitEncoder bitEncoder;
    private DataBuffer buffer;
    private long bitEncoderReservedBytes;
    private boolean encodeBitSequenceSize;

    public void encode(short val) {
        int offset = this.buffer.getLength();
        this.debugBreak(2);
        this.buffer.setLength(this.buffer.getLength() + 2);
        Unsafe.putLE16(this.buffer.getBuffer(), offset, val);
    }

    public boolean encode(byte val) {
        int offset = this.buffer.getLength();
        this.debugBreak(1);
        this.buffer.setLength(this.buffer.getLength() + 1);
        this.buffer.set(offset, val);
        return true;
    }

    public void encode(int val) {
        int offset = this.buffer.getLength();
        this.debugBreak(4);
        this.buffer.setLength(this.buffer.getLength() + 4);
        Unsafe.putLE32(this.buffer.getBuffer(), offset, val);
    }

    public void encode(float val) {
        int offset = this.buffer.getLength();
        this.debugBreak(4);
        this.buffer.setLength(this.buffer.getLength() + 4);
        Unsafe.putLE32(this.buffer.getBuffer(), offset, Unsafe.floatToUInt32(val));
    }

    public void encode(float[] val) {
        int offset = this.buffer.getLength();
        this.debugBreak(4 * val.length);
        this.buffer.setLength(this.buffer.getLength() + 4 * val.length);
        for (int i = 0; i < val.length; ++i) {
            Unsafe.putLE32(this.buffer.getBuffer(), offset, Unsafe.floatToUInt32(val[i]));
            offset += 4;
        }
    }

    public void encode(IntSpan val) {
        int offset = this.buffer.getLength();
        this.debugBreak(4 * val.size());
        this.buffer.setLength(this.buffer.getLength() + 4 * val.size());
        for (int i = 0; i < val.size(); ++i) {
            Unsafe.putLE32(this.buffer.getBuffer(), offset, val.get(i));
            offset += 4;
        }
    }

    public void encode(IntList val) {
        this.encode(val.data, val.getCount());
    }

    public void encode(int[] val) {
        this.encode(val, val.length);
    }

    public void encode(int[] val, int len) {
        int offset = this.buffer.getLength();
        this.debugBreak(4 * len);
        this.buffer.setLength(this.buffer.getLength() + 4 * len);
        for (int i = 0; i < len; ++i) {
            Unsafe.putLE32(this.buffer.getBuffer(), offset, val[i]);
            offset += 4;
        }
    }

    public void encode(byte[] buffer, int length) {
        int offset = this.buffer.getLength();
        this.debugBreak(length);
        this.buffer.setLength(this.buffer.getLength() + length);
        System.arraycopy(buffer, 0, this.buffer.getBuffer(), offset, length);
    }

    public void encode(ByteSpan buffer, int start, int length) {
        int offset = this.buffer.getLength();
        this.debugBreak(length);
        this.buffer.setLength(this.buffer.getLength() + length);
        buffer.slice(start, length).copyTo(ByteSpan.wrap(this.buffer.getBuffer()).slice(offset));
    }

    private void debugBreak(int len) {
    }

    public void clear() {
        this.buffer.clear();
        this.bitEncoderReservedBytes = 0L;
    }

    public void resize(int nbytes) {
        this.debugBreak(nbytes - this.buffer.getLength());
        this.buffer.setLength(nbytes);
    }

    public boolean startBitEncoding(int requiredBits, boolean encodeSize) {
        if (this.getBitEncoderActive()) {
            return false;
        }
        if (requiredBits <= 0) {
            return false;
        }
        this.encodeBitSequenceSize = encodeSize;
        int requiredBytes = (requiredBits + 7) / 8;
        this.bitEncoderReservedBytes = requiredBytes;
        int bufferStartSize = this.buffer.getLength();
        if (encodeSize) {
            bufferStartSize += 8;
        }
        this.debugBreak(requiredBytes);
        this.buffer.setLength(bufferStartSize + requiredBytes);
        BytePointer data = new BytePointer(this.getData(), bufferStartSize);
        this.bitEncoder = new BitEncoder(data);
        return true;
    }

    public void endBitEncoding() {
        if (!this.getBitEncoderActive()) {
            return;
        }
        long encodedBits = this.bitEncoder.getBits();
        long encodedBytes = (encodedBits + 7L) / 8L;
        if (this.encodeBitSequenceSize) {
            int out_mem = (int)((long)this.getBytes() - (this.bitEncoderReservedBytes + 8L));
            EncoderBuffer var_size_buffer = new EncoderBuffer();
            Encoding.encodeVarint(encodedBytes, var_size_buffer);
            int size_len = var_size_buffer.getBytes();
            int dst = out_mem + size_len;
            int src = out_mem + 8;
            System.arraycopy(this.getData(), src, this.getData(), dst, (int)encodedBytes);
            System.arraycopy(var_size_buffer.buffer.getBuffer(), 0, this.getData(), out_mem, size_len);
            this.bitEncoderReservedBytes += (long)(8 - size_len);
        }
        this.buffer.setLength((int)((long)this.buffer.getLength() - this.bitEncoderReservedBytes + encodedBytes));
        this.bitEncoderReservedBytes = 0L;
    }

    public boolean encodeLeastSignificantBits32(int nbits, int value) {
        if (!this.getBitEncoderActive()) {
            return false;
        }
        this.bitEncoder.putBits(value, nbits);
        return true;
    }

    public boolean getBitEncoderActive() {
        return this.bitEncoderReservedBytes > 0L;
    }

    void encode(IntSpan ints, int bytesOffset, int bytes) {
        int offset = this.buffer.getLength();
        this.buffer.setLength(this.buffer.getLength() + bytes);
        IntSpan dst = ByteSpan.wrap(this.buffer.getBuffer(), offset, bytes).asIntSpan();
        ints.slice(bytesOffset / 4, bytes / 4).copyTo(dst);
    }

    void encode(IntSpan ints, int bytes) {
        this.encode(ints, 0, bytes);
    }

    public BitEncoder getBitEncoder() {
        return this.bitEncoder;
    }

    public int getBytes() {
        return this.buffer.getLength();
    }

    public byte[] getData() {
        return this.buffer.getBuffer();
    }

    public EncoderBuffer() {
        this.$initFields$();
    }

    private void $initFields$() {
        try {
            this.buffer = new DataBuffer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void encode2(int val) {
        this.encode(val);
    }
}

