/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.DracoHeader;
import dev.fileformat.drako.DracoPointCloud;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.IntList;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.MeshDecoder;
import dev.fileformat.drako.MeshEdgeBreakerDecoder;
import dev.fileformat.drako.MeshSequentialDecoder;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.PointCloudDecoder;
import dev.fileformat.drako.PointCloudKdTreeDecoder;
import dev.fileformat.drako.PointCloudSequentialDecoder;
import java.util.ArrayList;

public class DracoMesh
extends DracoPointCloud {
    private ArrayList<AttributeData> attributeData;
    private IntList faces;

    public IntList getIndices() {
        return this.faces;
    }

    public void setCorner(int corner, int value) {
        this.faces.set(corner, value);
    }

    public int readCorner(int corner) {
        return this.faces.get(corner);
    }

    public void readFace(int faceId, int[] face) {
        int ptr = faceId * 3;
        face[0] = this.faces.get(ptr++);
        face[1] = this.faces.get(ptr++);
        face[2] = this.faces.get(ptr++);
    }

    public void readFace(int faceId, IntSpan face) {
        int ptr = faceId * 3;
        face.put(0, this.faces.get(ptr++));
        face.put(1, this.faces.get(ptr++));
        face.put(2, this.faces.get(ptr++));
    }

    public void addFace(int[] face) {
        this.faces.add(face[0]);
        this.faces.add(face[1]);
        this.faces.add(face[2]);
    }

    @Override
    public int addAttribute(PointAttribute pa) {
        AttributeData ad = new AttributeData();
        this.attributeData.add(ad);
        return super.addAttribute(pa);
    }

    public void setFace(int faceId, int[] face) {
        int[] data;
        int p;
        if (faceId >= this.getNumFaces()) {
            this.faces.resize((faceId + 1) * 3);
        }
        if ((p = faceId * 3) + 2 < (data = this.faces.data).length) {
            data[p + 0] = face[0];
            data[p + 1] = face[1];
            data[p + 2] = face[2];
        }
    }

    public int getNumFaces() {
        return this.faces.getCount() / 3;
    }

    public void setNumFaces(int value) {
        this.faces.resize(value * 3);
    }

    @Override
    void applyPointIdDeduplication(int[] idMap, IntList uniquePointIds) {
        super.applyPointIdDeduplication(idMap, uniquePointIds);
        int p = 0;
        for (int f = 0; f < this.getNumFaces(); ++f) {
            for (int c = 0; c < 3; ++c) {
                this.faces.set(p, idMap[this.faces.get(p)]);
                ++p;
            }
        }
    }

    private static MeshDecoder createMeshDecoder(int method) {
        if (method == 0) {
            return new MeshSequentialDecoder();
        }
        if (method == 1) {
            return new MeshEdgeBreakerDecoder();
        }
        return null;
    }

    private static PointCloudDecoder createPointCloudDecoder(int method) {
        if (method == 0) {
            return new PointCloudSequentialDecoder();
        }
        if (method == 1) {
            return new PointCloudKdTreeDecoder();
        }
        return null;
    }

    static DracoPointCloud decode(DecoderBuffer buffer, boolean decodeData) throws DrakoException {
        DracoHeader header = DracoHeader.parse(buffer);
        if (header == null) {
            return null;
        }
        if (header.encoderType == 1) {
            return DracoMesh.decodeMesh(buffer, header, decodeData);
        }
        if (header.encoderType == 0) {
            return DracoMesh.decodePointCloud(buffer, header, decodeData);
        }
        return null;
    }

    static DracoPointCloud decode(DecoderBuffer buffer) throws DrakoException {
        return DracoMesh.decode(buffer, true);
    }

    private static DracoPointCloud decodePointCloud(DecoderBuffer buffer, DracoHeader header, boolean decodeData) {
        buffer.setBitstreamVersion(header.version);
        PointCloudDecoder decoder = DracoMesh.createPointCloudDecoder(header.method);
        if (decoder == null) {
            return null;
        }
        try {
            DracoPointCloud ret = new DracoPointCloud();
            decoder.decode(header, buffer, ret, decodeData);
            return ret;
        }
        catch (Exception $e) {
            return null;
        }
    }

    private static DracoMesh decodeMesh(DecoderBuffer buffer, DracoHeader header, boolean decodeData) {
        buffer.setBitstreamVersion(header.version);
        MeshDecoder decoder = DracoMesh.createMeshDecoder(header.method);
        if (decoder == null) {
            return null;
        }
        try {
            DracoMesh ret = new DracoMesh();
            decoder.decode(header, buffer, ret, decodeData);
            return ret;
        }
        catch (Exception $e) {
            return null;
        }
    }

    public int getAttributeElementType(int attId) {
        return this.attributeData.get((int)attId).elementType;
    }

    public DracoMesh() {
        this.$initFields$();
    }

    private void $initFields$() {
        try {
            this.attributeData = new ArrayList();
            this.faces = new IntList();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class AttributeData {
        int elementType = 1;
    }
}

