/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;

class DracoHeader {
    public static final int METADATA_FLAG_MASK = 32768;
    private static final byte[] HEADER = new byte[]{68, 82, 65, 67, 79};
    private byte major;
    private byte minor;
    public int version;
    public short flags;
    public int encoderType;
    public int method;

    DracoHeader() {
    }

    public static DracoHeader parse(DecoderBuffer buffer) throws DrakoException {
        byte[] header = new byte[5];
        if (!buffer.decode(header)) {
            return null;
        }
        if (DracoUtils.compare(header, HEADER, HEADER.length) != 0) {
            return null;
        }
        DracoHeader ret = new DracoHeader();
        ret.encoderType = -1;
        ret.method = 0;
        ret.major = buffer.decodeU8();
        ret.minor = buffer.decodeU8();
        ret.version = ret.major * 10 + (0xFF & ret.minor);
        byte t = buffer.decodeU8();
        ret.encoderType = 0xFF & t;
        t = buffer.decodeU8();
        ret.method = 0xFF & t;
        ret.flags = buffer.decodeU16();
        return ret;
    }
}

