/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DracoCompressionLevel;
import dev.fileformat.drako.PointAttribute;

public class DracoEncodeOptions {
    private int positionBits;
    private int textureCoordinateBits;
    private int colorBits;
    private int normalBits;
    private DracoCompressionLevel compressionLevel = DracoCompressionLevel.NO_COMPRESSION;
    private boolean pointCloud;
    private boolean splitMeshOnSeams;
    private Integer symbolEncodingMethod;
    boolean useBuiltinAttributeCompression = true;

    public int getPositionBits() {
        return this.positionBits;
    }

    public void setPositionBits(int value) {
        this.positionBits = value;
    }

    public int getTextureCoordinateBits() {
        return this.textureCoordinateBits;
    }

    public void setTextureCoordinateBits(int value) {
        this.textureCoordinateBits = value;
    }

    public int getColorBits() {
        return this.colorBits;
    }

    public void setColorBits(int value) {
        this.colorBits = value;
    }

    public int getNormalBits() {
        return this.normalBits;
    }

    public void setNormalBits(int value) {
        this.normalBits = value;
    }

    public DracoCompressionLevel getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(DracoCompressionLevel value) {
        this.compressionLevel = value;
    }

    public boolean getPointCloud() {
        return this.pointCloud;
    }

    public void setPointCloud(boolean value) {
        this.pointCloud = value;
    }

    boolean getSplitMeshOnSeams() {
        return this.splitMeshOnSeams;
    }

    void setSplitMeshOnSeams(boolean value) {
        this.splitMeshOnSeams = value;
    }

    Integer getSymbolEncodingMethod() {
        return this.symbolEncodingMethod;
    }

    void setSymbolEncodingMethod(Integer value) {
        this.symbolEncodingMethod = value;
    }

    public DracoEncodeOptions() {
        this.setPositionBits(11);
        this.setTextureCoordinateBits(12);
        this.setNormalBits(10);
        this.setColorBits(10);
        this.setCompressionLevel(DracoCompressionLevel.STANDARD);
    }

    int getPredictionMethod(int geometryType, PointAttribute attr) {
        if (this.getCompressionLevel() == DracoCompressionLevel.NO_COMPRESSION) {
            return -2;
        }
        if (geometryType == 1) {
            if (attr.getAttributeType() == 3 && this.getCompressionLevel() != DracoCompressionLevel.FAST && this.getCompressionLevel() != DracoCompressionLevel.NO_COMPRESSION) {
                return 5;
            }
            if (this.getCompressionLevel() == DracoCompressionLevel.FAST) {
                return 0;
            }
            if (this.getCompressionLevel() == DracoCompressionLevel.STANDARD) {
                return 1;
            }
            return 2;
        }
        return -1;
    }

    int getQuantizationBits(PointAttribute attribute) {
        switch (attribute.getAttributeType()) {
            case 2: {
                return this.getColorBits();
            }
            case 1: {
                return this.getNormalBits();
            }
            case 0: {
                return this.getPositionBits();
            }
            case 3: {
                return this.getTextureCoordinateBits();
            }
        }
        throw new RuntimeException("Not supported quantization bits option for the specified attribute type");
    }

    int getAttributePredictionScheme(PointAttribute attribute) {
        return -1;
    }

    int getSpeed() {
        return 3;
    }

    int getCompressionLevel2() {
        switch (this.getCompressionLevel()) {
            case NO_COMPRESSION: {
                return 2;
            }
            case FAST: {
                return 6;
            }
            case STANDARD: {
                return 7;
            }
            case OPTIMAL: {
                return 10;
            }
        }
        return 7;
    }
}

