/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.DracoCompressionLevel;
import dev.fileformat.drako.DracoEncodeOptions;
import dev.fileformat.drako.DracoMesh;
import dev.fileformat.drako.DracoPointCloud;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.MeshEdgeBreakerEncoder;
import dev.fileformat.drako.MeshEncoder;
import dev.fileformat.drako.MeshSequentialEncoder;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.PointCloudEncoder;
import dev.fileformat.drako.PointCloudKdTreeEncoder;
import dev.fileformat.drako.Stream;
import java.io.IOException;

public class Draco {
    public static DracoPointCloud decode(byte[] data) throws DrakoException {
        if (data == null) {
            throw new IllegalArgumentException("Argument data cannot be null");
        }
        DecoderBuffer buffer = new DecoderBuffer(data);
        return DracoMesh.decode(buffer, true);
    }

    public static byte[] encode(DracoPointCloud m) throws DrakoException {
        return Draco.encode(m, new DracoEncodeOptions());
    }

    public static byte[] encode(DracoPointCloud m, DracoEncodeOptions options) throws DrakoException {
        if (m == null) {
            throw new IllegalArgumentException("Argument m cannot be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("Argument options cannot be null");
        }
        EncoderBuffer buf = Draco.encodeImpl(m, options);
        if (buf.getData().length == buf.getBytes()) {
            return buf.getData();
        }
        byte[] ret = new byte[buf.getBytes()];
        System.arraycopy(buf.getData(), 0, ret, 0, buf.getBytes());
        return ret;
    }

    public static void encode(DracoPointCloud m, DracoEncodeOptions options, Stream stream) throws IOException, DrakoException {
        if (m == null) {
            throw new IllegalArgumentException("Argument m cannot be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("Argument options cannot be null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("Argument stream cannot be null");
        }
        EncoderBuffer buf = Draco.encodeImpl(m, options);
        stream.write(buf.getData(), 0, buf.getBytes());
    }

    static EncoderBuffer encodeImpl(DracoPointCloud m, DracoEncodeOptions options) throws DrakoException {
        byte minorVersion;
        byte majorVersion;
        EncoderBuffer ret = new EncoderBuffer();
        PointCloudEncoder encoder = Draco.createEncoder(m, options);
        ret.encode(new byte[]{68, 82, 65, 67, 79}, 5);
        if (m instanceof DracoMesh) {
            majorVersion = 2;
            minorVersion = 2;
        } else {
            majorVersion = 2;
            minorVersion = 3;
        }
        ret.encode(majorVersion);
        ret.encode(minorVersion);
        ret.encode((byte)encoder.getGeometryType());
        ret.encode((byte)encoder.getEncodingMethod());
        ret.encode((short)0);
        encoder.encode(options, ret);
        return ret;
    }

    private static PointCloudEncoder createEncoder(DracoPointCloud pc, DracoEncodeOptions options) {
        if (pc instanceof DracoMesh && ((DracoMesh)pc).getNumFaces() > 0) {
            MeshEncoder encoder = options.getCompressionLevel() == DracoCompressionLevel.NO_COMPRESSION ? new MeshSequentialEncoder() : new MeshEdgeBreakerEncoder();
            encoder.setMesh((DracoMesh)pc);
            return encoder;
        }
        if (!Draco.isKdTreePossible(pc, options)) {
            throw new IllegalStateException("KD Tree encoder is not supported on this point cloud.");
        }
        PointCloudKdTreeEncoder ret = new PointCloudKdTreeEncoder();
        ret.setPointCloud(pc);
        return ret;
    }

    private static boolean isKdTreePossible(DracoPointCloud pc, DracoEncodeOptions options) {
        for (int i = 0; i < pc.getNumAttributes(); ++i) {
            PointAttribute att = pc.attribute(i);
            if (att.getDataType() != 9 && att.getDataType() != 6 && att.getDataType() != 4 && att.getDataType() != 2 && att.getDataType() != 5 && att.getDataType() != 3 && att.getDataType() != 1) {
                return false;
            }
            if (att.getDataType() != 9 || options.getQuantizationBits(att) > 0) continue;
            return false;
        }
        return true;
    }
}

