/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.FloatSpan;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.Internal;
import dev.fileformat.drako.Span;
import java.util.Arrays;

@Internal
class ByteSpan
extends Span {
    final byte[] array;
    public static final ByteSpan EMPTY = ByteSpan.wrap(null, 0, 0);

    public ByteSpan(byte[] array, int offset, int length) {
        super(offset, length);
        this.array = array;
    }

    public byte[] array() {
        return this.array;
    }

    public static ByteSpan wrap(byte[] array) {
        return new ByteSpan(array, 0, array.length);
    }

    public static ByteSpan wrap(byte[] array, int offset) {
        return new ByteSpan(array, offset, array.length - offset);
    }

    public static ByteSpan wrap(byte[] array, int offset, int length) {
        return new ByteSpan(array, offset, length);
    }

    public byte get(int idx) {
        this.rangeCheck(idx);
        return this.array[idx + this.offset];
    }

    public void put(int idx, byte value) {
        this.rangeCheck(idx);
        this.array[idx + this.offset] = value;
    }

    public IntSpan asIntSpan() {
        return IntSpan.wrap(this.array, this.offset, this.length);
    }

    public FloatSpan asFloatSpan() {
        return FloatSpan.wrap(this.array, this.offset, this.length);
    }

    public int compareTo(ByteSpan span) {
        int num = Math.min(this.size(), span.size());
        for (int i = 0; i < num; ++i) {
            int n = Byte.compare(this.get(i), span.get(i));
            if (n == 0) continue;
            return n;
        }
        return Integer.compare(this.size(), span.size());
    }

    public boolean equals(ByteSpan span) {
        if (this.size() != span.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == span.get(i)) continue;
            return false;
        }
        return true;
    }

    public final void copyTo(byte[] span) {
        System.arraycopy(this.array, this.offset, span, 0, this.length);
    }

    public final void copyTo(ByteSpan span) {
        System.arraycopy(this.array, this.offset, span.array, span.offset, this.length);
    }

    public final void fill(byte v) {
        Arrays.fill(this.array, this.offset, this.offset + this.length, v);
    }

    public ByteSpan slice(int offset, int size) {
        return new ByteSpan(this.array, offset + this.offset, size);
    }

    public ByteSpan slice(int offset) {
        return new ByteSpan(this.array, offset + this.offset, this.size() - offset);
    }
}

