/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.AsposeUtils;
import dev.fileformat.drako.HashBuilder;
import dev.fileformat.drako.Struct;
import dev.fileformat.drako.Unsafe;
import java.io.Serializable;

final class BytePointer
implements Struct<BytePointer>,
Serializable {
    private byte[] data;
    private int offset;
    static final long serialVersionUID = -1112298351L;

    public BytePointer(byte[] data) {
        this.data = data;
        this.offset = 0;
    }

    public BytePointer(byte[] data, int offset) {
        this.data = data;
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[] getBaseData() {
        return this.data;
    }

    public byte get(int offset) {
        return this.data[this.offset + offset];
    }

    public void set(int offset, byte value) {
        this.data[this.offset + offset] = value;
    }

    public byte toByte() {
        return this.data[this.offset];
    }

    public short toUInt16LE() {
        return Unsafe.getLE16(this.data, this.offset);
    }

    public short toUInt16LE(int offset) {
        return Unsafe.getLE16(this.data, this.offset + offset);
    }

    public int toUInt24LE(int offset) {
        return Unsafe.getLE24(this.data, this.offset + offset);
    }

    public int toUInt32LE(int offset) {
        return Unsafe.getLE32(this.data, this.offset + offset);
    }

    public long toUInt64LE(int offset) {
        return Unsafe.getLE64(this.data, this.offset + offset);
    }

    public float toSingle(int offset) {
        return Unsafe.getFloat(this.data, this.offset + offset);
    }

    public boolean isOverflow(int offset) {
        int p = offset + this.offset;
        return p >= this.data.length || p < 0;
    }

    public static BytePointer add(BytePointer ptr, int offset) {
        return new BytePointer(ptr.data, ptr.offset + offset);
    }

    public void copy(int srcOffset, byte[] dst, int dstOffset, int len) {
        System.arraycopy(this.data, this.offset + srcOffset, dst, dstOffset, len);
    }

    public String toString() {
        return String.format("byte[%d]+%d", this.data == null ? 0 : this.data.length, this.offset);
    }

    public BytePointer() {
    }

    private BytePointer(BytePointer other) {
        this.data = other.data;
        this.offset = other.offset;
    }

    @Override
    public BytePointer clone() {
        return new BytePointer(this);
    }

    @Override
    public void copyFrom(BytePointer src) {
        if (src == null) {
            return;
        }
        this.data = src.data;
        this.offset = src.offset;
    }

    public int hashCode() {
        HashBuilder builder = new HashBuilder();
        builder.hash(this.data);
        builder.hash(this.offset);
        return builder.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BytePointer)) {
            return false;
        }
        BytePointer rhs = (BytePointer)obj;
        if (!AsposeUtils.equals(this.data, rhs.data)) {
            return false;
        }
        return this.offset == rhs.offset;
    }
}

