/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.Decoding;
import dev.fileformat.drako.DracoPointCloud;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.IntList;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.PointCloudDecoder;

abstract class AttributesDecoder {
    private int[] pointAttributeIds;
    private IntList point_attribute_to_local_id_map_;
    private PointCloudDecoder pointCloudDecoder;
    private DracoPointCloud pointCloud;

    public void initialize(PointCloudDecoder decoder, DracoPointCloud pointCloud) {
        this.pointCloud = pointCloud;
        this.pointCloudDecoder = decoder;
    }

    public void decodeAttributesDecoderData(DecoderBuffer inBuffer) throws DrakoException {
        int n;
        int numAttributes = this.pointCloudDecoder.getBitstreamVersion() < 20 ? inBuffer.decodeI32() : (n = Decoding.decodeVarintU32(inBuffer));
        if (numAttributes <= 0) {
            throw DracoUtils.failed();
        }
        this.pointAttributeIds = new int[numAttributes];
        DracoPointCloud pc = this.pointCloud;
        int version = this.pointCloudDecoder.getBitstreamVersion();
        for (int i = 0; i < numAttributes; ++i) {
            byte attType = inBuffer.decodeU8();
            byte dataType = inBuffer.decodeU8();
            byte componentsCount = inBuffer.decodeU8();
            byte normalized = inBuffer.decodeU8();
            int dracoDt = 0xFF & dataType;
            PointAttribute ga = new PointAttribute();
            ga.setAttributeType(0xFF & attType);
            ga.setComponentsCount(0xFF & componentsCount);
            ga.setDataType(dracoDt);
            ga.setNormalized((0xFF & normalized) > 0);
            ga.setByteStride(DracoUtils.dataTypeLength(dracoDt) * (0xFF & componentsCount));
            short customId = version < 13 ? inBuffer.decodeU16() : Decoding.decodeVarintU16(inBuffer);
            int attId = pc.addAttribute(ga);
            ga.setUniqueId(customId);
            this.pointAttributeIds[i] = attId;
            if (attId >= this.point_attribute_to_local_id_map_.getCount()) {
                this.point_attribute_to_local_id_map_.resize(attId + 1, -1);
            }
            this.point_attribute_to_local_id_map_.set(attId, i);
        }
    }

    public void decodeAttributes(DecoderBuffer buffer) throws DrakoException {
        this.decodePortableAttributes(buffer);
        this.decodeDataNeededByPortableTransforms(buffer);
        this.transformAttributesToOriginalFormat();
    }

    protected abstract void decodePortableAttributes(DecoderBuffer var1) throws DrakoException;

    protected void decodeDataNeededByPortableTransforms(DecoderBuffer buffer) throws DrakoException {
    }

    protected void transformAttributesToOriginalFormat() throws DrakoException {
    }

    public int getAttributeId(int i) {
        return this.pointAttributeIds[i];
    }

    public int getNumAttributes() {
        return this.pointAttributeIds.length;
    }

    public PointCloudDecoder getDecoder() {
        return this.pointCloudDecoder;
    }

    public abstract PointAttribute getPortableAttribute(int var1);

    protected int getLocalIdForPointAttribute(int point_attribute_id) {
        int id_map_size = this.point_attribute_to_local_id_map_.getCount();
        if (point_attribute_id >= id_map_size) {
            return -1;
        }
        return this.point_attribute_to_local_id_map_.get(point_attribute_id);
    }

    public AttributesDecoder() {
        this.$initFields$();
    }

    private void $initFields$() {
        try {
            this.pointAttributeIds = new int[0];
            this.point_attribute_to_local_id_map_ = new IntList();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

