/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.Internal;
import dev.fileformat.drako.Out;
import dev.fileformat.drako.Stream;
import dev.fileformat.drako.StringNumber;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

@Internal
class AsposeUtils {
    private static TimeZone UTC_Timezone = TimeZone.getTimeZone("UTC");

    AsposeUtils() {
    }

    public static <T> T defaultValue(Class<?> type) {
        if (!type.isPrimitive()) {
            return null;
        }
        if (type == Byte.TYPE) {
            return (T)Byte.valueOf((byte)0);
        }
        if (type == Short.TYPE) {
            return (T)Short.valueOf((short)0);
        }
        if (type == Integer.TYPE) {
            return (T)Integer.valueOf(0);
        }
        if (type == Long.TYPE) {
            return (T)Long.valueOf(0L);
        }
        if (type == Boolean.TYPE) {
            return (T)Boolean.valueOf(false);
        }
        if (type == Character.TYPE) {
            return (T)Character.valueOf('\u0000');
        }
        if (type == Float.TYPE) {
            return (T)Float.valueOf(0.0f);
        }
        if (type == Double.TYPE) {
            return (T)Double.valueOf(0.0);
        }
        throw new IllegalStateException(String.format("Unsupported java primitive type %s", type.toString()));
    }

    public static boolean isEOF(BufferedReader r) {
        throw new RuntimeException();
    }

    public static <T> T create(Class<?> type, Object ... args) {
        throw new RuntimeException("Not implemented");
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        for (int i = fileName.length() - 1; i >= 0; --i) {
            char ch = fileName.charAt(i);
            if (ch == '/' || ch == '\\') {
                return "";
            }
            if (ch != '.') continue;
            return fileName.substring(i);
        }
        return "";
    }

    public static String getFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        for (int i = 0; i < fileName.length(); ++i) {
            char ch = fileName.charAt(i);
            if (ch != '/' && ch != '\\') continue;
            return fileName.substring(i + 1);
        }
        return fileName;
    }

    public static boolean isPathRooted(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        if (path.length() == 0) {
            return false;
        }
        if (AsposeUtils.isPathSeparator(path.charAt(0))) {
            return true;
        }
        return path.length() >= 3 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':' && AsposeUtils.isPathSeparator(path.charAt(2));
    }

    public static String combineFileName(String parent, String child) {
        if (parent == null || child == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (AsposeUtils.isPathRooted(child)) {
            return child;
        }
        StringBuilder sb = new StringBuilder(parent.length() + child.length() + 1);
        if (parent.length() > 0) {
            int end = parent.length();
            if (AsposeUtils.isPathSeparator(parent.charAt(parent.length() - 1))) {
                --end;
            }
            sb.append(parent, 0, end);
        }
        if (sb.length() > 0) {
            sb.append('/');
        }
        if (child.length() > 0) {
            int start = 0;
            if (AsposeUtils.isPathSeparator(child.charAt(0))) {
                ++start;
            }
            sb.append(child, start, child.length());
        }
        return sb.toString();
    }

    private static boolean isPathSeparator(char ch) {
        return ch == '/' || ch == '\\';
    }

    public static String getDirectoryName(String fileName) {
        if (fileName == null) {
            return null;
        }
        for (int i = fileName.length() - 1; i >= 0; --i) {
            char ch = fileName.charAt(i);
            if (ch != '/' && ch != '\\') continue;
            return fileName.substring(0, i);
        }
        return "";
    }

    public static String getFileNameWithoutExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        for (int i = fileName.length() - 1; i >= 0; --i) {
            char ch = fileName.charAt(i);
            if (ch != '/' && ch != '\\') continue;
            int p = fileName.lastIndexOf(46);
            if (p == -1 || p < i) {
                return fileName.substring(i + 1);
            }
            return fileName.substring(i + 1, p);
        }
        int p = fileName.lastIndexOf(46);
        if (p == -1) {
            return fileName;
        }
        return fileName.substring(0, p);
    }

    public static Number asNumber(Object obj) {
        if (obj instanceof Number) {
            return (Number)obj;
        }
        if (obj instanceof String) {
            return new StringNumber((String)obj);
        }
        return null;
    }

    public static boolean asBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue() != 0;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return str.equals("true") || str.equals("yes") || str.equals("on");
        }
        return false;
    }

    public static boolean castableToNumber(Object obj) {
        if (obj instanceof Number) {
            return true;
        }
        return obj instanceof String;
    }

    public static byte[] toArray(InputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Invalid input stream");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        AsposeUtils.copyTo(input, out);
        return out.toByteArray();
    }

    public static int copyTo(Stream input, Stream output) throws IOException {
        int bytesRead;
        if (input == null) {
            throw new IllegalArgumentException("Invalid input stream");
        }
        if (output == null) {
            throw new IllegalArgumentException("Invalid output stream");
        }
        byte[] tmp = new byte[10240];
        int ret = 0;
        while ((bytesRead = input.read(tmp)) > 0) {
            ret += bytesRead;
            output.write(tmp, 0, bytesRead);
        }
        return ret;
    }

    public static int copyTo(InputStream input, OutputStream output) throws IOException {
        int bytesRead;
        if (input == null) {
            throw new IllegalArgumentException("Invalid input stream");
        }
        if (output == null) {
            throw new IllegalArgumentException("Invalid output stream");
        }
        byte[] tmp = new byte[10240];
        int ret = 0;
        while ((bytesRead = input.read(tmp)) > 0) {
            ret += bytesRead;
            output.write(tmp, 0, bytesRead);
        }
        return ret;
    }

    public static <E> void copyTo(Collection<E> src, int srcOffset, E[] dst, int offset, int size) {
        if (src instanceof List) {
            List list = (List)src;
            for (int i = 0; i < size; ++i) {
                dst[offset + i] = list.get(i + srcOffset);
            }
        } else {
            int p = offset;
            int rest = size;
            for (E e : src) {
                if (srcOffset > 0) {
                    --srcOffset;
                    continue;
                }
                if (rest-- > 0) {
                    dst[p++] = e;
                    continue;
                }
                break;
            }
        }
    }

    public static <E> void copyTo(Collection<E> src, E[] dst, int offset, int size) {
        AsposeUtils.copyTo(src, 0, dst, offset, size);
    }

    public static <E> void copyTo(Collection<E> src, E[] dst, int offset) {
        AsposeUtils.copyTo(src, dst, offset, src.size());
    }

    public static Calendar toUTC(Calendar cal) {
        Calendar ret = Calendar.getInstance(UTC_Timezone);
        ret.setTimeInMillis(cal.getTimeInMillis());
        return ret;
    }

    public static boolean tryGetValue(Map<Integer, Integer> map, int key, @Out int[] ret) {
        Integer v = map.get(key);
        if (v != null) {
            ret[0] = v;
        }
        return v != null;
    }

    public static <K, V> boolean tryGetValue(Map<K, V> map, K key, @Out V[] ret) {
        ret[0] = map.get(key);
        return ret[0] != null;
    }

    public static void safeClose(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean equals(StringBuilder a, StringBuilder b) {
        if (a == b) {
            return true;
        }
        if (a.length() != b.length()) {
            return false;
        }
        int len = a.length();
        for (int i = 0; i < len; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static String readString(Path path) throws IOException {
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Invalid path");
        }
        byte[] bytes = Files.readAllBytes(path);
        return StandardCharsets.UTF_8.decode(ByteBuffer.wrap(bytes)).toString();
    }

    public static int charsFromBytes(Charset charset, byte[] bytes, int offset, int numBytes, char[] result, int resultOffset) {
        ByteBuffer input = ByteBuffer.wrap(bytes, offset, numBytes);
        CharBuffer chars = charset.decode(input);
        int numChars = Math.min(chars.limit(), result.length - resultOffset);
        chars.get(result, 0, numChars);
        return numChars;
    }

    public static List<String> parseCommandLineArguments(String ... commandLine) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < commandLine.length; ++i) {
            AsposeUtils.parseCommandLineArgumentsImpl(ret, commandLine[i]);
        }
        return ret;
    }

    private static void parseCommandLineArgumentsImpl(List<String> ret, String commandLine) {
        for (int i = 0; i < commandLine.length(); ++i) {
            char ch = commandLine.charAt(i);
            if (ch == '\'' || ch == '\"') {
                char quote = ch;
                int start = ++i;
                while (i < commandLine.length() && (ch = commandLine.charAt(i)) != quote) {
                    ++i;
                }
                String segment = commandLine.substring(start, i);
                ret.add(segment);
                continue;
            }
            if (Character.isWhitespace(ch)) continue;
            int start = i;
            while (i < commandLine.length() && !Character.isWhitespace(ch = commandLine.charAt(i))) {
                ++i;
            }
            String segment = commandLine.substring(start, i);
            ret.add(segment);
        }
    }
}

