/*
 * Decompiled with CFR 0.152.
 */
package dev.failsafe.retrofit;

import dev.failsafe.Call;
import dev.failsafe.ExecutionContext;
import dev.failsafe.Failsafe;
import dev.failsafe.FailsafeException;
import dev.failsafe.FailsafeExecutor;
import dev.failsafe.Policy;
import dev.failsafe.internal.util.Assert;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import retrofit2.Callback;
import retrofit2.Response;

public final class FailsafeCall<R> {
    private final FailsafeExecutor<Response<R>> failsafe;
    private final retrofit2.Call<R> initialCall;
    private volatile Call<Response<R>> failsafeCall;
    private volatile CompletableFuture<Response<R>> failsafeFuture;
    private AtomicBoolean cancelled = new AtomicBoolean();
    private AtomicBoolean executed = new AtomicBoolean();

    private FailsafeCall(FailsafeExecutor<Response<R>> failsafe, retrofit2.Call<R> call) {
        this.failsafe = failsafe;
        this.initialCall = call;
    }

    @SafeVarargs
    public static <R, P extends Policy<Response<R>>> FailsafeCallBuilder<R> with(P outerPolicy, P ... policies) {
        return new FailsafeCallBuilder(Failsafe.with(outerPolicy, policies));
    }

    public static <R> FailsafeCallBuilder<R> with(FailsafeExecutor<Response<R>> failsafeExecutor) {
        return new FailsafeCallBuilder((FailsafeExecutor)Assert.notNull(failsafeExecutor, (String)"failsafeExecutor"));
    }

    public void cancel() {
        if (!this.cancelled.compareAndSet(false, true)) {
            return;
        }
        if (this.failsafeCall != null) {
            this.failsafeCall.cancel(false);
        }
        if (this.failsafeFuture != null) {
            this.failsafeFuture.cancel(false);
        }
    }

    public FailsafeCall<R> clone() {
        return new FailsafeCall<R>(this.failsafe, this.initialCall.clone());
    }

    public Response<R> execute() throws IOException {
        Assert.isTrue((boolean)this.executed.compareAndSet(false, true), (String)"already executed", (Object[])new Object[0]);
        this.failsafeCall = this.failsafe.newCall(ctx -> this.prepareCall(ctx).execute());
        try {
            return (Response)this.failsafeCall.execute();
        }
        catch (FailsafeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public CompletableFuture<Response<R>> executeAsync() {
        if (!this.executed.compareAndSet(false, true)) {
            CompletableFuture<Response<R>> result = new CompletableFuture<Response<R>>();
            result.completeExceptionally(new IllegalStateException("already executed"));
            return result;
        }
        this.failsafeFuture = this.failsafe.getAsyncExecution(exec -> this.prepareCall((ExecutionContext<Response<R>>)exec).enqueue(new Callback<R>(){

            public void onResponse(retrofit2.Call<R> call, Response<R> response) {
                exec.recordResult(response);
            }

            public void onFailure(retrofit2.Call<R> call, Throwable throwable) {
                exec.recordException(throwable);
            }
        }));
        return this.failsafeFuture;
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    public boolean isExecuted() {
        return this.executed.get();
    }

    private retrofit2.Call<R> prepareCall(ExecutionContext<Response<R>> ctx) {
        retrofit2.Call call = ctx.isFirstAttempt() ? this.initialCall : this.initialCall.clone();
        ctx.onCancel(() -> {
            this.cancelled.set(true);
            call.cancel();
        });
        return call;
    }

    public static final class FailsafeCallBuilder<R> {
        private FailsafeExecutor<Response<R>> failsafe;

        private FailsafeCallBuilder(FailsafeExecutor<Response<R>> failsafe) {
            this.failsafe = failsafe;
        }

        public <P extends Policy<Response<R>>> FailsafeCallBuilder<R> compose(P innerPolicy) {
            this.failsafe = this.failsafe.compose(innerPolicy);
            return this;
        }

        public FailsafeCall<R> compose(retrofit2.Call<R> call) {
            return new FailsafeCall(this.failsafe, call);
        }
    }
}

