/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class SignedJars {
    private static final List<String> needsStrip = List.of("org.eclipse.m2e.maven.indexer_1.18.1.20211011-2139.jar");

    static File strippedFile(File f) {
        return new File(f.getAbsolutePath() + "-stripped-sig.jar");
    }

    public static void stripIfNecessary(ArrayList<File> file) {
        SignedJars.stripIf(file, needsStrip::contains);
    }

    public static void stripIf(ArrayList<File> file, Predicate<String> fileNamesToStrip) {
        file.replaceAll(f -> {
            if (fileNamesToStrip.test(f.getName())) {
                File strippedJar = SignedJars.strippedFile(f);
                try {
                    byte[] strippedBytes = SignedJars.readAndStripInMemory(f);
                    if (!strippedJar.exists() || strippedJar.length() != (long)strippedBytes.length) {
                        Files.write(strippedJar.toPath(), strippedBytes, new OpenOption[0]);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return strippedJar;
            }
            return f;
        });
    }

    private static byte[] readAndStripInMemory(File input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (ZipInputStream zipInput = new ZipInputStream(new BufferedInputStream(new FileInputStream(input)));
             ZipOutputStream zipOutput = new ZipOutputStream(output);){
            ZipEntry entry;
            while ((entry = zipInput.getNextEntry()) != null) {
                if (entry.getName().endsWith(".SF") || entry.getName().endsWith(".RSA") || entry.getName().endsWith(".DSA")) continue;
                ZipEntry newEntry = new ZipEntry(entry);
                newEntry.setCompressedSize(-1L);
                zipOutput.putNextEntry(newEntry);
                zipInput.transferTo(zipOutput);
                zipInput.closeEntry();
                zipOutput.closeEntry();
            }
        }
        return output.toByteArray();
    }

    public static void main(String[] args) throws IOException {
        String troublePackage = "org.apache.lucene.document.";
        File cp = new File("/Users/ntwigg/Downloads/cp.txt");
        List<String> lines = Files.readAllLines(cp.toPath());
        String troubleF = troublePackage.replace('.', '/');
        String troubleB = troublePackage.replace('.', '\\');
        for (String line : lines) {
            try (JarFile f = new JarFile(new File(line));){
                boolean containsPkg = f.stream().anyMatch(e -> e.getName().startsWith(troubleF) || e.getName().startsWith(troubleB));
                if (!containsPkg) continue;
                System.out.println(line + " contains " + troublePackage);
            }
        }
    }
}

