/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice;

import dev.equo.solstice.Unimplemented;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;

class Dictionaries {
    Dictionaries() {
    }

    public static <K, V> Dictionary<K, V> empty() {
        return EmptyDictionary.INSTANCE;
    }

    public static <K, V> Dictionary<K, V> of(K k, V v) {
        Hashtable<K, V> table = new Hashtable<K, V>();
        table.put(k, v);
        return table;
    }

    public static <K, V> Dictionary<K, V> copy(Dictionary<K, V> in) {
        if (in.isEmpty()) {
            return new Hashtable();
        }
        Hashtable<K, V> table = new Hashtable<K, V>();
        Enumeration<K> keys = in.keys();
        while (keys.hasMoreElements()) {
            K key = keys.nextElement();
            table.put(key, in.get(key));
        }
        return table;
    }

    private static class EmptyDictionary<K, V>
    extends Dictionary<K, V> {
        private final Hashtable<K, V> backing = new Hashtable();
        private static final EmptyDictionary INSTANCE = new EmptyDictionary();

        private EmptyDictionary() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Enumeration<K> keys() {
            return this.backing.keys();
        }

        @Override
        public Enumeration<V> elements() {
            return this.backing.elements();
        }

        @Override
        public V get(Object key) {
            return null;
        }

        @Override
        public V put(K key, V value) {
            throw Unimplemented.onPurpose();
        }

        @Override
        public V remove(Object key) {
            throw Unimplemented.onPurpose();
        }

        public int hashCode() {
            return this.backing.hashCode();
        }

        public boolean equals(Object other) {
            return this.backing.equals(other);
        }
    }
}

