/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.error.AuthFailureError;
import com.android.volley.request.MultiPartRequest;
import com.android.volley.toolbox.HttpStack;
import com.android.volley.toolbox.multipart.FilePart;
import com.android.volley.toolbox.multipart.MultipartProgressEntity;
import com.android.volley.toolbox.multipart.StringPart;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class HttpClientStack
implements HttpStack {
    protected final HttpClient mClient;
    private static final String CONTENT_TYPE_MULTIPART = "multipart/form-data; charset=%s; boundary=%s";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";

    public HttpClientStack(HttpClient client) {
        this.mClient = client;
    }

    private static void addHeaders(HttpUriRequest httpRequest, Map<String, String> headers) {
        for (String key : headers.keySet()) {
            httpRequest.setHeader(key, headers.get(key));
        }
    }

    private static List<NameValuePair> getPostParameterPairs(Map<String, String> postParams) {
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>(postParams.size());
        for (String key : postParams.keySet()) {
            result.add((NameValuePair)new BasicNameValuePair(key, postParams.get(key)));
        }
        return result;
    }

    @Override
    public HttpResponse performRequest(Request<?> request, Map<String, String> additionalHeaders) throws IOException, AuthFailureError {
        HttpUriRequest httpRequest = HttpClientStack.createHttpRequest(request, additionalHeaders);
        HttpClientStack.addHeaders(httpRequest, additionalHeaders);
        HttpClientStack.addHeaders(httpRequest, request.getHeaders());
        this.onPrepareRequest(httpRequest);
        HttpParams httpParams = httpRequest.getParams();
        int timeoutMs = request.getTimeoutMs();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)5000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)timeoutMs);
        return this.mClient.execute(httpRequest);
    }

    static HttpUriRequest createHttpRequest(Request<?> request, Map<String, String> additionalHeaders) throws AuthFailureError, IOException {
        switch (request.getMethod()) {
            case -1: {
                byte[] postBody = request.getPostBody();
                if (postBody != null) {
                    HttpPost postRequest = new HttpPost(request.getUrl());
                    postRequest.addHeader(HEADER_CONTENT_TYPE, request.getPostBodyContentType());
                    ByteArrayEntity entity = new ByteArrayEntity(postBody);
                    postRequest.setEntity((HttpEntity)entity);
                    return postRequest;
                }
                return new HttpGet(request.getUrl());
            }
            case 0: {
                return new HttpGet(request.getUrl());
            }
            case 3: {
                return new HttpDelete(request.getUrl());
            }
            case 1: {
                HttpPost postRequest = new HttpPost(request.getUrl());
                HttpClientStack.setEntityIfNonEmptyBody((HttpEntityEnclosingRequestBase)postRequest, request);
                return postRequest;
            }
            case 2: {
                HttpPut putRequest = new HttpPut(request.getUrl());
                putRequest.addHeader(HEADER_CONTENT_TYPE, request.getBodyContentType());
                HttpClientStack.setEntityIfNonEmptyBody((HttpEntityEnclosingRequestBase)putRequest, request);
                return putRequest;
            }
            case 4: {
                return new HttpHead(request.getUrl());
            }
            case 5: {
                return new HttpOptions(request.getUrl());
            }
            case 6: {
                return new HttpTrace(request.getUrl());
            }
            case 7: {
                HttpPatch patchRequest = new HttpPatch(request.getUrl());
                HttpClientStack.setEntityIfNonEmptyBody(patchRequest, request);
                return patchRequest;
            }
        }
        throw new IllegalStateException("Unknown request method.");
    }

    private static void setEntityIfNonEmptyBody(HttpEntityEnclosingRequestBase httpRequest, Request<?> request) throws IOException, AuthFailureError {
        if (request instanceof MultiPartRequest) {
            Response.ProgressListener progressListener = null;
            if (request instanceof Response.ProgressListener) {
                progressListener = (Response.ProgressListener)((Object)request);
            }
            MultipartProgressEntity multipartEntity = new MultipartProgressEntity();
            multipartEntity.setListener(progressListener);
            String charset = ((MultiPartRequest)request).getProtocolCharset();
            httpRequest.addHeader(HEADER_CONTENT_TYPE, String.format(CONTENT_TYPE_MULTIPART, charset, multipartEntity.getBoundary()));
            Map<String, MultiPartRequest.MultiPartParam> multipartParams = ((MultiPartRequest)request).getMultipartParams();
            Map<String, String> filesToUpload = ((MultiPartRequest)request).getFilesToUpload();
            for (String key : multipartParams.keySet()) {
                multipartEntity.addPart(new StringPart(key, multipartParams.get((Object)key).value));
            }
            for (String key : filesToUpload.keySet()) {
                File file = new File(filesToUpload.get(key));
                if (!file.exists()) {
                    throw new IOException(String.format("File not found: %s", file.getAbsolutePath()));
                }
                if (file.isDirectory()) {
                    throw new IOException(String.format("File is a directory: %s", file.getAbsolutePath()));
                }
                FilePart filePart = new FilePart(key, file, null, null);
                multipartEntity.addPart(filePart);
            }
            httpRequest.setEntity((HttpEntity)multipartEntity);
        } else {
            httpRequest.addHeader(HEADER_CONTENT_TYPE, request.getBodyContentType());
            byte[] body = request.getBody();
            if (body != null) {
                ByteArrayEntity entity = new ByteArrayEntity(body);
                httpRequest.setEntity((HttpEntity)entity);
            }
        }
    }

    protected void onPrepareRequest(HttpUriRequest request) throws IOException {
    }

    public static final class HttpPatch
    extends HttpEntityEnclosingRequestBase {
        public static final String METHOD_NAME = "PATCH";

        public HttpPatch() {
        }

        public HttpPatch(URI uri) {
            this.setURI(uri);
        }

        public HttpPatch(String uri) {
            this.setURI(URI.create(uri));
        }

        public String getMethod() {
            return METHOD_NAME;
        }
    }
}

