/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.misc;

import android.annotation.TargetApi;
import android.util.Log;
import com.android.volley.misc.Trace;
import com.android.volley.misc.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class InputStreamBuffer {
    private static final boolean DEBUG = false;
    private static final int DEBUG_MAX_BUFFER_SIZE = 80;
    private static final String TAG = "InputStreamBuffer";
    private InputStream mInputStream;
    private byte[] mBuffer;
    private boolean mAutoAdvance;
    private int mOffset = 0;
    private int mFilled = 0;

    public InputStreamBuffer(InputStream inputStream, int bufferSize, boolean autoAdvance) {
        this.mInputStream = inputStream;
        if (bufferSize <= 0) {
            throw new IllegalArgumentException(String.format("Buffer size %d must be positive.", bufferSize));
        }
        bufferSize = InputStreamBuffer.leastPowerOf2(bufferSize);
        this.mBuffer = new byte[bufferSize];
        this.mAutoAdvance = autoAdvance;
    }

    public byte get(int index) throws IllegalStateException, IndexOutOfBoundsException {
        Trace.beginSection("get");
        if (this.has(index)) {
            int i = index - this.mOffset;
            Trace.endSection();
            return this.mBuffer[i];
        }
        Trace.endSection();
        throw new IndexOutOfBoundsException(String.format("Index %d beyond length.", index));
    }

    public boolean has(int index) throws IllegalStateException, IndexOutOfBoundsException {
        Trace.beginSection("has");
        if (index < this.mOffset) {
            Trace.endSection();
            throw new IllegalStateException(String.format("Index %d is before buffer %d", index, this.mOffset));
        }
        int i = index - this.mOffset;
        if (i >= this.mFilled || i >= this.mBuffer.length) {
            Trace.endSection();
            return this.fill(index);
        }
        Trace.endSection();
        return true;
    }

    public void advanceTo(int index) throws IllegalStateException, IndexOutOfBoundsException {
        Trace.beginSection("advance to");
        int i = index - this.mOffset;
        if (i <= 0) {
            Trace.endSection();
            return;
        }
        if (i < this.mFilled) {
            this.shiftToBeginning(i);
            this.mOffset = index;
            this.mFilled -= i;
        } else if (this.mInputStream != null) {
            int burn = i - this.mFilled;
            boolean empty = false;
            int fails = 0;
            try {
                while (burn > 0) {
                    long burned = this.mInputStream.skip(burn);
                    if (burned <= 0L) {
                        ++fails;
                    } else {
                        burn = (int)((long)burn - burned);
                    }
                    if (fails < 5) continue;
                    empty = true;
                    break;
                }
            }
            catch (IOException ignored) {
                empty = true;
            }
            if (empty) {
                this.mInputStream = null;
            }
            this.mOffset = index - burn;
            this.mFilled = 0;
        } else {
            this.mOffset = index;
            this.mFilled = 0;
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)String.format("advanceTo %d buffer: %s", i, this));
        }
        Trace.endSection();
    }

    private boolean fill(int index) {
        Trace.beginSection("fill");
        if (index < this.mOffset) {
            Trace.endSection();
            throw new IllegalStateException(String.format("Index %d is before buffer %d", index, this.mOffset));
        }
        int i = index - this.mOffset;
        if (this.mInputStream == null) {
            Trace.endSection();
            return false;
        }
        int length = i + 1;
        if (length > this.mBuffer.length) {
            if (this.mAutoAdvance) {
                this.advanceTo(index);
                i = index - this.mOffset;
            } else {
                length = InputStreamBuffer.leastPowerOf2(length);
                Log.w((String)TAG, (String)String.format("Increasing buffer length from %d to %d. Bad buffer size chosen, or advanceTo() not called.", this.mBuffer.length, length));
                this.mBuffer = InputStreamBuffer.copyOf(this.mBuffer, length);
            }
        }
        int read = -1;
        try {
            read = this.mInputStream.read(this.mBuffer, this.mFilled, this.mBuffer.length - this.mFilled);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        if (read != -1) {
            this.mFilled += read;
        } else {
            this.mInputStream = null;
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)String.format("fill %d      buffer: %s", i, this));
        }
        Trace.endSection();
        return i < this.mFilled;
    }

    @TargetApi(value=9)
    public static byte[] copyOf(byte[] original, int newLength) {
        byte[] copy;
        if (Utils.hasGingerbread()) {
            copy = Arrays.copyOf(original, newLength);
        } else {
            copy = new byte[newLength];
            System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        }
        return copy;
    }

    private void shiftToBeginning(int i) {
        if (i >= this.mBuffer.length) {
            throw new IndexOutOfBoundsException(String.format("Index %d out of bounds. Length %d", i, this.mBuffer.length));
        }
        int j = 0;
        while (j + i < this.mFilled) {
            this.mBuffer[j] = this.mBuffer[j + i];
            ++j;
        }
    }

    public String toString() {
        return String.format("+%d+%d [%d]", this.mOffset, this.mBuffer.length, this.mFilled);
    }

    public String toDebugString() {
        Trace.beginSection("to debug string");
        StringBuilder sb = new StringBuilder();
        sb.append("+").append(this.mOffset);
        sb.append("+").append(this.mBuffer.length);
        sb.append(" [");
        for (int i = 0; i < this.mBuffer.length && i < 80; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            if (i < this.mFilled) {
                sb.append(String.format("%02X", this.mBuffer[i]));
                continue;
            }
            sb.append("__");
        }
        if (this.mInputStream != null) {
            sb.append("...");
        }
        sb.append("]");
        Trace.endSection();
        return sb.toString();
    }

    private static int leastPowerOf2(int n) {
        --n;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return ++n;
    }
}

