/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.error;

import android.content.Context;
import com.android.volley.NetworkResponse;
import com.android.volley.R;
import com.android.volley.error.AuthFailureError;
import com.android.volley.error.NetworkError;
import com.android.volley.error.NoConnectionError;
import com.android.volley.error.ParseError;
import com.android.volley.error.ServerError;
import com.android.volley.error.TimeoutError;
import com.android.volley.error.VolleyError;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.Map;

public class VolleyErrorHelper {
    public static String getMessage(Object error, Context context) {
        if (error instanceof TimeoutError) {
            return context.getResources().getString(R.string.generic_server_down);
        }
        if (VolleyErrorHelper.isServerProblem(error)) {
            return VolleyErrorHelper.handleServerError(error, context);
        }
        if (VolleyErrorHelper.isNetworkProblem(error)) {
            return context.getResources().getString(R.string.no_internet);
        }
        return context.getResources().getString(R.string.generic_error);
    }

    public static String getErrorType(Object error, Context context) {
        if (error instanceof TimeoutError) {
            return context.getResources().getString(R.string.generic_server_timeout);
        }
        if (error instanceof ServerError) {
            return context.getResources().getString(R.string.generic_server_down);
        }
        if (error instanceof AuthFailureError) {
            return context.getResources().getString(R.string.auth_failed);
        }
        if (error instanceof NetworkError) {
            return context.getResources().getString(R.string.no_internet);
        }
        if (error instanceof NoConnectionError) {
            return context.getResources().getString(R.string.no_network_connection);
        }
        if (error instanceof ParseError) {
            return context.getResources().getString(R.string.parsing_failed);
        }
        return context.getResources().getString(R.string.generic_error);
    }

    private static boolean isNetworkProblem(Object error) {
        return error instanceof NetworkError || error instanceof NoConnectionError;
    }

    private static boolean isServerProblem(Object error) {
        return error instanceof ServerError || error instanceof AuthFailureError;
    }

    private static String handleServerError(Object err, Context context) {
        VolleyError error = (VolleyError)err;
        NetworkResponse response = error.networkResponse;
        if (response != null) {
            switch (response.statusCode) {
                case 401: 
                case 404: 
                case 422: {
                    try {
                        HashMap result = (HashMap)new Gson().fromJson(new String(response.data), new TypeToken<Map<String, String>>(){}.getType());
                        if (result != null && result.containsKey("error")) {
                            return (String)result.get("error");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return error.getMessage();
                }
            }
            return context.getResources().getString(R.string.generic_server_down);
        }
        return context.getResources().getString(R.string.generic_error);
    }
}

