/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.cache.plus;

import android.content.ContentResolver;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.util.ArrayMap;
import android.widget.ImageView;
import com.android.volley.Cache;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.cache.plus.BitmapImageCache;
import com.android.volley.cache.plus.ImageCache;
import com.android.volley.cache.plus.ImageRequest;
import com.android.volley.error.VolleyError;
import com.android.volley.misc.Utils;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.ui.RecyclingBitmapDrawable;
import java.util.LinkedList;
import java.util.Map;

public class ImageLoader {
    private final RequestQueue mRequestQueue;
    private int mBatchResponseDelayMs = 100;
    private final ImageCache mCache;
    private final ArrayMap<String, BatchedImageRequest> mInFlightRequests = new ArrayMap();
    private final ArrayMap<String, BatchedImageRequest> mBatchedResponses = new ArrayMap();
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private Runnable mRunnable;
    private Resources mResources;
    private ContentResolver mContentResolver;
    private ArrayMap<String, String> mHeaders;

    public ImageLoader(RequestQueue queue) {
        this(queue, BitmapImageCache.getInstance(null));
    }

    public ImageLoader(RequestQueue queue, ImageCache imageCache) {
        this(queue, imageCache, null);
    }

    public ImageLoader(RequestQueue queue, ImageCache imageCache, Resources resources) {
        this.mRequestQueue = queue;
        this.mCache = imageCache;
        this.mResources = resources;
    }

    protected RequestQueue getRequestQueue() {
        return this.mRequestQueue;
    }

    protected ImageCache getImageCache() {
        return this.mCache;
    }

    protected Cache getCache() {
        return this.mRequestQueue.getCache();
    }

    public static ImageListener getImageListener(final ImageView view, final int defaultImageResId, final int errorImageResId) {
        return new ImageListener(){

            @Override
            public void onErrorResponse(VolleyError error) {
                if (errorImageResId != 0) {
                    view.setImageResource(errorImageResId);
                }
            }

            @Override
            public void onResponse(ImageContainer response, boolean isImmediate) {
                if (response.getBitmap() != null) {
                    view.setImageDrawable((Drawable)response.getBitmap());
                } else if (defaultImageResId != 0) {
                    view.setImageResource(defaultImageResId);
                }
            }
        };
    }

    public boolean isCached(String requestUrl, int maxWidth, int maxHeight) {
        this.throwIfNotOnMainThread();
        String cacheKey = ImageLoader.getCacheKey(requestUrl, maxWidth, maxHeight);
        return this.mCache.getBitmap(cacheKey) != null;
    }

    public ImageContainer get(String requestUrl, ImageListener listener) {
        return this.get(requestUrl, listener, 0, 0);
    }

    public ImageContainer get(String requestUrl, ImageListener imageListener, int maxWidth, int maxHeight) {
        this.throwIfNotOnMainThread();
        String cacheKey = ImageLoader.getCacheKey(requestUrl, maxWidth, maxHeight);
        BitmapDrawable cachedBitmap = this.mCache.getBitmap(cacheKey);
        if (cachedBitmap != null) {
            ImageContainer container = new ImageContainer(cachedBitmap, requestUrl, null, null);
            imageListener.onResponse(container, true);
            return container;
        }
        ImageContainer imageContainer = new ImageContainer(null, requestUrl, cacheKey, imageListener);
        imageListener.onResponse(imageContainer, true);
        BatchedImageRequest request = (BatchedImageRequest)this.mInFlightRequests.get((Object)cacheKey);
        if (request != null) {
            request.addContainer(imageContainer);
            return imageContainer;
        }
        Request<?> newRequest = this.makeImageRequest(requestUrl, maxWidth, maxHeight, cacheKey);
        newRequest.setHeaders((Map<String, String>)this.mHeaders);
        this.mRequestQueue.add(newRequest);
        this.mInFlightRequests.put((Object)cacheKey, (Object)new BatchedImageRequest(newRequest, imageContainer));
        return imageContainer;
    }

    public ImageContainer set(String requestUrl, ImageListener imageListener, int maxWidth, int maxHeight, Bitmap bitmap) {
        this.throwIfNotOnMainThread();
        String cacheKey = ImageLoader.getCacheKey(requestUrl, maxWidth, maxHeight);
        Object drawable = Utils.hasHoneycomb() ? new BitmapDrawable(this.mResources, bitmap) : new RecyclingBitmapDrawable(this.mResources, bitmap);
        ImageContainer imageContainer = new ImageContainer((BitmapDrawable)drawable, requestUrl, cacheKey, imageListener);
        imageListener.onResponse(imageContainer, true);
        this.mCache.putBitmap(cacheKey, (BitmapDrawable)drawable);
        Response<Bitmap> response = Response.success(bitmap, HttpHeaderParser.parseBitmapCacheHeaders(bitmap));
        this.getCache().put(requestUrl, response.cacheEntry);
        return imageContainer;
    }

    protected Request<?> makeImageRequest(String requestUrl, int maxWidth, int maxHeight, final String cacheKey) {
        return new ImageRequest(requestUrl, this.mResources, this.mContentResolver, new Response.Listener<BitmapDrawable>(){

            @Override
            public void onResponse(BitmapDrawable response) {
                ImageLoader.this.onGetImageSuccess(cacheKey, response);
            }
        }, maxWidth, maxHeight, Bitmap.Config.RGB_565, new Response.ErrorListener(){

            @Override
            public void onErrorResponse(VolleyError error) {
                ImageLoader.this.onGetImageError(cacheKey, error);
            }
        });
    }

    public void setBatchedResponseDelay(int newBatchedResponseDelayMs) {
        this.mBatchResponseDelayMs = newBatchedResponseDelayMs;
    }

    protected void onGetImageSuccess(String cacheKey, BitmapDrawable response) {
        this.mCache.putBitmap(cacheKey, response);
        BatchedImageRequest request = (BatchedImageRequest)this.mInFlightRequests.remove((Object)cacheKey);
        if (request != null) {
            request.mResponseBitmap = response;
            this.batchResponse(cacheKey, request);
        }
    }

    protected void setImageSuccess(String cacheKey, BitmapDrawable response) {
        this.mCache.putBitmap(cacheKey, response);
        BatchedImageRequest request = (BatchedImageRequest)this.mInFlightRequests.remove((Object)cacheKey);
        if (request != null) {
            request.mResponseBitmap = response;
            this.batchResponse(cacheKey, request);
        }
    }

    protected void onGetImageError(String cacheKey, VolleyError error) {
        BatchedImageRequest request = (BatchedImageRequest)this.mInFlightRequests.remove((Object)cacheKey);
        if (request != null) {
            request.setError(error);
            this.batchResponse(cacheKey, request);
        }
    }

    private void batchResponse(String cacheKey, BatchedImageRequest request) {
        this.mBatchedResponses.put((Object)cacheKey, (Object)request);
        if (this.mRunnable == null) {
            this.mRunnable = new Runnable(){

                @Override
                public void run() {
                    for (BatchedImageRequest bir : ImageLoader.this.mBatchedResponses.values()) {
                        for (ImageContainer container : bir.mContainers) {
                            if (container.mListener == null) continue;
                            if (bir.getError() == null) {
                                container.mBitmap = bir.mResponseBitmap;
                                container.mListener.onResponse(container, false);
                                continue;
                            }
                            container.mListener.onErrorResponse(bir.getError());
                        }
                    }
                    ImageLoader.this.mBatchedResponses.clear();
                    ImageLoader.this.mRunnable = null;
                }
            };
            this.mHandler.postDelayed(this.mRunnable, (long)this.mBatchResponseDelayMs);
        }
    }

    private void throwIfNotOnMainThread() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("ImageLoader must be invoked from the main thread.");
        }
    }

    protected static String getCacheKey(String url, int maxWidth, int maxHeight) {
        return new StringBuilder(url.length() + 12).append("#W").append(maxWidth).append("#H").append(maxHeight).append(url).toString();
    }

    public void setResources(Resources resources) {
        this.mResources = resources;
    }

    public Resources getResources() {
        return this.mResources;
    }

    public void setResources(ContentResolver contentResolver) {
        this.mContentResolver = contentResolver;
    }

    public ContentResolver getContentResolver() {
        return this.mContentResolver;
    }

    public void setHeaders(ArrayMap<String, String> headers) {
        this.mHeaders = headers;
    }

    private class BatchedImageRequest {
        private final Request<?> mRequest;
        private BitmapDrawable mResponseBitmap;
        private VolleyError mError;
        private final LinkedList<ImageContainer> mContainers = new LinkedList();

        public BatchedImageRequest(Request<?> request, ImageContainer container) {
            this.mRequest = request;
            this.mContainers.add(container);
        }

        public void setError(VolleyError error) {
            this.mError = error;
        }

        public VolleyError getError() {
            return this.mError;
        }

        public void addContainer(ImageContainer container) {
            this.mContainers.add(container);
        }

        public boolean removeContainerAndCancelIfNecessary(ImageContainer container) {
            this.mContainers.remove(container);
            if (this.mContainers.size() == 0) {
                this.mRequest.cancel();
                return true;
            }
            return false;
        }
    }

    public class ImageContainer {
        private BitmapDrawable mBitmap;
        private final ImageListener mListener;
        private final String mCacheKey;
        private final String mRequestUrl;

        public ImageContainer(BitmapDrawable bitmap, String requestUrl, String cacheKey, ImageListener listener) {
            this.mBitmap = bitmap;
            this.mRequestUrl = requestUrl;
            this.mCacheKey = cacheKey;
            this.mListener = listener;
        }

        public void cancelRequest() {
            if (this.mListener == null) {
                return;
            }
            BatchedImageRequest request = (BatchedImageRequest)ImageLoader.this.mInFlightRequests.get((Object)this.mCacheKey);
            if (request != null) {
                boolean canceled = request.removeContainerAndCancelIfNecessary(this);
                if (canceled) {
                    ImageLoader.this.mInFlightRequests.remove((Object)this.mCacheKey);
                }
            } else {
                request = (BatchedImageRequest)ImageLoader.this.mBatchedResponses.get((Object)this.mCacheKey);
                if (request != null) {
                    request.removeContainerAndCancelIfNecessary(this);
                    if (request.mContainers.size() == 0) {
                        ImageLoader.this.mBatchedResponses.remove((Object)this.mCacheKey);
                    }
                }
            }
        }

        public BitmapDrawable getBitmap() {
            return this.mBitmap;
        }

        public String getRequestUrl() {
            return this.mRequestUrl;
        }
    }

    public static interface ImageListener
    extends Response.ErrorListener {
        public void onResponse(ImageContainer var1, boolean var2);
    }
}

