/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.android.volley.Cache;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.NetworkResponse;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyLog;
import com.android.volley.error.AuthFailureError;
import com.android.volley.error.VolleyError;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;

public abstract class Request<T>
implements Comparable<Request<T>> {
    private static final String DEFAULT_PARAMS_ENCODING = "UTF-8";
    private final VolleyLog.MarkerLog mEventLog = VolleyLog.MarkerLog.ENABLED ? new VolleyLog.MarkerLog() : null;
    private final int mMethod;
    private final String mUrl;
    private final int mDefaultTrafficStatsTag;
    private final Response.ErrorListener mErrorListener;
    private Integer mSequence;
    private RequestQueue mRequestQueue;
    private boolean mShouldCache = true;
    private boolean mCanceled = false;
    private boolean mResponseDelivered = false;
    private RetryPolicy mRetryPolicy;
    private Cache.Entry mCacheEntry = null;
    private Map<String, String> mRequestHeaders = null;
    private Map<String, String> mParams = null;
    private Object mTag;
    private Priority mPriority;
    private boolean mShouldOverridePatch = false;

    public Request(int method, String url, Response.ErrorListener listener) {
        this(method, url, listener, null);
    }

    public Request(int method, String url, Response.ErrorListener listener, RetryPolicy retryPolicy) {
        this(method, url, Priority.NORMAL, listener, retryPolicy);
    }

    public Request(int method, String url, Priority priority, Response.ErrorListener listener, RetryPolicy retryPolicy) {
        this.mMethod = method;
        this.mUrl = url;
        this.mPriority = priority;
        this.mErrorListener = listener;
        this.setRetryPolicy(retryPolicy == null ? new DefaultRetryPolicy() : retryPolicy);
        this.mDefaultTrafficStatsTag = Request.findDefaultTrafficStatsTag(url);
    }

    private static int findDefaultTrafficStatsTag(String url) {
        String host;
        Uri uri;
        if (!TextUtils.isEmpty((CharSequence)url) && (uri = Uri.parse((String)url)) != null && (host = uri.getHost()) != null) {
            return host.hashCode();
        }
        return 0;
    }

    public int getMethod() {
        return this.mMethod;
    }

    public Request<?> setTag(Object tag) {
        this.mTag = tag;
        return this;
    }

    public Object getTag() {
        return this.mTag;
    }

    public Response.ErrorListener getErrorListener() {
        return this.mErrorListener;
    }

    public int getTrafficStatsTag() {
        return this.mDefaultTrafficStatsTag;
    }

    public Request<?> setRetryPolicy(RetryPolicy retryPolicy) {
        this.mRetryPolicy = retryPolicy;
        return this;
    }

    public void addMarker(String tag) {
        try {
            if (VolleyLog.MarkerLog.ENABLED) {
                this.mEventLog.add(tag, Thread.currentThread().getId());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void finish(final String tag) {
        if (this.mRequestQueue != null) {
            this.mRequestQueue.finish(this);
        }
        if (VolleyLog.MarkerLog.ENABLED) {
            try {
                final long threadId = Thread.currentThread().getId();
                if (Looper.myLooper() != Looper.getMainLooper()) {
                    Handler mainThread = new Handler(Looper.getMainLooper());
                    mainThread.post(new Runnable(){

                        @Override
                        public void run() {
                            Request.this.mEventLog.add(tag, threadId);
                            Request.this.mEventLog.finish(this.toString());
                        }
                    });
                    return;
                }
                this.mEventLog.add(tag, threadId);
                this.mEventLog.finish(this.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setRequestQueue(RequestQueue requestQueue) {
        this.mRequestQueue = requestQueue;
    }

    public final void setSequence(int sequence) {
        this.mSequence = sequence;
    }

    public final int getSequence() {
        if (this.mSequence == null) {
            throw new IllegalStateException("getSequence called before setSequence");
        }
        return this.mSequence;
    }

    public String getUrl() {
        try {
            if (this.mMethod == 0 && this.getParams() != null && this.getParams().size() != 0) {
                String encodedParams = this.getEncodedUrlParams();
                String extra = "";
                if (encodedParams != null && encodedParams.length() > 0) {
                    if (!this.mUrl.endsWith("?")) {
                        extra = extra + "?";
                    }
                    extra = extra + encodedParams;
                }
                return this.mUrl + extra;
            }
        }
        catch (AuthFailureError authFailureError) {
            // empty catch block
        }
        return this.mUrl;
    }

    public String getCacheKey() {
        return this.getUrl();
    }

    public void setCacheEntry(Cache.Entry entry) {
        this.mCacheEntry = entry;
    }

    public Cache.Entry getCacheEntry() {
        return this.mCacheEntry;
    }

    public void cancel() {
        this.mCanceled = true;
    }

    public boolean isCanceled() {
        return this.mCanceled;
    }

    public Map<String, String> getHeaders() throws AuthFailureError {
        return this.mRequestHeaders == null ? Collections.emptyMap() : this.mRequestHeaders;
    }

    public void setHeaders(Map<String, String> headers) {
        this.mRequestHeaders = headers;
    }

    protected Map<String, String> getPostParams() throws AuthFailureError {
        return this.getParams();
    }

    protected String getPostParamsEncoding() {
        return this.getParamsEncoding();
    }

    public String getPostBodyContentType() {
        return this.getBodyContentType();
    }

    public byte[] getPostBody() throws AuthFailureError {
        Map<String, String> postParams = this.getPostParams();
        if (postParams != null && postParams.size() > 0) {
            return this.encodeParameters(postParams, this.getPostParamsEncoding());
        }
        return null;
    }

    protected Map<String, String> getParams() throws AuthFailureError {
        return this.mParams == null ? Collections.emptyMap() : this.mParams;
    }

    public void setParams(Map<String, String> params) {
        this.mParams = params;
    }

    protected String getParamsEncoding() {
        return DEFAULT_PARAMS_ENCODING;
    }

    public String getBodyContentType() {
        return "application/x-www-form-urlencoded; charset=" + this.getParamsEncoding();
    }

    public byte[] getBody() throws AuthFailureError {
        Map<String, String> params = this.getParams();
        if (params != null && params.size() > 0) {
            return this.encodeParameters(params, this.getParamsEncoding());
        }
        return null;
    }

    private byte[] encodeParameters(Map<String, String> params, String paramsEncoding) {
        StringBuilder encodedParams = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (null == entry.getValue()) continue;
                encodedParams.append(URLEncoder.encode(entry.getKey(), paramsEncoding));
                encodedParams.append('=');
                encodedParams.append(URLEncoder.encode(entry.getValue(), paramsEncoding));
                encodedParams.append('&');
            }
            return encodedParams.toString().getBytes(paramsEncoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Encoding not supported: " + paramsEncoding, uee);
        }
    }

    public String getEncodedUrlParams() throws AuthFailureError {
        StringBuilder encodedParams = new StringBuilder();
        String paramsEncoding = this.getParamsEncoding();
        Map<String, String> params = this.getParams();
        try {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (null == entry.getValue()) continue;
                encodedParams.append(URLEncoder.encode(entry.getKey(), paramsEncoding));
                encodedParams.append('=');
                encodedParams.append(URLEncoder.encode(entry.getValue(), paramsEncoding));
                encodedParams.append('&');
            }
            return encodedParams.toString();
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Encoding not supported: " + paramsEncoding, uee);
        }
    }

    public final void setShouldCache(boolean shouldCache) {
        this.mShouldCache = shouldCache;
    }

    public final boolean shouldCache() {
        if (this.mMethod == 0) {
            return this.mShouldCache & true;
        }
        return false;
    }

    public void setPriority(Priority priority) throws IllegalStateException {
        if (this.mRequestQueue != null) {
            throw new IllegalStateException("Cannot change priority after adding to request queue");
        }
        this.mPriority = priority;
    }

    public Priority getPriority() {
        return this.mPriority;
    }

    public final int getTimeoutMs() {
        return this.mRetryPolicy.getCurrentTimeout();
    }

    public RetryPolicy getRetryPolicy() {
        return this.mRetryPolicy;
    }

    public void markDelivered() {
        this.mResponseDelivered = true;
    }

    public boolean hasHadResponseDelivered() {
        return this.mResponseDelivered;
    }

    protected abstract Response<T> parseNetworkResponse(NetworkResponse var1);

    protected VolleyError parseNetworkError(VolleyError volleyError) {
        return volleyError;
    }

    protected abstract void deliverResponse(T var1);

    public void deliverError(VolleyError error) {
        if (this.mErrorListener != null) {
            this.mErrorListener.onErrorResponse(error);
        }
    }

    @Override
    public int compareTo(Request<T> other) {
        Priority right;
        Priority left = this.getPriority();
        return left == (right = other.getPriority()) ? this.mSequence - other.mSequence : right.ordinal() - left.ordinal();
    }

    public String toString() {
        String trafficStatsTag = "0x" + Integer.toHexString(this.getTrafficStatsTag());
        return (this.mCanceled ? "[X] " : "[ ] ") + this.getUrl() + " " + trafficStatsTag + " " + (Object)((Object)this.getPriority()) + " " + this.mSequence;
    }

    public final void overridePatch(boolean override) {
        this.mShouldOverridePatch = override;
    }

    public final boolean shouldOverridePatch() {
        return this.mShouldOverridePatch;
    }

    public static enum Priority {
        LOW,
        NORMAL,
        HIGH,
        IMMEDIATE;

    }

    public static interface Method {
        public static final int DEPRECATED_GET_OR_POST = -1;
        public static final int GET = 0;
        public static final int POST = 1;
        public static final int PUT = 2;
        public static final int DELETE = 3;
        public static final int HEAD = 4;
        public static final int OPTIONS = 5;
        public static final int TRACE = 6;
        public static final int PATCH = 7;
    }
}

