/*
 * Decompiled with CFR 0.152.
 */
package dev.drewhamilton.poko.codegen;

import dev.drewhamilton.poko.codegen.EqualsGenerator;
import dev.drewhamilton.poko.codegen.HashCodeGenerator;
import dev.drewhamilton.poko.codegen.ToStringGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.extensions.ExpressionCodegenExtension;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\u00a8\u0006\u0017"}, d2={"Ldev/drewhamilton/poko/codegen/PokoCodegenExtension;", "Lorg/jetbrains/kotlin/codegen/extensions/ExpressionCodegenExtension;", "pokoAnnotationName", "Lorg/jetbrains/kotlin/name/FqName;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "isPoko", "", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotated;", "(Lorg/jetbrains/kotlin/descriptors/annotations/Annotated;)Z", "generateClassSyntheticParts", "", "codegen", "Lorg/jetbrains/kotlin/codegen/ImplementationBodyCodegen;", "log", "message", "", "reportError", "findFunction", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "name", "poko-compiler-plugin"})
public final class PokoCodegenExtension
implements ExpressionCodegenExtension {
    @NotNull
    private final FqName pokoAnnotationName;
    @NotNull
    private final MessageCollector messageCollector;

    public PokoCodegenExtension(@NotNull FqName pokoAnnotationName, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter((Object)pokoAnnotationName, (String)"pokoAnnotationName");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        this.pokoAnnotationName = pokoAnnotationName;
        this.messageCollector = messageCollector;
    }

    /*
     * WARNING - void declaration
     */
    public void generateClassSyntheticParts(@NotNull ImplementationBodyCodegen codegen) {
        void $this$mapNotNullTo$iv$iv;
        Object v2;
        Object element$iv2;
        ClassDescriptor targetClass;
        block11: {
            Intrinsics.checkNotNullParameter((Object)codegen, (String)"codegen");
            ClassDescriptor classDescriptor = codegen.descriptor;
            Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"codegen.descriptor");
            targetClass = classDescriptor;
            this.log("Reading " + targetClass.getName());
            if (!this.isPoko((Annotated)targetClass)) {
                this.log("Not Poko class");
                return;
            }
            if (targetClass.isData()) {
                this.log("Data class");
                this.reportError("Poko does not support data classes", codegen);
                return;
            }
            if (targetClass.isInline()) {
                this.log("Inline class");
                this.reportError("Poko does not support inline classes", codegen);
                return;
            }
            if (targetClass.isInner()) {
                this.log("Inner class");
                this.reportError("Poko cannot be applied to inner classes", codegen);
                return;
            }
            Collection collection = targetClass.getConstructors();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"targetClass.constructors");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                ClassConstructorDescriptor it = (ClassConstructorDescriptor)element$iv2;
                boolean bl = false;
                if (!it.isPrimary()) continue;
                v2 = element$iv2;
                break block11;
            }
            v2 = null;
        }
        ClassConstructorDescriptor primaryConstructor = v2;
        if (primaryConstructor == null) {
            this.log("No primary constructor");
            this.reportError("Poko classes must have a primary constructor", codegen);
            return;
        }
        List list = primaryConstructor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"primaryConstructor.valueParameters");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        element$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PropertyDescriptor it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)element$iv$iv;
            boolean bl2 = false;
            if ((PropertyDescriptor)codegen.bindingContext.get((ReadOnlySlice)BindingContext.VALUE_PARAMETER_AS_PROPERTY, (Object)parameter) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List properties = (List)destination$iv$iv;
        if (properties.isEmpty()) {
            this.log("No primary constructor properties");
            this.reportError("Poko classes must have at least one property in the primary constructor", codegen);
            return;
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor = this.findFunction(targetClass, "toString");
        Intrinsics.checkNotNull((Object)simpleFunctionDescriptor);
        SimpleFunctionDescriptor toStringFunction = simpleFunctionDescriptor;
        if (toStringFunction.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            KtClassOrObject ktClassOrObject = (KtClassOrObject)codegen.myClass;
            Type type = codegen.typeMapper.mapType((ClassifierDescriptor)targetClass);
            FieldOwnerContext fieldOwnerContext = codegen.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)fieldOwnerContext, (String)"codegen.context");
            ClassBuilder classBuilder = codegen.v;
            Intrinsics.checkNotNullExpressionValue((Object)classBuilder, (String)"codegen.v");
            GenerationState generationState = codegen.state;
            Intrinsics.checkNotNullExpressionValue((Object)generationState, (String)"codegen.state");
            new ToStringGenerator(ktClassOrObject, targetClass, type, fieldOwnerContext, classBuilder, generationState).generate((FunctionDescriptor)toStringFunction, properties);
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor2 = this.findFunction(targetClass, "equals");
        Intrinsics.checkNotNull((Object)simpleFunctionDescriptor2);
        SimpleFunctionDescriptor equalsFunction = simpleFunctionDescriptor2;
        if (equalsFunction.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            KtClassOrObject ktClassOrObject = (KtClassOrObject)codegen.myClass;
            Type type = codegen.typeMapper.mapType((ClassifierDescriptor)targetClass);
            FieldOwnerContext fieldOwnerContext = codegen.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)fieldOwnerContext, (String)"codegen.context");
            ClassBuilder classBuilder = codegen.v;
            Intrinsics.checkNotNullExpressionValue((Object)classBuilder, (String)"codegen.v");
            GenerationState generationState = codegen.state;
            Intrinsics.checkNotNullExpressionValue((Object)generationState, (String)"codegen.state");
            new EqualsGenerator(ktClassOrObject, targetClass, type, fieldOwnerContext, classBuilder, generationState).generate((FunctionDescriptor)equalsFunction, properties);
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor3 = this.findFunction(targetClass, "hashCode");
        Intrinsics.checkNotNull((Object)simpleFunctionDescriptor3);
        SimpleFunctionDescriptor hashCodeFunction = simpleFunctionDescriptor3;
        if (hashCodeFunction.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            KtClassOrObject ktClassOrObject = (KtClassOrObject)codegen.myClass;
            Type type = codegen.typeMapper.mapType((ClassifierDescriptor)targetClass);
            FieldOwnerContext fieldOwnerContext = codegen.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)fieldOwnerContext, (String)"codegen.context");
            ClassBuilder classBuilder = codegen.v;
            Intrinsics.checkNotNullExpressionValue((Object)classBuilder, (String)"codegen.v");
            GenerationState generationState = codegen.state;
            Intrinsics.checkNotNullExpressionValue((Object)generationState, (String)"codegen.state");
            new HashCodeGenerator(ktClassOrObject, targetClass, type, fieldOwnerContext, classBuilder, generationState).generate((FunctionDescriptor)hashCodeFunction, properties);
        }
    }

    private final boolean isPoko(Annotated $this$isPoko) {
        return $this$isPoko.getAnnotations().hasAnnotation(this.pokoAnnotationName);
    }

    private final SimpleFunctionDescriptor findFunction(ClassDescriptor $this$findFunction, String name) {
        MemberScope memberScope = $this$findFunction.getUnsubstitutedMemberScope();
        Name name2 = Name.identifier((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(name)");
        return (SimpleFunctionDescriptor)CollectionsKt.first((Iterable)memberScope.getContributedFunctions(name2, (LookupLocation)NoLookupLocation.WHEN_GET_ALL_DESCRIPTORS));
    }

    private final void log(String message) {
        this.messageCollector.report(CompilerMessageSeverity.LOGGING, "POKO COMPILER PLUGIN: " + message, (CompilerMessageSourceLocation)CompilerMessageLocation.Companion.create(null));
    }

    private final void reportError(String message, ImplementationBodyCodegen codegen) {
        SourceElement sourceElement = codegen.descriptor.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"codegen.descriptor.source");
        PsiElement psi = PsiSourceElementKt.getPsi((SourceElement)sourceElement);
        CompilerMessageSourceLocation location = MessageUtil.psiElementToMessageLocation((PsiElement)psi);
        this.messageCollector.report(CompilerMessageSeverity.ERROR, message, location);
    }

    public boolean getShouldGenerateClassSyntheticPartsInLightClassesMode() {
        return ExpressionCodegenExtension.DefaultImpls.getShouldGenerateClassSyntheticPartsInLightClassesMode((ExpressionCodegenExtension)this);
    }

    @Nullable
    public StackValue applyFunction(@NotNull StackValue receiver, @NotNull ResolvedCall<?> resolvedCall, @NotNull ExpressionCodegenExtension.Context c) {
        return ExpressionCodegenExtension.DefaultImpls.applyFunction((ExpressionCodegenExtension)this, (StackValue)receiver, resolvedCall, (ExpressionCodegenExtension.Context)c);
    }

    @Nullable
    public StackValue applyProperty(@NotNull StackValue receiver, @NotNull ResolvedCall<?> resolvedCall, @NotNull ExpressionCodegenExtension.Context c) {
        return ExpressionCodegenExtension.DefaultImpls.applyProperty((ExpressionCodegenExtension)this, (StackValue)receiver, resolvedCall, (ExpressionCodegenExtension.Context)c);
    }
}

