/*
 * Decompiled with CFR 0.152.
 */
package dev.dewy.nbt.tags.primitive;

import com.google.gson.JsonObject;
import dev.dewy.nbt.api.registry.TagTypeRegistry;
import dev.dewy.nbt.api.snbt.SnbtConfig;
import dev.dewy.nbt.tags.TagType;
import dev.dewy.nbt.tags.primitive.NumericalTag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import lombok.NonNull;

public class ShortTag
extends NumericalTag<Short> {
    private short value;

    public ShortTag(@NonNull Number value) {
        this(null, value);
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
    }

    public ShortTag(String name, @NonNull Number value) {
        this(name, value.shortValue());
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
    }

    public ShortTag(String name, short value) {
        this.setName(name);
        this.setValue(value);
    }

    @Override
    public byte getTypeId() {
        return TagType.SHORT.getId();
    }

    @Override
    public Short getValue() {
        return this.value;
    }

    public void setValue(short value) {
        this.value = value;
    }

    @Override
    public void write(DataOutput output, int depth, TagTypeRegistry registry) throws IOException {
        output.writeShort(this.value);
    }

    @Override
    public ShortTag read(DataInput input, int depth, TagTypeRegistry registry) throws IOException {
        this.value = input.readShort();
        return this;
    }

    @Override
    public String toSnbt(int depth, TagTypeRegistry registry, SnbtConfig config) {
        return this.value + "s";
    }

    @Override
    public JsonObject toJson(int depth, TagTypeRegistry registry) {
        JsonObject json = new JsonObject();
        json.addProperty("type", (Number)this.getTypeId());
        if (this.getName() != null) {
            json.addProperty("name", this.getName());
        }
        json.addProperty("value", (Number)this.value);
        return json;
    }

    @Override
    public ShortTag fromJson(JsonObject json, int depth, TagTypeRegistry registry) {
        if (json.has("name")) {
            this.setName(json.getAsJsonPrimitive("name").getAsString());
        } else {
            this.setName(null);
        }
        this.value = json.getAsJsonPrimitive("value").getAsShort();
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShortTag shortTag = (ShortTag)o;
        return this.value == shortTag.value;
    }

    public int hashCode() {
        return this.value;
    }

    public ShortTag() {
    }

    public ShortTag(short value) {
        this.value = value;
    }
}

