/*
 * Decompiled with CFR 0.152.
 */
package dev.dewy.nbt.tags.primitive;

import com.google.gson.JsonObject;
import dev.dewy.nbt.api.registry.TagTypeRegistry;
import dev.dewy.nbt.api.snbt.SnbtConfig;
import dev.dewy.nbt.tags.TagType;
import dev.dewy.nbt.tags.primitive.NumericalTag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LongTag
extends NumericalTag<Long> {
    private long value;

    public LongTag(String name, long value) {
        this.setName(name);
        this.setValue(value);
    }

    @Override
    public byte getTypeId() {
        return TagType.LONG.getId();
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    @Override
    public void write(DataOutput output, int depth, TagTypeRegistry registry) throws IOException {
        output.writeLong(this.value);
    }

    @Override
    public LongTag read(DataInput input, int depth, TagTypeRegistry registry) throws IOException {
        this.value = input.readLong();
        return this;
    }

    @Override
    public String toSnbt(int depth, TagTypeRegistry registry, SnbtConfig config) {
        return this.value + "L";
    }

    @Override
    public JsonObject toJson(int depth, TagTypeRegistry registry) {
        JsonObject json = new JsonObject();
        json.addProperty("type", (Number)this.getTypeId());
        if (this.getName() != null) {
            json.addProperty("name", this.getName());
        }
        json.addProperty("value", (Number)this.value);
        return json;
    }

    @Override
    public LongTag fromJson(JsonObject json, int depth, TagTypeRegistry registry) {
        if (json.has("name")) {
            this.setName(json.getAsJsonPrimitive("name").getAsString());
        } else {
            this.setName(null);
        }
        this.value = json.getAsJsonPrimitive("value").getAsLong();
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongTag longTag = (LongTag)o;
        return this.value == longTag.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public LongTag() {
    }

    public LongTag(long value) {
        this.value = value;
    }
}

