/*
 * Decompiled with CFR 0.152.
 */
package dev.dewy.nbt.tags.primitive;

import com.google.gson.JsonObject;
import dev.dewy.nbt.api.registry.TagTypeRegistry;
import dev.dewy.nbt.api.snbt.SnbtConfig;
import dev.dewy.nbt.tags.TagType;
import dev.dewy.nbt.tags.primitive.NumericalTag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import lombok.NonNull;

public class ByteTag
extends NumericalTag<Byte> {
    private byte value;

    public ByteTag(@NonNull Number value) {
        this(null, value);
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
    }

    public ByteTag(String name, @NonNull Number value) {
        this(name, value.byteValue());
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
    }

    public ByteTag(String name, byte value) {
        this.setName(name);
        this.setValue(value);
    }

    @Override
    public byte getTypeId() {
        return TagType.BYTE.getId();
    }

    @Override
    public Byte getValue() {
        return this.value;
    }

    public void setValue(byte value) {
        this.value = value;
    }

    @Override
    public void write(DataOutput output, int depth, TagTypeRegistry registry) throws IOException {
        output.writeByte(this.value);
    }

    @Override
    public ByteTag read(DataInput input, int depth, TagTypeRegistry registry) throws IOException {
        this.value = input.readByte();
        return this;
    }

    @Override
    public String toSnbt(int depth, TagTypeRegistry registry, SnbtConfig config) {
        return this.value + "b";
    }

    @Override
    public JsonObject toJson(int depth, TagTypeRegistry registry) throws IOException {
        JsonObject json = new JsonObject();
        json.addProperty("type", (Number)this.getTypeId());
        if (this.getName() != null) {
            json.addProperty("name", this.getName());
        }
        json.addProperty("value", (Number)this.value);
        return json;
    }

    @Override
    public ByteTag fromJson(JsonObject json, int depth, TagTypeRegistry registry) throws IOException {
        if (json.has("name")) {
            this.setName(json.getAsJsonPrimitive("name").getAsString());
        } else {
            this.setName(null);
        }
        this.value = json.getAsJsonPrimitive("value").getAsByte();
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteTag byteTag = (ByteTag)o;
        return this.value == byteTag.value;
    }

    public int hashCode() {
        return this.value;
    }

    public ByteTag() {
    }

    public ByteTag(byte value) {
        this.value = value;
    }
}

