/*
 * Decompiled with CFR 0.152.
 */
package dev.dewy.nbt.tags.collection;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.dewy.nbt.api.Tag;
import dev.dewy.nbt.api.json.JsonSerializable;
import dev.dewy.nbt.api.registry.TagTypeRegistry;
import dev.dewy.nbt.api.registry.TagTypeRegistryException;
import dev.dewy.nbt.api.snbt.SnbtConfig;
import dev.dewy.nbt.api.snbt.SnbtSerializable;
import dev.dewy.nbt.tags.TagType;
import dev.dewy.nbt.utils.StringUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import lombok.NonNull;

public class ListTag<T extends Tag>
extends Tag
implements SnbtSerializable,
JsonSerializable,
Iterable<T> {
    @NonNull
    private List<T> value;
    private byte type;

    public ListTag() {
        this(null);
    }

    public ListTag(String name) {
        this(name, new LinkedList());
    }

    public ListTag(String name, @NonNull List<T> value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.type = value.isEmpty() ? (byte)0 : ((Tag)value.get(0)).getTypeId();
        this.setName(name);
        this.setValue(value);
    }

    @Override
    public byte getTypeId() {
        return TagType.LIST.getId();
    }

    @Override
    public List<T> getValue() {
        return this.value;
    }

    public byte getListType() {
        return this.type;
    }

    public void setValue(@NonNull List<T> value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.type = value.isEmpty() ? (byte)0 : ((Tag)value.get(0)).getTypeId();
        this.value = value;
    }

    @Override
    public void write(DataOutput output, int depth, TagTypeRegistry registry) throws IOException {
        if (depth > 512) {
            throw new IOException("NBT structure too complex (depth > 512).");
        }
        output.writeByte(this.type);
        output.writeInt(this.value.size());
        for (Tag tag : this) {
            tag.write(output, depth + 1, registry);
        }
    }

    @Override
    public ListTag<T> read(DataInput input, int depth, TagTypeRegistry registry) throws IOException {
        if (depth > 512) {
            throw new IOException("NBT structure too complex (depth > 512).");
        }
        ArrayList<T> tags = new ArrayList<T>();
        byte tagType = input.readByte();
        int length = input.readInt();
        for (int i = 0; i < length; ++i) {
            Tag next;
            Class<? extends Tag> tagClass = registry.getClassFromId(tagType);
            if (tagClass == null) {
                throw new IOException("Tag type with ID " + tagType + " not present in tag type registry.");
            }
            try {
                next = registry.instantiate(tagClass);
            }
            catch (TagTypeRegistryException e) {
                throw new IOException(e);
            }
            next.read(input, depth + 1, registry);
            next.setName(null);
            tags.add(next);
        }
        this.type = tags.isEmpty() ? (byte)0 : tagType;
        this.value = tags;
        return this;
    }

    @Override
    public String toSnbt(int depth, TagTypeRegistry registry, SnbtConfig config) {
        StringBuilder sb = new StringBuilder("[");
        if (config.isPrettyPrint()) {
            sb.append('\n').append(StringUtils.multiplyIndent(depth + 1, config));
        }
        for (int i = 0; i < this.value.size(); ++i) {
            if (i != 0) {
                if (config.isPrettyPrint()) {
                    sb.append(",\n").append(StringUtils.multiplyIndent(depth + 1, config));
                } else {
                    sb.append(',');
                }
            }
            sb.append(((SnbtSerializable)this.value.get(i)).toSnbt(depth + 1, registry, config));
        }
        if (config.isPrettyPrint()) {
            sb.append("\n").append(StringUtils.multiplyIndent(depth, config)).append(']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public JsonObject toJson(int depth, TagTypeRegistry registry) throws IOException {
        if (depth > 512) {
            throw new IOException("NBT structure too complex (depth > 512).");
        }
        JsonObject json = new JsonObject();
        JsonArray value = new JsonArray();
        json.addProperty("type", (Number)this.getTypeId());
        json.addProperty("listType", (Number)this.getListType());
        if (this.getName() != null) {
            json.addProperty("name", this.getName());
        }
        for (Tag tag : this) {
            tag.setName(null);
            value.add((JsonElement)((JsonSerializable)((Object)tag)).toJson(depth + 1, registry));
        }
        json.add("value", (JsonElement)value);
        return json;
    }

    @Override
    public ListTag<T> fromJson(JsonObject json, int depth, TagTypeRegistry registry) throws IOException {
        if (depth > 512) {
            throw new IOException("NBT structure too complex (depth > 512).");
        }
        this.clear();
        if (json.has("name")) {
            this.setName(json.getAsJsonPrimitive("name").getAsString());
        } else {
            this.setName(null);
        }
        byte listType = json.get("listType").getAsByte();
        LinkedList<T> tags = new LinkedList<T>();
        for (JsonElement element : json.getAsJsonArray("value")) {
            Tag nextTag;
            Class<? extends Tag> tagClass = registry.getClassFromId(listType);
            if (tagClass == null) {
                throw new IOException("Tag type with ID " + listType + " not present in tag type registry.");
            }
            try {
                nextTag = registry.instantiate(tagClass);
            }
            catch (TagTypeRegistryException e) {
                throw new IOException(e);
            }
            ((JsonSerializable)((Object)nextTag)).fromJson((JsonObject)element, depth + 1, registry);
            tags.add(nextTag);
        }
        this.type = tags.isEmpty() ? (byte)0 : listType;
        this.value = tags;
        return this;
    }

    public int size() {
        return this.value.size();
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public boolean add(@NonNull T tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (this.value.isEmpty()) {
            this.type = ((Tag)tag).getTypeId();
        }
        if (((Tag)tag).getTypeId() != this.type) {
            return false;
        }
        return this.value.add(tag);
    }

    public void insert(int index, @NonNull T tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (this.value.isEmpty()) {
            this.type = ((Tag)tag).getTypeId();
        }
        if (((Tag)tag).getTypeId() != this.type) {
            return;
        }
        this.value.add(index, tag);
    }

    public boolean remove(@NonNull T tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        boolean success = this.value.remove(tag);
        if (this.value.isEmpty()) {
            this.type = 0;
        }
        return success;
    }

    public T remove(int index) {
        Tag previous = (Tag)this.value.remove(index);
        if (this.value.isEmpty()) {
            this.type = 0;
        }
        return (T)previous;
    }

    public T get(int index) {
        return (T)((Tag)this.value.get(index));
    }

    public boolean contains(@NonNull T tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        return this.value.contains(tag);
    }

    public boolean containsAll(@NonNull Collection<T> tags) {
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        return this.value.containsAll(tags);
    }

    public void clear() {
        this.type = 0;
        this.value.clear();
    }

    @Override
    public Iterator<T> iterator() {
        return this.value.iterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.value.forEach(action);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.value.spliterator();
    }

    public String toString() {
        return this.toSnbt(0, new TagTypeRegistry(), new SnbtConfig());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTag listTag = (ListTag)o;
        if (this.type != listTag.type) {
            return false;
        }
        return Objects.equals(this.value, listTag.value);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + this.type;
        return result;
    }

    public ListTag(@NonNull List<T> value, byte type) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
        this.type = type;
    }
}

