/*
 * Decompiled with CFR 0.152.
 */
package dev.dewy.nbt.tags.collection;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.dewy.nbt.api.Tag;
import dev.dewy.nbt.api.json.JsonSerializable;
import dev.dewy.nbt.api.registry.TagTypeRegistry;
import dev.dewy.nbt.api.registry.TagTypeRegistryException;
import dev.dewy.nbt.api.snbt.SnbtConfig;
import dev.dewy.nbt.api.snbt.SnbtSerializable;
import dev.dewy.nbt.tags.TagType;
import dev.dewy.nbt.tags.array.ByteArrayTag;
import dev.dewy.nbt.tags.array.IntArrayTag;
import dev.dewy.nbt.tags.array.LongArrayTag;
import dev.dewy.nbt.tags.collection.ListTag;
import dev.dewy.nbt.tags.primitive.ByteTag;
import dev.dewy.nbt.tags.primitive.DoubleTag;
import dev.dewy.nbt.tags.primitive.FloatTag;
import dev.dewy.nbt.tags.primitive.IntTag;
import dev.dewy.nbt.tags.primitive.LongTag;
import dev.dewy.nbt.tags.primitive.ShortTag;
import dev.dewy.nbt.tags.primitive.StringTag;
import dev.dewy.nbt.utils.StringUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import lombok.NonNull;

public class CompoundTag
extends Tag
implements SnbtSerializable,
JsonSerializable,
Iterable<Tag> {
    @NonNull
    private Map<String, Tag> value;

    public CompoundTag() {
        this(null, new LinkedHashMap<String, Tag>());
    }

    public CompoundTag(String name) {
        this(name, new LinkedHashMap<String, Tag>());
    }

    public CompoundTag(String name, @NonNull Map<String, Tag> value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.setName(name);
        this.setValue(value);
    }

    @Override
    public byte getTypeId() {
        return TagType.COMPOUND.getId();
    }

    @Override
    public Map<String, Tag> getValue() {
        return this.value;
    }

    public void setValue(@NonNull Map<String, Tag> value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    @Override
    public void write(DataOutput output, int depth, TagTypeRegistry registry) throws IOException {
        if (depth > 512) {
            throw new IOException("NBT structure too complex (depth > 512).");
        }
        for (Tag tag : this) {
            output.writeByte(tag.getTypeId());
            output.writeUTF(tag.getName());
            tag.write(output, depth + 1, registry);
        }
        output.writeByte(0);
    }

    @Override
    public CompoundTag read(DataInput input, int depth, TagTypeRegistry registry) throws IOException {
        byte nextTypeId;
        if (depth > 512) {
            throw new IOException("NBT structure too complex (depth > 512).");
        }
        LinkedHashMap<String, Tag> tags = new LinkedHashMap<String, Tag>();
        while ((nextTypeId = input.readByte()) != 0) {
            Tag nextTag;
            Class<? extends Tag> tagClass = registry.getClassFromId(nextTypeId);
            if (tagClass == null) {
                throw new IOException("Tag type with ID " + nextTypeId + " not present in tag type registry.");
            }
            try {
                nextTag = registry.instantiate(tagClass);
            }
            catch (TagTypeRegistryException e) {
                throw new IOException(e);
            }
            nextTag.setName(input.readUTF());
            nextTag.read(input, depth + 1, registry);
            tags.put(nextTag.getName(), nextTag);
        }
        this.value = tags;
        return this;
    }

    @Override
    public JsonObject toJson(int depth, TagTypeRegistry registry) throws IOException {
        if (depth > 512) {
            throw new IOException("NBT structure too complex (depth > 512).");
        }
        JsonObject json = new JsonObject();
        JsonObject value = new JsonObject();
        json.addProperty("type", (Number)this.getTypeId());
        if (this.getName() != null) {
            json.addProperty("name", this.getName());
        }
        for (Tag tag : this) {
            try {
                value.add(tag.getName(), (JsonElement)((JsonSerializable)((Object)tag)).toJson(depth + 1, registry));
            }
            catch (ClassCastException e) {
                throw new IOException("Tag not JsonSerializable.", e);
            }
        }
        json.add("value", (JsonElement)value);
        return json;
    }

    @Override
    public CompoundTag fromJson(JsonObject json, int depth, TagTypeRegistry registry) throws IOException {
        if (depth > 512) {
            throw new IOException("NBT structure too complex (depth > 512).");
        }
        this.clear();
        if (json.has("name")) {
            this.setName(json.getAsJsonPrimitive("name").getAsString());
        } else {
            this.setName(null);
        }
        LinkedHashMap<String, Tag> tags = new LinkedHashMap<String, Tag>();
        for (Map.Entry entry : json.getAsJsonObject("value").entrySet()) {
            Tag nextTag;
            JsonObject entryJson = ((JsonElement)entry.getValue()).getAsJsonObject();
            byte nextTypeId = entryJson.get("type").getAsByte();
            Class<? extends Tag> tagClass = registry.getClassFromId(nextTypeId);
            if (tagClass == null) {
                throw new IOException("Tag type with ID " + nextTypeId + " not present in tag type registry.");
            }
            try {
                nextTag = registry.instantiate(tagClass);
            }
            catch (TagTypeRegistryException e) {
                throw new IOException(e);
            }
            ((JsonSerializable)((Object)nextTag)).fromJson(entryJson, depth + 1, registry);
            tags.put(nextTag.getName(), nextTag);
        }
        this.value = tags;
        return this;
    }

    @Override
    public String toSnbt(int depth, TagTypeRegistry registry, SnbtConfig config) {
        if (this.value.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("{");
        if (config.isPrettyPrint()) {
            sb.append('\n').append(StringUtils.multiplyIndent(depth + 1, config));
        }
        boolean first = true;
        for (Tag tag : this) {
            if (!first) {
                if (config.isPrettyPrint()) {
                    sb.append(",\n").append(StringUtils.multiplyIndent(depth + 1, config));
                } else {
                    sb.append(',');
                }
            }
            sb.append(StringUtils.escapeSnbt(tag.getName()));
            if (config.isPrettyPrint()) {
                sb.append(": ");
            } else {
                sb.append(':');
            }
            sb.append(((SnbtSerializable)((Object)tag)).toSnbt(depth + 1, registry, config));
            if (!first) continue;
            first = false;
        }
        if (config.isPrettyPrint()) {
            sb.append("\n").append(StringUtils.multiplyIndent(depth, config)).append('}');
        } else {
            sb.append('}');
        }
        return sb.toString();
    }

    public int size() {
        return this.value.size();
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public <E extends Tag> E put(@NonNull Tag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        return (E)this.value.put(tag.getName(), tag);
    }

    public <E extends Tag> E put(@NonNull String name, @NonNull Tag tag) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        tag.setName(name);
        return this.put(tag);
    }

    public void putByte(@NonNull String name, byte value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.put(name, new ByteTag(name, value));
    }

    public void putShort(@NonNull String name, short value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.put(name, new ShortTag(name, value));
    }

    public void putInt(@NonNull String name, int value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.put(name, new IntTag(name, value));
    }

    public void putLong(@NonNull String name, long value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.put(name, new LongTag(name, value));
    }

    public void putFloat(@NonNull String name, float value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.put(name, new FloatTag(name, value));
    }

    public void putDouble(@NonNull String name, double value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.put(name, new DoubleTag(name, value));
    }

    public void putByteArray(@NonNull String name, @NonNull byte[] value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.put(name, new ByteArrayTag(name, value));
    }

    public void putString(@NonNull String name, @NonNull String value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.put(name, new StringTag(name, value));
    }

    public <T extends Tag> void putList(@NonNull String name, List<T> value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.put(name, new ListTag<T>(name, value));
    }

    public void putCompound(@NonNull String name, @NonNull Map<String, Tag> value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.put(name, new CompoundTag(name, value));
    }

    public void putIntArray(@NonNull String name, @NonNull int[] value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.put(name, new IntArrayTag(name, value));
    }

    public void putLongArray(@NonNull String name, @NonNull long[] value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.put(name, new LongArrayTag(name, value));
    }

    public <T extends Tag> T remove(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return (T)this.value.remove(key);
    }

    public <T extends Tag> T get(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return (T)this.value.get(key);
    }

    public ByteTag getByte(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return (ByteTag)this.get(key);
    }

    public ShortTag getShort(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return (ShortTag)this.get(key);
    }

    public IntTag getInt(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return (IntTag)this.get(key);
    }

    public LongTag getLong(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return (LongTag)this.get(key);
    }

    public FloatTag getFloat(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return (FloatTag)this.get(key);
    }

    public DoubleTag getDouble(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return (DoubleTag)this.get(key);
    }

    public ByteArrayTag getByteArray(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return (ByteArrayTag)this.get(key);
    }

    public StringTag getString(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return (StringTag)this.get(key);
    }

    public <T extends Tag> ListTag<T> getList(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return (ListTag)this.get(key);
    }

    public CompoundTag getCompound(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return (CompoundTag)this.get(key);
    }

    public IntArrayTag getIntArray(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return (IntArrayTag)this.get(key);
    }

    public LongArrayTag getLongArray(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return (LongArrayTag)this.get(key);
    }

    public boolean contains(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.value.containsKey(key);
    }

    public boolean contains(@NonNull String key, byte typeId) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (!this.contains(key)) {
            return false;
        }
        return ((Tag)this.get(key)).getTypeId() == typeId;
    }

    public boolean containsByte(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.contains(key, TagType.BYTE.getId());
    }

    public boolean containsShort(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.contains(key, TagType.SHORT.getId());
    }

    public boolean containsInt(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.contains(key, TagType.INT.getId());
    }

    public boolean containsLong(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.contains(key, TagType.LONG.getId());
    }

    public boolean containsFloat(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.contains(key, TagType.FLOAT.getId());
    }

    public boolean containsDouble(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.contains(key, TagType.DOUBLE.getId());
    }

    public boolean containsByteArray(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.contains(key, TagType.BYTE_ARRAY.getId());
    }

    public boolean containsString(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.contains(key, TagType.STRING.getId());
    }

    public boolean containsList(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.contains(key, TagType.LIST.getId());
    }

    public boolean containsListOf(@NonNull String key, byte of) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.containsList(key) && this.getList(key).getListType() == of;
    }

    public boolean containsCompound(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.contains(key, TagType.COMPOUND.getId());
    }

    public boolean containsIntArray(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.contains(key, TagType.INT_ARRAY.getId());
    }

    public boolean containsLongArray(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.contains(key, TagType.LONG_ARRAY.getId());
    }

    public Collection<Tag> values() {
        return this.value.values();
    }

    public Set<String> keySet() {
        return this.value.keySet();
    }

    public void clear() {
        this.value.clear();
    }

    @Override
    public Iterator<Tag> iterator() {
        return this.value.values().iterator();
    }

    @Override
    public void forEach(Consumer<? super Tag> action) {
        this.value.values().forEach(action);
    }

    @Override
    public Spliterator<Tag> spliterator() {
        return this.value.values().spliterator();
    }

    public String toString() {
        return this.toSnbt(0, new TagTypeRegistry(), new SnbtConfig());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompoundTag that = (CompoundTag)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public CompoundTag(@NonNull Map<String, Tag> value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }
}

