/*
 * Decompiled with CFR 0.152.
 */
package dev.dewy.nbt.tags.array;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.dewy.nbt.api.registry.TagTypeRegistry;
import dev.dewy.nbt.api.snbt.SnbtConfig;
import dev.dewy.nbt.tags.TagType;
import dev.dewy.nbt.tags.array.ArrayTag;
import dev.dewy.nbt.utils.StringUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;

public class LongArrayTag
extends ArrayTag<Long> {
    @NonNull
    private long[] value;

    public LongArrayTag(String name, @NonNull long[] value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.setName(name);
        this.setValue(value);
    }

    public LongArrayTag(@NonNull List<Long> value) {
        this(null, value);
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
    }

    public LongArrayTag(String name, @NonNull List<Long> value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.setName(name);
        this.setValue(ArrayUtils.toPrimitive((Long[])value.toArray(new Long[0])));
    }

    @Override
    public byte getTypeId() {
        return TagType.LONG_ARRAY.getId();
    }

    public long[] getValue() {
        return this.value;
    }

    public void setValue(@NonNull long[] value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    @Override
    public void write(DataOutput output, int depth, TagTypeRegistry registry) throws IOException {
        output.writeInt(this.value.length);
        for (long l : this) {
            output.writeLong(l);
        }
    }

    @Override
    public LongArrayTag read(DataInput input, int depth, TagTypeRegistry registry) throws IOException {
        this.value = new long[input.readInt()];
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = input.readLong();
        }
        return this;
    }

    @Override
    public JsonObject toJson(int depth, TagTypeRegistry registry) throws IOException {
        JsonObject json = new JsonObject();
        JsonArray array = new JsonArray();
        json.addProperty("type", (Number)this.getTypeId());
        if (this.getName() != null) {
            json.addProperty("name", this.getName());
        }
        for (long l : this) {
            array.add((Number)l);
        }
        json.add("value", (JsonElement)array);
        return json;
    }

    @Override
    public LongArrayTag fromJson(JsonObject json, int depth, TagTypeRegistry registry) throws IOException {
        JsonArray array = json.getAsJsonArray("value");
        if (json.has("name")) {
            this.setName(json.getAsJsonPrimitive("name").getAsString());
        } else {
            this.setName(null);
        }
        this.value = new long[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            this.value[i] = array.get(i).getAsLong();
        }
        return this;
    }

    @Override
    public String toSnbt(int depth, TagTypeRegistry registry, SnbtConfig config) {
        StringBuilder sb = new StringBuilder("[L;");
        if (config.isPrettyPrint()) {
            if (this.value.length < config.getInlineThreshold()) {
                sb.append('\n').append(StringUtils.multiplyIndent(depth + 1, config));
            } else {
                sb.append(' ');
            }
        }
        for (int i = 0; i < this.value.length; ++i) {
            if (i != 0) {
                if (config.isPrettyPrint()) {
                    if (this.value.length < config.getInlineThreshold()) {
                        sb.append(",\n").append(StringUtils.multiplyIndent(depth + 1, config));
                    } else {
                        sb.append(", ");
                    }
                } else {
                    sb.append(',');
                }
            }
            sb.append(this.value[i]).append('L');
        }
        if (config.isPrettyPrint() && this.value.length < config.getInlineThreshold()) {
            sb.append("\n").append(StringUtils.multiplyIndent(depth, config)).append(']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public Long get(int index) {
        return this.value[index];
    }

    @Override
    public Long set(int index, @NonNull Long element) {
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        this.value[index] = element;
        return this.value[index];
    }

    public void insert(int index, Long ... elements) {
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        this.value = ArrayUtils.insert((int)index, (long[])this.value, (long[])ArrayUtils.toPrimitive((Long[])elements));
    }

    @Override
    public Long remove(int index) {
        Long previous = this.value[index];
        this.value = ArrayUtils.remove((long[])this.value, (int)index);
        return previous;
    }

    @Override
    public void clear() {
        this.value = new long[0];
    }

    @Override
    public Iterator<Long> iterator() {
        return Arrays.asList(ArrayUtils.toObject((long[])this.value)).iterator();
    }

    @Override
    public void forEach(Consumer<? super Long> action) {
        Arrays.asList(ArrayUtils.toObject((long[])this.value)).forEach(action);
    }

    @Override
    public Spliterator<Long> spliterator() {
        return Arrays.asList(ArrayUtils.toObject((long[])this.value)).spliterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongArrayTag that = (LongArrayTag)o;
        return Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public LongArrayTag() {
    }

    public LongArrayTag(@NonNull long[] value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }
}

