/*
 * Decompiled with CFR 0.152.
 */
package dev.dewy.nbt.tags.array;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.dewy.nbt.api.registry.TagTypeRegistry;
import dev.dewy.nbt.api.snbt.SnbtConfig;
import dev.dewy.nbt.tags.TagType;
import dev.dewy.nbt.tags.array.ArrayTag;
import dev.dewy.nbt.utils.StringUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;

public class IntArrayTag
extends ArrayTag<Integer> {
    @NonNull
    private int[] value;

    public IntArrayTag(String name, @NonNull int[] value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.setName(name);
        this.setValue(value);
    }

    public IntArrayTag(@NonNull List<Integer> value) {
        this(null, value);
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
    }

    public IntArrayTag(String name, @NonNull List<Integer> value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.setName(name);
        this.setValue(ArrayUtils.toPrimitive((Integer[])value.toArray(new Integer[0])));
    }

    @Override
    public byte getTypeId() {
        return TagType.INT_ARRAY.getId();
    }

    public int[] getValue() {
        return this.value;
    }

    public void setValue(@NonNull int[] value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    @Override
    public void write(DataOutput output, int depth, TagTypeRegistry registry) throws IOException {
        output.writeInt(this.value.length);
        for (int i : this) {
            output.writeInt(i);
        }
    }

    @Override
    public IntArrayTag read(DataInput input, int depth, TagTypeRegistry registry) throws IOException {
        this.value = new int[input.readInt()];
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = input.readInt();
        }
        return this;
    }

    @Override
    public JsonObject toJson(int depth, TagTypeRegistry registry) throws IOException {
        JsonObject json = new JsonObject();
        JsonArray array = new JsonArray();
        json.addProperty("type", (Number)this.getTypeId());
        if (this.getName() != null) {
            json.addProperty("name", this.getName());
        }
        for (int i : this) {
            array.add((Number)i);
        }
        json.add("value", (JsonElement)array);
        return json;
    }

    @Override
    public IntArrayTag fromJson(JsonObject json, int depth, TagTypeRegistry registry) throws IOException {
        JsonArray array = json.getAsJsonArray("value");
        if (json.has("name")) {
            this.setName(json.getAsJsonPrimitive("name").getAsString());
        } else {
            this.setName(null);
        }
        this.value = new int[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            this.value[i] = array.get(i).getAsInt();
        }
        return this;
    }

    @Override
    public String toSnbt(int depth, TagTypeRegistry registry, SnbtConfig config) {
        StringBuilder sb = new StringBuilder("[I;");
        if (config.isPrettyPrint()) {
            if (this.value.length < config.getInlineThreshold()) {
                sb.append('\n').append(StringUtils.multiplyIndent(depth + 1, config));
            } else {
                sb.append(' ');
            }
        }
        for (int i = 0; i < this.value.length; ++i) {
            if (i != 0) {
                if (config.isPrettyPrint()) {
                    if (this.value.length < config.getInlineThreshold()) {
                        sb.append(",\n").append(StringUtils.multiplyIndent(depth + 1, config));
                    } else {
                        sb.append(", ");
                    }
                } else {
                    sb.append(',');
                }
            }
            sb.append(this.value[i]);
        }
        if (config.isPrettyPrint() && this.value.length < config.getInlineThreshold()) {
            sb.append("\n").append(StringUtils.multiplyIndent(depth, config)).append(']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public Integer get(int index) {
        return this.value[index];
    }

    @Override
    public Integer set(int index, @NonNull Integer element) {
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        this.value[index] = element;
        return this.value[index];
    }

    public void insert(int index, Integer ... elements) {
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        this.value = ArrayUtils.insert((int)index, (int[])this.value, (int[])ArrayUtils.toPrimitive((Integer[])elements));
    }

    @Override
    public Integer remove(int index) {
        Integer previous = this.value[index];
        this.value = ArrayUtils.remove((int[])this.value, (int)index);
        return previous;
    }

    @Override
    public void clear() {
        this.value = new int[0];
    }

    @Override
    public Iterator<Integer> iterator() {
        return Arrays.asList(ArrayUtils.toObject((int[])this.value)).iterator();
    }

    @Override
    public void forEach(Consumer<? super Integer> action) {
        Arrays.asList(ArrayUtils.toObject((int[])this.value)).forEach(action);
    }

    @Override
    public Spliterator<Integer> spliterator() {
        return Arrays.asList(ArrayUtils.toObject((int[])this.value)).spliterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntArrayTag that = (IntArrayTag)o;
        return Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public IntArrayTag() {
    }

    public IntArrayTag(@NonNull int[] value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }
}

