/*
 * Decompiled with CFR 0.152.
 */
package dev.dewy.nbt.tags.array;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.dewy.nbt.api.registry.TagTypeRegistry;
import dev.dewy.nbt.api.snbt.SnbtConfig;
import dev.dewy.nbt.tags.TagType;
import dev.dewy.nbt.tags.array.ArrayTag;
import dev.dewy.nbt.utils.StringUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;

public class ByteArrayTag
extends ArrayTag<Byte> {
    @NonNull
    private byte[] value;

    public ByteArrayTag(String name, @NonNull byte[] value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.setName(name);
        this.setValue(value);
    }

    public ByteArrayTag(@NonNull List<Byte> value) {
        this(null, value);
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
    }

    public ByteArrayTag(String name, @NonNull List<Byte> value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.setName(name);
        this.setValue(ArrayUtils.toPrimitive((Byte[])value.toArray(new Byte[0])));
    }

    @Override
    public byte getTypeId() {
        return TagType.BYTE_ARRAY.getId();
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(@NonNull byte[] value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    @Override
    public void write(DataOutput output, int depth, TagTypeRegistry registry) throws IOException {
        output.writeInt(this.value.length);
        output.write(this.value);
    }

    @Override
    public ByteArrayTag read(DataInput input, int depth, TagTypeRegistry registry) throws IOException {
        byte[] tmp = new byte[input.readInt()];
        input.readFully(tmp);
        this.value = tmp;
        return this;
    }

    @Override
    public JsonObject toJson(int depth, TagTypeRegistry registry) throws IOException {
        JsonObject json = new JsonObject();
        JsonArray array = new JsonArray();
        json.addProperty("type", (Number)this.getTypeId());
        if (this.getName() != null) {
            json.addProperty("name", this.getName());
        }
        for (byte b : this) {
            array.add((Number)b);
        }
        json.add("value", (JsonElement)array);
        return json;
    }

    @Override
    public ByteArrayTag fromJson(JsonObject json, int depth, TagTypeRegistry registry) throws IOException {
        JsonArray array = json.getAsJsonArray("value");
        if (json.has("name")) {
            this.setName(json.getAsJsonPrimitive("name").getAsString());
        } else {
            this.setName(null);
        }
        this.value = new byte[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            this.value[i] = array.get(i).getAsByte();
        }
        return this;
    }

    @Override
    public String toSnbt(int depth, TagTypeRegistry registry, SnbtConfig config) {
        StringBuilder sb = new StringBuilder("[B;");
        if (config.isPrettyPrint()) {
            if (this.value.length < config.getInlineThreshold()) {
                sb.append('\n').append(StringUtils.multiplyIndent(depth + 1, config));
            } else {
                sb.append(' ');
            }
        }
        for (int i = 0; i < this.value.length; ++i) {
            if (i != 0) {
                if (config.isPrettyPrint()) {
                    if (this.value.length < config.getInlineThreshold()) {
                        sb.append(",\n").append(StringUtils.multiplyIndent(depth + 1, config));
                    } else {
                        sb.append(", ");
                    }
                } else {
                    sb.append(',');
                }
            }
            sb.append(this.value[i]).append('B');
        }
        if (config.isPrettyPrint() && this.value.length < config.getInlineThreshold()) {
            sb.append("\n").append(StringUtils.multiplyIndent(depth, config)).append(']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public Byte get(int index) {
        return this.value[index];
    }

    @Override
    public Byte set(int index, @NonNull Byte element) {
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        this.value[index] = element;
        return this.value[index];
    }

    public void insert(int index, Byte ... elements) {
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        this.value = ArrayUtils.insert((int)index, (byte[])this.value, (byte[])ArrayUtils.toPrimitive((Byte[])elements));
    }

    @Override
    public Byte remove(int index) {
        Byte previous = this.value[index];
        this.value = ArrayUtils.remove((byte[])this.value, (int)index);
        return previous;
    }

    @Override
    public void clear() {
        this.value = new byte[0];
    }

    @Override
    public Iterator<Byte> iterator() {
        return Arrays.asList(ArrayUtils.toObject((byte[])this.value)).iterator();
    }

    @Override
    public void forEach(Consumer<? super Byte> action) {
        Arrays.asList(ArrayUtils.toObject((byte[])this.value)).forEach(action);
    }

    @Override
    public Spliterator<Byte> spliterator() {
        return Arrays.asList(ArrayUtils.toObject((byte[])this.value)).spliterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArrayTag that = (ByteArrayTag)o;
        return Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public ByteArrayTag() {
    }

    public ByteArrayTag(@NonNull byte[] value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }
}

