/*
 * Decompiled with CFR 0.152.
 */
package dev.dewy.nbt.io;

import dev.dewy.nbt.api.registry.TagTypeRegistry;
import dev.dewy.nbt.tags.TagType;
import dev.dewy.nbt.tags.collection.CompoundTag;
import java.io.DataOutput;
import java.io.IOException;
import lombok.NonNull;

public class NbtWriter {
    @NonNull
    private TagTypeRegistry typeRegistry;

    public void toStream(@NonNull CompoundTag compound, @NonNull DataOutput output) throws IOException {
        if (compound == null) {
            throw new NullPointerException("compound is marked non-null but is null");
        }
        if (output == null) {
            throw new NullPointerException("output is marked non-null but is null");
        }
        output.writeByte(TagType.COMPOUND.getId());
        if (compound.getName() == null) {
            output.writeUTF("");
        } else {
            output.writeUTF(compound.getName());
        }
        compound.write(output, 0, this.typeRegistry);
    }

    public TagTypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public void setTypeRegistry(@NonNull TagTypeRegistry typeRegistry) {
        if (typeRegistry == null) {
            throw new NullPointerException("typeRegistry is marked non-null but is null");
        }
        this.typeRegistry = typeRegistry;
    }

    public NbtWriter(@NonNull TagTypeRegistry typeRegistry) {
        if (typeRegistry == null) {
            throw new NullPointerException("typeRegistry is marked non-null but is null");
        }
        this.typeRegistry = typeRegistry;
    }
}

