/*
 * Decompiled with CFR 0.152.
 */
package dev.dewy.nbt.io;

import dev.dewy.nbt.api.registry.TagTypeRegistry;
import dev.dewy.nbt.tags.TagType;
import dev.dewy.nbt.tags.collection.CompoundTag;
import java.io.DataInput;
import java.io.IOException;
import lombok.NonNull;

public class NbtReader {
    @NonNull
    private TagTypeRegistry typeRegistry;

    public CompoundTag fromStream(@NonNull DataInput input) throws IOException {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (input.readByte() != TagType.COMPOUND.getId()) {
            throw new IOException("Root tag in NBT structure must be a compound tag.");
        }
        CompoundTag result = new CompoundTag();
        result.setName(input.readUTF());
        result.read(input, 0, this.typeRegistry);
        return result;
    }

    public TagTypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public void setTypeRegistry(@NonNull TagTypeRegistry typeRegistry) {
        if (typeRegistry == null) {
            throw new NullPointerException("typeRegistry is marked non-null but is null");
        }
        this.typeRegistry = typeRegistry;
    }

    public NbtReader(@NonNull TagTypeRegistry typeRegistry) {
        if (typeRegistry == null) {
            throw new NullPointerException("typeRegistry is marked non-null but is null");
        }
        this.typeRegistry = typeRegistry;
    }
}

