/*
 * Decompiled with CFR 0.152.
 */
package dev.dewy.nbt.api.registry;

import dev.dewy.nbt.api.Tag;
import dev.dewy.nbt.api.registry.TagTypeRegistryException;
import dev.dewy.nbt.tags.TagType;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class TagTypeRegistry {
    private final Map<Byte, @NonNull Class<? extends Tag>> registry = new HashMap<Byte, Class<? extends Tag>>();

    public TagTypeRegistry() {
        TagType.registerAll(this);
    }

    public void registerTagType(byte id, @NonNull Class<? extends Tag> clazz) throws TagTypeRegistryException {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (id == 0) {
            throw new TagTypeRegistryException("Cannot register NBT tag type " + clazz + " with ID " + id + ", as that ID is reserved.");
        }
        if (this.registry.containsKey(id)) {
            throw new TagTypeRegistryException("Cannot register NBT tag type " + clazz + " with ID " + id + ", as that ID is already in use by the tag type " + this.registry.get(id).getSimpleName());
        }
        if (this.registry.containsValue(clazz)) {
            int existing = 0;
            for (Map.Entry<Byte, Class<? extends Tag>> entry : this.registry.entrySet()) {
                if (!entry.getValue().equals(clazz)) continue;
                existing = entry.getKey().byteValue();
            }
            throw new TagTypeRegistryException("NBT tag type " + clazz.getSimpleName() + " already registered under ID " + existing);
        }
        this.registry.put(id, clazz);
    }

    public boolean deregisterTagType(byte id) {
        if (id >= 0 && id <= 12) {
            return false;
        }
        return this.registry.remove(id) != null;
    }

    public boolean deregisterTagType(byte id, Class<? extends Tag> clazz) {
        return this.registry.remove(id, clazz);
    }

    public Class<? extends Tag> getClassFromId(byte id) {
        return this.registry.get(id);
    }

    public Tag instantiate(@NonNull Class<? extends Tag> clazz) throws TagTypeRegistryException {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        try {
            Constructor<? extends Tag> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new TagTypeRegistryException("Instance of tag type class " + clazz.getSimpleName() + " could not be created.", e);
        }
    }
}

