/*
 * Decompiled with CFR 0.152.
 */
package dev.dewy.nbt;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.dewy.nbt.api.registry.TagTypeRegistry;
import dev.dewy.nbt.api.snbt.SnbtConfig;
import dev.dewy.nbt.io.CompressionType;
import dev.dewy.nbt.io.NbtReader;
import dev.dewy.nbt.io.NbtWriter;
import dev.dewy.nbt.tags.collection.CompoundTag;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import lombok.NonNull;

public class Nbt {
    @NonNull
    private Gson gson;
    @NonNull
    private TagTypeRegistry typeRegistry;
    @NonNull
    private SnbtConfig snbtConfig;
    @NonNull
    private final NbtWriter writer;
    @NonNull
    private final NbtReader reader;

    public Nbt() {
        this(new TagTypeRegistry());
    }

    public Nbt(@NonNull TagTypeRegistry typeRegistry) {
        this(typeRegistry, new Gson());
        if (typeRegistry == null) {
            throw new NullPointerException("typeRegistry is marked non-null but is null");
        }
    }

    public Nbt(@NonNull TagTypeRegistry typeRegistry, @NonNull Gson gson) {
        this(typeRegistry, gson, new SnbtConfig());
        if (typeRegistry == null) {
            throw new NullPointerException("typeRegistry is marked non-null but is null");
        }
        if (gson == null) {
            throw new NullPointerException("gson is marked non-null but is null");
        }
    }

    public Nbt(@NonNull TagTypeRegistry typeRegistry, @NonNull Gson gson, @NonNull SnbtConfig snbtConfig) {
        if (typeRegistry == null) {
            throw new NullPointerException("typeRegistry is marked non-null but is null");
        }
        if (gson == null) {
            throw new NullPointerException("gson is marked non-null but is null");
        }
        if (snbtConfig == null) {
            throw new NullPointerException("snbtConfig is marked non-null but is null");
        }
        this.typeRegistry = typeRegistry;
        this.gson = gson;
        this.snbtConfig = snbtConfig;
        this.writer = new NbtWriter(typeRegistry);
        this.reader = new NbtReader(typeRegistry);
    }

    public void toStream(@NonNull CompoundTag compound, @NonNull DataOutput output) throws IOException {
        if (compound == null) {
            throw new NullPointerException("compound is marked non-null but is null");
        }
        if (output == null) {
            throw new NullPointerException("output is marked non-null but is null");
        }
        this.writer.toStream(compound, output);
    }

    public void toFile(@NonNull CompoundTag compound, @NonNull File file) throws IOException {
        if (compound == null) {
            throw new NullPointerException("compound is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.toFile(compound, file, CompressionType.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toFile(@NonNull CompoundTag compound, @NonNull File file, @NonNull CompressionType compression) throws IOException {
        if (compound == null) {
            throw new NullPointerException("compound is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (compression == null) {
            throw new NullPointerException("compression is marked non-null but is null");
        }
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        try {
            FilterOutputStream dos = null;
            try {
                switch (compression) {
                    case NONE: {
                        dos = new DataOutputStream(bos);
                        break;
                    }
                    case GZIP: {
                        dos = new DataOutputStream(new GZIPOutputStream(bos));
                        break;
                    }
                    case ZLIB: {
                        dos = new DataOutputStream(new DeflaterOutputStream(bos));
                    }
                }
                this.toStream(compound, (DataOutput)((Object)dos));
            }
            finally {
                if (Collections.singletonList(dos).get(0) != null) {
                    dos.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(bos).get(0) != null) {
                bos.close();
            }
        }
    }

    public String toSnbt(@NonNull CompoundTag compound) {
        if (compound == null) {
            throw new NullPointerException("compound is marked non-null but is null");
        }
        return compound.toSnbt(0, this.typeRegistry, this.snbtConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toJson(@NonNull CompoundTag compound, @NonNull File file) throws IOException {
        if (compound == null) {
            throw new NullPointerException("compound is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        FileWriter writer = new FileWriter(file);
        try {
            this.gson.toJson((JsonElement)compound.toJson(0, this.typeRegistry), (Appendable)writer);
        }
        finally {
            if (Collections.singletonList(writer).get(0) != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray(@NonNull CompoundTag compound) throws IOException {
        if (compound == null) {
            throw new NullPointerException("compound is marked non-null but is null");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] byArray;
            block9: {
                DataOutputStream w = new DataOutputStream(new BufferedOutputStream(baos));
                try {
                    this.toStream(compound, w);
                    byArray = baos.toByteArray();
                    if (Collections.singletonList(w).get(0) == null) break block9;
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(w).get(0) != null) {
                        w.close();
                    }
                    throw throwable;
                }
                w.close();
            }
            return byArray;
        }
        finally {
            if (Collections.singletonList(baos).get(0) != null) {
                baos.close();
            }
        }
    }

    public String toBase64(@NonNull CompoundTag compound) throws IOException {
        if (compound == null) {
            throw new NullPointerException("compound is marked non-null but is null");
        }
        return new String(Base64.getEncoder().encode(this.toByteArray(compound)), StandardCharsets.UTF_8);
    }

    public CompoundTag fromStream(@NonNull DataInput input) throws IOException {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return this.reader.fromStream(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundTag fromFile(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        try {
            CompoundTag compoundTag;
            block14: {
                FilterInputStream in = null;
                try {
                    switch (CompressionType.getCompression(new FileInputStream(file))) {
                        case NONE: {
                            in = new DataInputStream(bis);
                            break;
                        }
                        case GZIP: {
                            in = new DataInputStream(new GZIPInputStream(bis));
                            break;
                        }
                        case ZLIB: {
                            in = new DataInputStream(new InflaterInputStream(bis));
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Illegal compression type. This should never happen.");
                        }
                    }
                    compoundTag = this.fromStream((DataInput)((Object)in));
                    if (Collections.singletonList(in).get(0) == null) break block14;
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(in).get(0) != null) {
                        in.close();
                    }
                    throw throwable;
                }
                in.close();
            }
            return compoundTag;
        }
        finally {
            if (Collections.singletonList(bis).get(0) != null) {
                bis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundTag fromJson(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        FileReader reader = new FileReader(file);
        try {
            CompoundTag compoundTag = new CompoundTag().fromJson((JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class), 0, this.typeRegistry);
            return compoundTag;
        }
        finally {
            if (Collections.singletonList(reader).get(0) != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundTag fromByteArray(@NonNull byte[] bytes) throws IOException {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        DataInputStream bais = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(bytes)));
        try {
            CompoundTag compoundTag = this.fromStream(bais);
            return compoundTag;
        }
        finally {
            if (Collections.singletonList(bais).get(0) != null) {
                bais.close();
            }
        }
    }

    public CompoundTag fromBase64(@NonNull String encoded) throws IOException {
        if (encoded == null) {
            throw new NullPointerException("encoded is marked non-null but is null");
        }
        return this.fromByteArray(Base64.getDecoder().decode(encoded));
    }

    public TagTypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public void setTypeRegistry(@NonNull TagTypeRegistry typeRegistry) {
        if (typeRegistry == null) {
            throw new NullPointerException("typeRegistry is marked non-null but is null");
        }
        this.typeRegistry = typeRegistry;
        this.writer.setTypeRegistry(typeRegistry);
        this.reader.setTypeRegistry(typeRegistry);
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(@NonNull Gson gson) {
        if (gson == null) {
            throw new NullPointerException("gson is marked non-null but is null");
        }
        this.gson = gson;
    }

    public SnbtConfig getSnbtConfig() {
        return this.snbtConfig;
    }

    public void setSnbtConfig(@NonNull SnbtConfig snbtConfig) {
        if (snbtConfig == null) {
            throw new NullPointerException("snbtConfig is marked non-null but is null");
        }
        this.snbtConfig = snbtConfig;
    }
}

