/*
 * Decompiled with CFR 0.152.
 */
package dev.chrisbanes.haze;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.BlendMode;
import android.graphics.BlendModeColorFilter;
import android.graphics.ColorFilter;
import android.graphics.RecordingCanvas;
import android.graphics.RenderEffect;
import android.graphics.RenderNode;
import android.graphics.Shader;
import androidx.annotation.RequiresApi;
import androidx.collection.LruCache;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.AndroidCanvas_androidKt;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.ClipOp;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.graphics.Outline;
import androidx.compose.ui.graphics.OutlineKt;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.RectangleShapeKt;
import androidx.compose.ui.graphics.Shape;
import androidx.compose.ui.graphics.drawscope.ContentDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawContext;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import androidx.core.util.Pools;
import dev.chrisbanes.haze.AndroidHazeNode;
import dev.chrisbanes.haze.AndroidHazeNodeKt;
import dev.chrisbanes.haze.HazeArea;
import dev.chrisbanes.haze.HazeKt;
import dev.chrisbanes.haze.HazeState;
import dev.chrisbanes.haze.HazeStyle;
import dev.chrisbanes.haze.PoolKt;
import dev.chrisbanes.haze.R;
import dev.chrisbanes.haze.RenderNodeImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001:\u0001;B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J:\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b \u0010!J\f\u0010\"\u001a\u00020#*\u00020$H\u0016J\u001c\u0010%\u001a\u00020&*\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001c\u0010'\u001a\u00020&*\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\f\u0010(\u001a\u00020#*\u00020\u000bH\u0002J\f\u0010\u0014\u001a\u00020#*\u00020\u000bH\u0002J>\u0010)\u001a\u00020\u0015*\u00020\u000b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b1\u00102J\u001c\u00103\u001a\u00020#*\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\f\u00104\u001a\u00020#*\u00020\u000bH\u0002J\f\u00105\u001a\u00020#*\u00020\u000bH\u0002J\u0014\u00106\u001a\u000207*\u0002072\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u001e\u00108\u001a\u000207*\u0002072\u0006\u0010-\u001a\u00020.H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b9\u0010:R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006<"}, d2={"Ldev/chrisbanes/haze/RenderNodeImpl;", "Ldev/chrisbanes/haze/AndroidHazeNode$Impl;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "contentNode", "Landroid/graphics/RenderNode;", "getContentNode", "()Landroid/graphics/RenderNode;", "effects", "", "Ldev/chrisbanes/haze/RenderNodeImpl$Effect;", "noiseTextureCache", "Landroidx/collection/LruCache;", "", "Landroid/graphics/Bitmap;", "getNoiseTextureCache", "()Landroidx/collection/LruCache;", "getNoiseTexture", "noiseFactor", "update", "", "state", "Ldev/chrisbanes/haze/HazeState;", "defaultStyle", "Ldev/chrisbanes/haze/HazeStyle;", "position", "Landroidx/compose/ui/geometry/Offset;", "density", "Landroidx/compose/ui/unit/Density;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "update-38CYSgM", "(Ldev/chrisbanes/haze/HazeState;Ldev/chrisbanes/haze/HazeStyle;JLandroidx/compose/ui/unit/Density;Landroidx/compose/ui/unit/LayoutDirection;)Z", "draw", "", "Landroidx/compose/ui/graphics/drawscope/ContentDrawScope;", "getUpdatedContentClipPath", "Landroidx/compose/ui/graphics/Path;", "getUpdatedPath", "recycle", "updateParameters", "bounds", "Landroidx/compose/ui/geometry/Rect;", "blurRadiusPx", "tint", "Landroidx/compose/ui/graphics/Color;", "shape", "Landroidx/compose/ui/graphics/Shape;", "updateParameters-jzV_Hc0", "(Ldev/chrisbanes/haze/RenderNodeImpl$Effect;Landroidx/compose/ui/geometry/Rect;FFJLandroidx/compose/ui/graphics/Shape;)Z", "updatePaths", "updateRenderEffect", "updateRenderNodePosition", "withNoise", "Landroid/graphics/RenderEffect;", "withTint", "withTint-4WTKRHQ", "(Landroid/graphics/RenderEffect;J)Landroid/graphics/RenderEffect;", "Effect", "haze_release"})
@RequiresApi(value=31)
@SourceDebugExtension(value={"SMAP\nAndroidHazeNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidHazeNode.kt\ndev/chrisbanes/haze/RenderNodeImpl\n+ 2 LruCache.kt\nandroidx/collection/LruCacheKt\n+ 3 AndroidHazeNode.kt\ndev/chrisbanes/haze/AndroidHazeNodeKt\n+ 4 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n+ 5 Canvas.kt\nandroidx/compose/ui/graphics/CanvasKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,553:1\n339#2,9:554\n521#3,2:563\n524#3,3:585\n521#3,6:595\n299#4,20:565\n47#5,7:588\n47#5,7:601\n1222#6,4:608\n1774#6,3:614\n1777#6:618\n215#7,2:612\n1#8:617\n*S KotlinDebug\n*F\n+ 1 AndroidHazeNode.kt\ndev/chrisbanes/haze/RenderNodeImpl\n*L\n259#1:554,9\n270#1:563,2\n270#1:585,3\n298#1:595,6\n272#1:565,20\n285#1:588,7\n312#1:601,7\n330#1:608,4\n348#1:614,3\n348#1:618\n345#1:612,2\n*E\n"})
final class RenderNodeImpl
implements AndroidHazeNode.Impl {
    @NotNull
    private final Context context;
    @NotNull
    private List<Effect> effects;
    @NotNull
    private final RenderNode contentNode;
    @NotNull
    private final LruCache<Float, Bitmap> noiseTextureCache;

    public RenderNodeImpl(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.effects = CollectionsKt.emptyList();
        this.contentNode = new RenderNode("content");
        int maxSize$iv = 3;
        boolean $i$f$lruCache = false;
        this.noiseTextureCache = (LruCache)new LruCache<Float, Bitmap>(maxSize$iv){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            protected int sizeOf(@NotNull Object key, @NotNull Object value) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Object object = value;
                Object object2 = key;
                boolean bl = false;
                return 1;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            @Nullable
            protected Object create(@NotNull Object key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Object object = key;
                boolean bl = false;
                return null;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            protected void entryRemoved(boolean evicted, @NotNull Object key, @NotNull Object oldValue, @Nullable Object newValue) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
                Object object = oldValue;
                Object object2 = key;
                boolean bl = evicted;
                boolean bl2 = false;
            }
        };
    }

    @NotNull
    public final RenderNode getContentNode() {
        return this.contentNode;
    }

    @NotNull
    public final LruCache<Float, Bitmap> getNoiseTextureCache() {
        return this.noiseTextureCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void draw(@NotNull ContentDrawScope $this$draw) {
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        if (this.effects.isEmpty()) {
            $this$draw.drawContent();
            return;
        }
        this.contentNode.setPosition(0, 0, (int)Size.getWidth-impl((long)$this$draw.getSize-NH-jbRc()), (int)Size.getHeight-impl((long)$this$draw.getSize-NH-jbRc()));
        RenderNode $this$record$iv = this.contentNode;
        boolean $i$f$record = false;
        try {
            void canvas$iv;
            void layoutDirection$iv;
            Iterator<Effect> $this$draw_u2dGRGpd60$iv;
            RecordingCanvas recordingCanvas;
            RecordingCanvas recordingCanvas2 = $this$record$iv.beginRecording();
            Intrinsics.checkNotNullExpressionValue((Object)recordingCanvas2, (String)"beginRecording(...)");
            RecordingCanvas canvas = recordingCanvas = recordingCanvas2;
            boolean bl = false;
            ContentDrawScope scope = $this$draw;
            DrawScope drawScope = (DrawScope)$this$draw;
            LayoutDirection layoutDirection = $this$draw.getLayoutDirection();
            Canvas canvas2 = AndroidCanvas_androidKt.Canvas((android.graphics.Canvas)((android.graphics.Canvas)canvas));
            long size$iv = $this$draw.getSize-NH-jbRc();
            boolean bl2 = false;
            Density prevDensity$iv = $this$draw_u2dGRGpd60$iv.getDrawContext().getDensity();
            LayoutDirection prevLayoutDirection$iv = $this$draw_u2dGRGpd60$iv.getDrawContext().getLayoutDirection();
            Canvas prevCanvas$iv = $this$draw_u2dGRGpd60$iv.getDrawContext().getCanvas();
            long prevSize$iv = $this$draw_u2dGRGpd60$iv.getDrawContext().getSize-NH-jbRc();
            DrawContext $this$draw_GRGpd60_u24lambda_u247$iv = $this$draw_u2dGRGpd60$iv.getDrawContext();
            boolean bl3 = false;
            $this$draw_GRGpd60_u24lambda_u247$iv.setDensity((Density)scope);
            $this$draw_GRGpd60_u24lambda_u247$iv.setLayoutDirection((LayoutDirection)layoutDirection$iv);
            $this$draw_GRGpd60_u24lambda_u247$iv.setCanvas((Canvas)canvas$iv);
            $this$draw_GRGpd60_u24lambda_u247$iv.setSize-uvyYCjk(size$iv);
            canvas$iv.save();
            void $this$draw_u24lambda_u241_u24lambda_u240 = $this$draw_u2dGRGpd60$iv;
            boolean bl4 = false;
            scope.drawContent();
            canvas$iv.restore();
            DrawContext $this$draw_GRGpd60_u24lambda_u248$iv = $this$draw_u2dGRGpd60$iv.getDrawContext();
            boolean bl5 = false;
            $this$draw_GRGpd60_u24lambda_u248$iv.setDensity(prevDensity$iv);
            $this$draw_GRGpd60_u24lambda_u248$iv.setLayoutDirection(prevLayoutDirection$iv);
            $this$draw_GRGpd60_u24lambda_u248$iv.setCanvas(prevCanvas$iv);
            $this$draw_GRGpd60_u24lambda_u248$iv.setSize-uvyYCjk(prevSize$iv);
        }
        finally {
            $this$record$iv.endRecording();
        }
        for (Effect effect : this.effects) {
            this.update(effect);
        }
        Canvas $this$draw_u24lambda_u243 = $this$draw.getDrawContext().getCanvas();
        boolean bl = false;
        Canvas $this$withSave$iv = $this$draw_u24lambda_u243;
        boolean $i$f$withSave = false;
        try {
            $this$withSave$iv.save();
            boolean bl6 = false;
            for (Effect effect2 : this.effects) {
                AndroidHazeNodeKt.access$clipShape-SI_Vg3w($this$draw_u24lambda_u243, effect2.getShape(), effect2.getContentClipBounds(), ClipOp.Companion.getDifference-rtfAjoo(), (Function0)new Function0<Path>(this, effect2, $this$draw){
                    final /* synthetic */ RenderNodeImpl this$0;
                    final /* synthetic */ Effect $effect;
                    final /* synthetic */ ContentDrawScope $this_draw;
                    {
                        this.this$0 = $receiver;
                        this.$effect = $effect;
                        this.$this_draw = $receiver2;
                        super(0);
                    }

                    @NotNull
                    public final Path invoke() {
                        return RenderNodeImpl.access$getUpdatedContentClipPath(this.this$0, this.$effect, this.$this_draw.getLayoutDirection(), this.$this_draw.getDrawContext().getDensity());
                    }
                });
            }
            AndroidCanvas_androidKt.getNativeCanvas((Canvas)$this$draw_u24lambda_u243).drawRenderNode(this.contentNode);
        }
        finally {
            $this$withSave$iv.restore();
        }
        for (Effect effect : this.effects) {
            RenderNode $this$record$iv2 = effect.getRenderNode();
            boolean $i$f$record2 = false;
            try {
                Intrinsics.checkNotNullExpressionValue((Object)$this$record$iv2.beginRecording(), (String)"beginRecording(...)");
                RecordingCanvas canvas = $i$f$withSave;
                boolean bl7 = false;
                canvas.translate(-effect.getBounds().getLeft(), -effect.getBounds().getTop());
                Rect effect2 = effect.getBounds();
                float l = effect2.component1();
                float t = effect2.component2();
                float r = effect2.component3();
                float b = effect2.component4();
                float inflate = effect.getBlurRadiusPx();
                canvas.clipRect(l - inflate, t - inflate, r + inflate, b + inflate);
                canvas.drawRenderNode(this.contentNode);
            }
            finally {
                $this$record$iv2.endRecording();
            }
            Canvas $this$draw_u24lambda_u246 = $this$draw.getDrawContext().getCanvas();
            boolean bl8 = false;
            Canvas $this$withSave$iv2 = $this$draw_u24lambda_u246;
            boolean $i$f$withSave2 = false;
            try {
                $this$withSave$iv2.save();
                boolean bl9 = false;
                AndroidHazeNodeKt.clipShape-SI_Vg3w$default($this$draw_u24lambda_u246, effect.getShape(), effect.getBounds(), 0, (Function0)new Function0<Path>(this, effect, $this$draw){
                    final /* synthetic */ RenderNodeImpl this$0;
                    final /* synthetic */ Effect $effect;
                    final /* synthetic */ ContentDrawScope $this_draw;
                    {
                        this.this$0 = $receiver;
                        this.$effect = $effect;
                        this.$this_draw = $receiver2;
                        super(0);
                    }

                    @NotNull
                    public final Path invoke() {
                        return RenderNodeImpl.access$getUpdatedPath(this.this$0, this.$effect, this.$this_draw.getLayoutDirection(), this.$this_draw.getDrawContext().getDensity());
                    }
                }, 4, null);
                AndroidCanvas_androidKt.getNativeCanvas((Canvas)$this$draw_u24lambda_u246).drawRenderNode(effect.getRenderNode());
            }
            finally {
                $this$withSave$iv2.restore();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean update-38CYSgM(@NotNull HazeState state, @NotNull HazeStyle defaultStyle, long position, @NotNull Density density, @NotNull LayoutDirection layoutDirection) {
        int n;
        void $this$associateByTo$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)defaultStyle, (String)"defaultStyle");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        boolean currentEffectsIsEmpty = this.effects.isEmpty();
        Iterable iterable = this.effects;
        Map destination$iv = new HashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv : $this$associateByTo$iv) {
            void p0;
            Effect effect = (Effect)element$iv;
            Map map = destination$iv;
            boolean bl = false;
            map.put(p0.getArea(), element$iv);
        }
        HashMap currentEffects = (HashMap)destination$iv;
        this.effects = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)state.getAreas()), (Function1)update.1.INSTANCE), (Function1)((Function1)new Function1<HazeArea, Effect>((HashMap<HazeArea, Effect>)currentEffects){
            final /* synthetic */ HashMap<HazeArea, Effect> $currentEffects;
            {
                this.$currentEffects = $currentEffects;
                super(1);
            }

            @NotNull
            public final Effect invoke(@NotNull HazeArea area2) {
                Intrinsics.checkNotNullParameter((Object)area2, (String)"area");
                Effect effect = this.$currentEffects.remove(area2);
                if (effect == null) {
                    effect = new Effect(area2, PoolKt.acquireOrCreate((Pools.Pool<Path>)((Pools.Pool)AndroidHazeNodeKt.access$getPathPool())), PoolKt.acquireOrCreate((Pools.Pool<Path>)((Pools.Pool)AndroidHazeNodeKt.access$getPathPool())), null, null, null, 0.0f, 0.0f, 0L, null, false, false, false, 8184, null);
                }
                return effect;
            }
        })));
        Map $this$forEach$iv = currentEffects;
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            Map.Entry entry = element$iv;
            boolean bl = false;
            Effect effect = (Effect)entry.getValue();
            this.recycle(effect);
        }
        currentEffects.clear();
        Iterable $this$count$iv = this.effects;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                void $this$update_38CYSgM_u24lambda_u249_u24lambda_u248;
                Effect effect = (Effect)element$iv;
                boolean bl = false;
                Rect rect = HazeKt.boundsInLocal-Uv8p0NA(effect.getArea(), position);
                if (rect == null) {
                    rect = Rect.Companion.getZero();
                }
                Rect bounds = rect;
                HazeStyle resolvedStyle = HazeKt.resolveStyle(defaultStyle, effect.getArea().getStyle());
                Density density2 = density;
                Rect rect2 = bounds;
                Effect effect2 = effect;
                RenderNodeImpl renderNodeImpl = this;
                boolean bl2 = false;
                float f = $this$update_38CYSgM_u24lambda_u249_u24lambda_u248.toPx-0680j_4(resolvedStyle.getBlurRadius-D9Ej5fM());
                if (!renderNodeImpl.updateParameters-jzV_Hc0(effect2, rect2, f, resolvedStyle.getNoiseFactor(), resolvedStyle.getTint-0d7_KjU(), effect.getArea().getShape()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int invalidateCount = n;
        return invalidateCount > 0 || this.effects.isEmpty() != currentEffectsIsEmpty;
    }

    private final Bitmap getNoiseTexture(float noiseFactor) {
        Bitmap bitmap;
        Bitmap cached = (Bitmap)this.noiseTextureCache.get((Object)Float.valueOf(noiseFactor));
        if (cached != null) {
            return cached;
        }
        Bitmap bitmap2 = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)R.drawable.haze_noise);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"decodeResource(...)");
        Bitmap it = bitmap = AndroidHazeNodeKt.access$withAlpha(bitmap2, noiseFactor);
        boolean bl = false;
        this.noiseTextureCache.put((Object)Float.valueOf(noiseFactor), (Object)it);
        return bitmap;
    }

    private final boolean updateParameters-jzV_Hc0(Effect $this$updateParameters_u2djzV_Hc0, Rect bounds, float blurRadiusPx, float noiseFactor, long tint, Shape shape) {
        if (!$this$updateParameters_u2djzV_Hc0.getRenderEffectDirty()) {
            $this$updateParameters_u2djzV_Hc0.setRenderEffectDirty(!($this$updateParameters_u2djzV_Hc0.getBlurRadiusPx() == blurRadiusPx) || !Color.equals-impl0((long)$this$updateParameters_u2djzV_Hc0.getTint-0d7_KjU(), (long)tint) || !($this$updateParameters_u2djzV_Hc0.getNoiseFactor() == noiseFactor));
        }
        if (!$this$updateParameters_u2djzV_Hc0.getRenderNodeDirty()) {
            $this$updateParameters_u2djzV_Hc0.setRenderNodeDirty(!Intrinsics.areEqual((Object)$this$updateParameters_u2djzV_Hc0.getBounds(), (Object)bounds) || !$this$updateParameters_u2djzV_Hc0.getRenderNode().hasDisplayList());
        }
        if (!$this$updateParameters_u2djzV_Hc0.getPathsDirty()) {
            $this$updateParameters_u2djzV_Hc0.setPathsDirty(!Size.equals-impl0((long)$this$updateParameters_u2djzV_Hc0.getBounds().getSize-NH-jbRc(), (long)bounds.getSize-NH-jbRc()) || !Intrinsics.areEqual((Object)$this$updateParameters_u2djzV_Hc0.getShape(), (Object)shape) || $this$updateParameters_u2djzV_Hc0.getPath().isEmpty());
        }
        $this$updateParameters_u2djzV_Hc0.setBounds(bounds);
        $this$updateParameters_u2djzV_Hc0.setContentClipBounds(bounds.isEmpty() ? bounds : AndroidHazeNodeKt.access$coerceAtLeast(bounds.deflate(2.0f), Rect.Companion.getZero()));
        $this$updateParameters_u2djzV_Hc0.setBlurRadiusPx(blurRadiusPx);
        $this$updateParameters_u2djzV_Hc0.setNoiseFactor(noiseFactor);
        $this$updateParameters_u2djzV_Hc0.setShape(shape);
        $this$updateParameters_u2djzV_Hc0.setTint-8_81llA(tint);
        return $this$updateParameters_u2djzV_Hc0.getRenderEffectDirty() || $this$updateParameters_u2djzV_Hc0.getRenderNodeDirty() || $this$updateParameters_u2djzV_Hc0.getPathsDirty();
    }

    private final void update(Effect $this$update) {
        if ($this$update.getRenderNodeDirty()) {
            this.updateRenderNodePosition($this$update);
        }
        if ($this$update.getRenderEffectDirty()) {
            this.updateRenderEffect($this$update);
        }
    }

    private final void updateRenderEffect(Effect $this$updateRenderEffect) {
        RenderNode renderNode = $this$updateRenderEffect.getRenderNode();
        RenderEffect renderEffect = RenderEffect.createBlurEffect((float)$this$updateRenderEffect.getBlurRadiusPx(), (float)$this$updateRenderEffect.getBlurRadiusPx(), (Shader.TileMode)Shader.TileMode.CLAMP);
        Intrinsics.checkNotNullExpressionValue((Object)renderEffect, (String)"createBlurEffect(...)");
        renderNode.setRenderEffect(this.withTint-4WTKRHQ(this.withNoise(renderEffect, $this$updateRenderEffect.getNoiseFactor()), $this$updateRenderEffect.getTint-0d7_KjU()));
        $this$updateRenderEffect.setRenderEffectDirty(false);
    }

    private final void updateRenderNodePosition(Effect $this$updateRenderNodePosition) {
        RenderNode renderNode;
        RenderNode $this$updateRenderNodePosition_u24lambda_u2411 = renderNode = $this$updateRenderNodePosition.getRenderNode();
        boolean bl = false;
        $this$updateRenderNodePosition.getRenderNode().setPosition(0, 0, (int)$this$updateRenderNodePosition.getBounds().getWidth(), (int)$this$updateRenderNodePosition.getBounds().getHeight());
        $this$updateRenderNodePosition.getRenderNode().setTranslationX($this$updateRenderNodePosition.getBounds().getLeft());
        $this$updateRenderNodePosition.getRenderNode().setTranslationY($this$updateRenderNodePosition.getBounds().getTop());
        $this$updateRenderNodePosition.setRenderNodeDirty(false);
    }

    private final Path getUpdatedPath(Effect $this$getUpdatedPath, LayoutDirection layoutDirection, Density density) {
        if ($this$getUpdatedPath.getPathsDirty()) {
            this.updatePaths($this$getUpdatedPath, layoutDirection, density);
        }
        return $this$getUpdatedPath.getPath();
    }

    private final Path getUpdatedContentClipPath(Effect $this$getUpdatedContentClipPath, LayoutDirection layoutDirection, Density density) {
        if ($this$getUpdatedContentClipPath.getPathsDirty()) {
            this.updatePaths($this$getUpdatedContentClipPath, layoutDirection, density);
        }
        return $this$getUpdatedContentClipPath.getContentClipPath();
    }

    /*
     * WARNING - void declaration
     */
    private final void updatePaths(Effect $this$updatePaths, LayoutDirection layoutDirection, Density density) {
        $this$updatePaths.getPath().rewind();
        $this$updatePaths.getContentClipPath().rewind();
        if (!$this$updatePaths.getBounds().isEmpty()) {
            OutlineKt.addOutline((Path)$this$updatePaths.getPath(), (Outline)$this$updatePaths.getShape().createOutline-Pq9zytI($this$updatePaths.getBounds().getSize-NH-jbRc(), layoutDirection, density));
            if (!$this$updatePaths.getContentClipBounds().isEmpty()) {
                void $this$updatePaths_u24lambda_u2412;
                float[] fArray;
                Path.addPath-Uv8p0NA$default((Path)$this$updatePaths.getContentClipPath(), (Path)$this$updatePaths.getPath(), (long)0L, (int)2, null);
                float[] fArray2 = fArray = Matrix.constructor-impl$default(null, (int)1, null);
                Path path = $this$updatePaths.getContentClipPath();
                boolean bl = false;
                Matrix.scale-impl$default((float[])$this$updatePaths_u24lambda_u2412, (float)($this$updatePaths.getContentClipBounds().getWidth() / $this$updatePaths.getBounds().getWidth()), (float)($this$updatePaths.getContentClipBounds().getHeight() / $this$updatePaths.getBounds().getHeight()), (float)0.0f, (int)4, null);
                path.transform-58bKbWc(fArray);
            }
        }
        $this$updatePaths.setPathsDirty(false);
    }

    private final void recycle(Effect $this$recycle) {
        PoolKt.releasePath((Pools.Pool<Path>)((Pools.Pool)AndroidHazeNodeKt.access$getPathPool()), $this$recycle.getPath());
        PoolKt.releasePath((Pools.Pool<Path>)((Pools.Pool)AndroidHazeNodeKt.access$getPathPool()), $this$recycle.getContentClipPath());
    }

    private final RenderEffect withNoise(RenderEffect $this$withNoise, float noiseFactor) {
        RenderEffect renderEffect;
        if (noiseFactor >= 0.005f) {
            BitmapShader noiseShader = new BitmapShader(this.getNoiseTexture(noiseFactor), Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
            RenderEffect renderEffect2 = RenderEffect.createBlendModeEffect((RenderEffect)RenderEffect.createShaderEffect((Shader)((Shader)noiseShader)), (RenderEffect)$this$withNoise, (BlendMode)BlendMode.DST_ATOP);
            Intrinsics.checkNotNull((Object)renderEffect2);
            renderEffect = renderEffect2;
        } else {
            renderEffect = $this$withNoise;
        }
        return renderEffect;
    }

    private final RenderEffect withTint-4WTKRHQ(RenderEffect $this$withTint_u2d4WTKRHQ, long tint) {
        RenderEffect renderEffect;
        if (Color.getAlpha-impl((long)tint) >= 0.005f) {
            RenderEffect renderEffect2 = RenderEffect.createColorFilterEffect((ColorFilter)((ColorFilter)new BlendModeColorFilter(ColorKt.toArgb-8_81llA((long)tint), BlendMode.SRC_OVER)), (RenderEffect)$this$withTint_u2d4WTKRHQ);
            Intrinsics.checkNotNull((Object)renderEffect2);
            renderEffect = renderEffect2;
        } else {
            renderEffect = $this$withTint_u2d4WTKRHQ;
        }
        return renderEffect;
    }

    public static final /* synthetic */ Path access$getUpdatedContentClipPath(RenderNodeImpl $this, Effect $receiver, LayoutDirection layoutDirection, Density density) {
        return $this.getUpdatedContentClipPath($receiver, layoutDirection, density);
    }

    public static final /* synthetic */ Path access$getUpdatedPath(RenderNodeImpl $this, Effect $receiver, LayoutDirection layoutDirection, Density density) {
        return $this.getUpdatedPath($receiver, layoutDirection, density);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b(\b\u0002\u0018\u00002\u00020\u0001B\u0081\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0014\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\u000b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001f\"\u0004\b#\u0010!R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010\u000e\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001b\"\u0004\b'\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010%R\u001a\u0010\u0015\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010*\"\u0004\b.\u0010,R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u001a\u0010\u0016\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010*\"\u0004\b2\u0010,R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\"\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010;\u001a\u0004\b7\u00108\"\u0004\b9\u0010:\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006<"}, d2={"Ldev/chrisbanes/haze/RenderNodeImpl$Effect;", "", "area", "Ldev/chrisbanes/haze/HazeArea;", "path", "Landroidx/compose/ui/graphics/Path;", "contentClipPath", "renderNode", "Landroid/graphics/RenderNode;", "bounds", "Landroidx/compose/ui/geometry/Rect;", "contentClipBounds", "blurRadiusPx", "", "noiseFactor", "tint", "Landroidx/compose/ui/graphics/Color;", "shape", "Landroidx/compose/ui/graphics/Shape;", "renderEffectDirty", "", "pathsDirty", "renderNodeDirty", "(Ldev/chrisbanes/haze/HazeArea;Landroidx/compose/ui/graphics/Path;Landroidx/compose/ui/graphics/Path;Landroid/graphics/RenderNode;Landroidx/compose/ui/geometry/Rect;Landroidx/compose/ui/geometry/Rect;FFJLandroidx/compose/ui/graphics/Shape;ZZZLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getArea", "()Ldev/chrisbanes/haze/HazeArea;", "getBlurRadiusPx", "()F", "setBlurRadiusPx", "(F)V", "getBounds", "()Landroidx/compose/ui/geometry/Rect;", "setBounds", "(Landroidx/compose/ui/geometry/Rect;)V", "getContentClipBounds", "setContentClipBounds", "getContentClipPath", "()Landroidx/compose/ui/graphics/Path;", "getNoiseFactor", "setNoiseFactor", "getPath", "getPathsDirty", "()Z", "setPathsDirty", "(Z)V", "getRenderEffectDirty", "setRenderEffectDirty", "getRenderNode", "()Landroid/graphics/RenderNode;", "getRenderNodeDirty", "setRenderNodeDirty", "getShape", "()Landroidx/compose/ui/graphics/Shape;", "setShape", "(Landroidx/compose/ui/graphics/Shape;)V", "getTint-0d7_KjU", "()J", "setTint-8_81llA", "(J)V", "J", "haze_release"})
    private static final class Effect {
        @NotNull
        private final HazeArea area;
        @NotNull
        private final Path path;
        @NotNull
        private final Path contentClipPath;
        @NotNull
        private final RenderNode renderNode;
        @NotNull
        private Rect bounds;
        @NotNull
        private Rect contentClipBounds;
        private float blurRadiusPx;
        private float noiseFactor;
        private long tint;
        @NotNull
        private Shape shape;
        private boolean renderEffectDirty;
        private boolean pathsDirty;
        private boolean renderNodeDirty;

        private Effect(HazeArea area2, Path path, Path contentClipPath, RenderNode renderNode, Rect bounds, Rect contentClipBounds, float blurRadiusPx, float noiseFactor, long tint, Shape shape, boolean renderEffectDirty, boolean pathsDirty, boolean renderNodeDirty) {
            Intrinsics.checkNotNullParameter((Object)area2, (String)"area");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)contentClipPath, (String)"contentClipPath");
            Intrinsics.checkNotNullParameter((Object)renderNode, (String)"renderNode");
            Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
            Intrinsics.checkNotNullParameter((Object)contentClipBounds, (String)"contentClipBounds");
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            this.area = area2;
            this.path = path;
            this.contentClipPath = contentClipPath;
            this.renderNode = renderNode;
            this.bounds = bounds;
            this.contentClipBounds = contentClipBounds;
            this.blurRadiusPx = blurRadiusPx;
            this.noiseFactor = noiseFactor;
            this.tint = tint;
            this.shape = shape;
            this.renderEffectDirty = renderEffectDirty;
            this.pathsDirty = pathsDirty;
            this.renderNodeDirty = renderNodeDirty;
        }

        public /* synthetic */ Effect(HazeArea hazeArea, Path path, Path path2, RenderNode renderNode, Rect rect, Rect rect2, float f, float f2, long l, Shape shape, boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                renderNode = new RenderNode(null);
            }
            if ((n & 0x10) != 0) {
                rect = Rect.Companion.getZero();
            }
            if ((n & 0x20) != 0) {
                rect2 = Rect.Companion.getZero();
            }
            if ((n & 0x40) != 0) {
                f = 0.0f;
            }
            if ((n & 0x80) != 0) {
                f2 = 0.0f;
            }
            if ((n & 0x100) != 0) {
                l = Color.Companion.getUnspecified-0d7_KjU();
            }
            if ((n & 0x200) != 0) {
                shape = RectangleShapeKt.getRectangleShape();
            }
            if ((n & 0x400) != 0) {
                bl = true;
            }
            if ((n & 0x800) != 0) {
                bl2 = true;
            }
            if ((n & 0x1000) != 0) {
                bl3 = true;
            }
            this(hazeArea, path, path2, renderNode, rect, rect2, f, f2, l, shape, bl, bl2, bl3, null);
        }

        @NotNull
        public final HazeArea getArea() {
            return this.area;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        @NotNull
        public final Path getContentClipPath() {
            return this.contentClipPath;
        }

        @NotNull
        public final RenderNode getRenderNode() {
            return this.renderNode;
        }

        @NotNull
        public final Rect getBounds() {
            return this.bounds;
        }

        public final void setBounds(@NotNull Rect rect) {
            Intrinsics.checkNotNullParameter((Object)rect, (String)"<set-?>");
            this.bounds = rect;
        }

        @NotNull
        public final Rect getContentClipBounds() {
            return this.contentClipBounds;
        }

        public final void setContentClipBounds(@NotNull Rect rect) {
            Intrinsics.checkNotNullParameter((Object)rect, (String)"<set-?>");
            this.contentClipBounds = rect;
        }

        public final float getBlurRadiusPx() {
            return this.blurRadiusPx;
        }

        public final void setBlurRadiusPx(float f) {
            this.blurRadiusPx = f;
        }

        public final float getNoiseFactor() {
            return this.noiseFactor;
        }

        public final void setNoiseFactor(float f) {
            this.noiseFactor = f;
        }

        public final long getTint-0d7_KjU() {
            return this.tint;
        }

        public final void setTint-8_81llA(long l) {
            this.tint = l;
        }

        @NotNull
        public final Shape getShape() {
            return this.shape;
        }

        public final void setShape(@NotNull Shape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"<set-?>");
            this.shape = shape;
        }

        public final boolean getRenderEffectDirty() {
            return this.renderEffectDirty;
        }

        public final void setRenderEffectDirty(boolean bl) {
            this.renderEffectDirty = bl;
        }

        public final boolean getPathsDirty() {
            return this.pathsDirty;
        }

        public final void setPathsDirty(boolean bl) {
            this.pathsDirty = bl;
        }

        public final boolean getRenderNodeDirty() {
            return this.renderNodeDirty;
        }

        public final void setRenderNodeDirty(boolean bl) {
            this.renderNodeDirty = bl;
        }

        public /* synthetic */ Effect(HazeArea area2, Path path, Path contentClipPath, RenderNode renderNode, Rect bounds, Rect contentClipBounds, float blurRadiusPx, float noiseFactor, long tint, Shape shape, boolean renderEffectDirty, boolean pathsDirty, boolean renderNodeDirty, DefaultConstructorMarker $constructor_marker) {
            this(area2, path, contentClipPath, renderNode, bounds, contentClipBounds, blurRadiusPx, noiseFactor, tint, shape, renderEffectDirty, pathsDirty, renderNodeDirty);
        }
    }
}

