/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j.completion;

import dev.ai4j.openai4j.Experimental;
import dev.ai4j.openai4j.Model;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class CompletionRequest {
    private final String model;
    private final String prompt;
    private final String suffix;
    private final Integer maxTokens;
    private final Double temperature;
    private final Double topP;
    private final Integer n;
    private final Boolean stream;
    private final Integer logprobs;
    private final Boolean echo;
    private final List<String> stop;
    private final Double presencePenalty;
    private final Double frequencyPenalty;
    private final Integer bestOf;
    private final Map<String, Integer> logitBias;
    private final String user;

    private CompletionRequest(Builder builder) {
        this.model = builder.model;
        this.prompt = builder.prompt;
        this.suffix = builder.suffix;
        this.maxTokens = builder.maxTokens;
        this.temperature = builder.temperature;
        this.topP = builder.topP;
        this.n = builder.n;
        this.stream = builder.stream;
        this.logprobs = builder.logprobs;
        this.echo = builder.echo;
        this.stop = builder.stop;
        this.presencePenalty = builder.presencePenalty;
        this.frequencyPenalty = builder.frequencyPenalty;
        this.bestOf = builder.bestOf;
        this.logitBias = builder.logitBias;
        this.user = builder.user;
    }

    public String model() {
        return this.model;
    }

    public String prompt() {
        return this.prompt;
    }

    public String suffix() {
        return this.suffix;
    }

    public Integer maxTokens() {
        return this.maxTokens;
    }

    public Double temperature() {
        return this.temperature;
    }

    public Double topP() {
        return this.topP;
    }

    public Integer n() {
        return this.n;
    }

    public Boolean stream() {
        return this.stream;
    }

    public Integer logprobs() {
        return this.logprobs;
    }

    public Boolean echo() {
        return this.echo;
    }

    public List<String> stop() {
        return this.stop;
    }

    public Double presencePenalty() {
        return this.presencePenalty;
    }

    public Double frequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Integer bestOf() {
        return this.bestOf;
    }

    public Map<String, Integer> logitBias() {
        return this.logitBias;
    }

    public String user() {
        return this.user;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CompletionRequest && this.equalTo((CompletionRequest)another);
    }

    private boolean equalTo(CompletionRequest another) {
        return Objects.equals(this.model, another.model) && Objects.equals(this.prompt, another.prompt) && Objects.equals(this.suffix, another.suffix) && Objects.equals(this.maxTokens, another.maxTokens) && Objects.equals(this.temperature, another.temperature) && Objects.equals(this.topP, another.topP) && Objects.equals(this.n, another.n) && Objects.equals(this.stream, another.stream) && Objects.equals(this.logprobs, another.logprobs) && Objects.equals(this.echo, another.echo) && Objects.equals(this.stop, another.stop) && Objects.equals(this.presencePenalty, another.presencePenalty) && Objects.equals(this.frequencyPenalty, another.frequencyPenalty) && Objects.equals(this.bestOf, another.bestOf) && Objects.equals(this.logitBias, another.logitBias) && Objects.equals(this.user, another.user);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.model);
        h += (h << 5) + Objects.hashCode(this.prompt);
        h += (h << 5) + Objects.hashCode(this.suffix);
        h += (h << 5) + Objects.hashCode(this.maxTokens);
        h += (h << 5) + Objects.hashCode(this.temperature);
        h += (h << 5) + Objects.hashCode(this.topP);
        h += (h << 5) + Objects.hashCode(this.n);
        h += (h << 5) + Objects.hashCode(this.stream);
        h += (h << 5) + Objects.hashCode(this.logprobs);
        h += (h << 5) + Objects.hashCode(this.echo);
        h += (h << 5) + Objects.hashCode(this.stop);
        h += (h << 5) + Objects.hashCode(this.presencePenalty);
        h += (h << 5) + Objects.hashCode(this.frequencyPenalty);
        h += (h << 5) + Objects.hashCode(this.bestOf);
        h += (h << 5) + Objects.hashCode(this.logitBias);
        h += (h << 5) + Objects.hashCode(this.user);
        return h;
    }

    public String toString() {
        return "CompletionRequest{model=" + this.model + ", prompt=" + this.prompt + ", suffix=" + this.suffix + ", maxTokens=" + this.maxTokens + ", temperature=" + this.temperature + ", topP=" + this.topP + ", n=" + this.n + ", stream=" + this.stream + ", logprobs=" + this.logprobs + ", echo=" + this.echo + ", stop=" + this.stop + ", presencePenalty=" + this.presencePenalty + ", frequencyPenalty=" + this.frequencyPenalty + ", bestOf=" + this.bestOf + ", logitBias=" + this.logitBias + ", user=" + this.user + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String model = Model.TEXT_DAVINCI_003.stringValue();
        private String prompt;
        private String suffix;
        private Integer maxTokens;
        private Double temperature;
        private Double topP;
        private Integer n;
        private Boolean stream;
        private Integer logprobs;
        private Boolean echo;
        private List<String> stop;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private Integer bestOf;
        private Map<String, Integer> logitBias;
        private String user;

        private Builder() {
        }

        @Experimental
        public Builder from(CompletionRequest request) {
            this.model(request.model);
            this.prompt(request.prompt);
            this.suffix(request.suffix);
            this.maxTokens(request.maxTokens);
            this.temperature(request.temperature);
            this.topP(request.topP);
            this.n(request.n);
            this.stream(request.stream);
            this.logprobs(request.logprobs);
            this.echo(request.echo);
            this.stop(request.stop);
            this.presencePenalty(request.presencePenalty);
            this.frequencyPenalty(request.frequencyPenalty);
            this.bestOf(request.bestOf);
            this.logitBias(request.logitBias);
            this.user(request.user);
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        @Experimental
        public Builder model(Model model) {
            return this.model(model.stringValue());
        }

        public Builder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public Builder n(Integer n) {
            this.n = n;
            return this;
        }

        public Builder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public Builder logprobs(Integer logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        public Builder echo(Boolean echo) {
            this.echo = echo;
            return this;
        }

        public Builder stop(List<String> stop) {
            if (stop == null) {
                return this;
            }
            this.stop = Collections.unmodifiableList(stop);
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder bestOf(Integer bestOf) {
            this.bestOf = bestOf;
            return this;
        }

        public Builder logitBias(Map<String, Integer> logitBias) {
            if (logitBias == null) {
                return this;
            }
            this.logitBias = Collections.unmodifiableMap(logitBias);
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public CompletionRequest build() {
            return new CompletionRequest(this);
        }
    }
}

