/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j;

import com.google.gson.Gson;
import dev.ai4j.openai4j.ApiKeyInsertingInterceptor;
import dev.ai4j.openai4j.Experimental;
import dev.ai4j.openai4j.Json;
import dev.ai4j.openai4j.OpenAiApi;
import dev.ai4j.openai4j.RequestExecutor;
import dev.ai4j.openai4j.RequestLoggingInterceptor;
import dev.ai4j.openai4j.ResponseLoggingInterceptor;
import dev.ai4j.openai4j.SyncOrAsync;
import dev.ai4j.openai4j.SyncOrAsyncOrStreaming;
import dev.ai4j.openai4j.chat.ChatCompletionRequest;
import dev.ai4j.openai4j.chat.ChatCompletionResponse;
import dev.ai4j.openai4j.completion.CompletionRequest;
import dev.ai4j.openai4j.completion.CompletionResponse;
import dev.ai4j.openai4j.embedding.EmbeddingRequest;
import dev.ai4j.openai4j.embedding.EmbeddingResponse;
import dev.ai4j.openai4j.moderation.ModerationRequest;
import dev.ai4j.openai4j.moderation.ModerationResponse;
import dev.ai4j.openai4j.moderation.ModerationResult;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class OpenAiClient {
    private static final Logger log = LoggerFactory.getLogger(OpenAiClient.class);
    private final String url;
    private final OkHttpClient okHttpClient;
    private final OpenAiApi openAiApi;
    private final boolean logStreamingResponses;

    public OpenAiClient(String apiKey) {
        this(OpenAiClient.builder().apiKey(apiKey));
    }

    private OpenAiClient(Builder serviceBuilder) {
        this.url = serviceBuilder.url;
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().addInterceptor((Interceptor)new ApiKeyInsertingInterceptor(serviceBuilder.apiKey)).callTimeout(serviceBuilder.timeout);
        if (serviceBuilder.logRequests) {
            okHttpClientBuilder = okHttpClientBuilder.addInterceptor((Interceptor)new RequestLoggingInterceptor());
        }
        if (serviceBuilder.logResponses) {
            okHttpClientBuilder = okHttpClientBuilder.addInterceptor((Interceptor)new ResponseLoggingInterceptor());
        }
        this.logStreamingResponses = serviceBuilder.logStreamingResponses;
        this.okHttpClient = okHttpClientBuilder.build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(serviceBuilder.url).client(this.okHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)Json.GSON)).build();
        this.openAiApi = (OpenAiApi)retrofit.create(OpenAiApi.class);
    }

    public void shutdown() {
        this.okHttpClient.dispatcher().executorService().shutdown();
        this.okHttpClient.connectionPool().evictAll();
        Cache cache = this.okHttpClient.cache();
        if (cache != null) {
            try {
                cache.close();
            }
            catch (IOException e) {
                log.error("Failed to close cache", (Throwable)e);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public SyncOrAsyncOrStreaming<CompletionResponse> completion(CompletionRequest request) {
        return new RequestExecutor<CompletionRequest, CompletionResponse, CompletionResponse>(this.openAiApi.completions(CompletionRequest.builder().from(request).stream(null).build()), r -> r, this.okHttpClient, this.url + "v1/completions", () -> CompletionRequest.builder().from(request).stream(true).build(), CompletionResponse.class, r -> r, this.logStreamingResponses);
    }

    @Experimental
    public SyncOrAsyncOrStreaming<String> completion(String prompt) {
        CompletionRequest request = CompletionRequest.builder().prompt(prompt).build();
        return new RequestExecutor<CompletionRequest, CompletionResponse, String>(this.openAiApi.completions(CompletionRequest.builder().from(request).stream(null).build()), CompletionResponse::text, this.okHttpClient, this.url + "v1/completions", () -> CompletionRequest.builder().from(request).stream(true).build(), CompletionResponse.class, CompletionResponse::text, this.logStreamingResponses);
    }

    public SyncOrAsyncOrStreaming<ChatCompletionResponse> chatCompletion(ChatCompletionRequest request) {
        return new RequestExecutor<ChatCompletionRequest, ChatCompletionResponse, ChatCompletionResponse>(this.openAiApi.chatCompletions(ChatCompletionRequest.builder().from(request).stream(null).build()), r -> r, this.okHttpClient, this.url + "v1/chat/completions", () -> ChatCompletionRequest.builder().from(request).stream(true).build(), ChatCompletionResponse.class, r -> r, this.logStreamingResponses);
    }

    @Experimental
    public SyncOrAsyncOrStreaming<String> chatCompletion(String userMessage) {
        ChatCompletionRequest request = ChatCompletionRequest.builder().addUserMessage(userMessage).build();
        return new RequestExecutor<ChatCompletionRequest, ChatCompletionResponse, String>(this.openAiApi.chatCompletions(ChatCompletionRequest.builder().from(request).stream(null).build()), ChatCompletionResponse::content, this.okHttpClient, this.url + "v1/chat/completions", () -> ChatCompletionRequest.builder().from(request).stream(true).build(), ChatCompletionResponse.class, r -> r.choices().get(0).delta().content(), this.logStreamingResponses);
    }

    public SyncOrAsync<EmbeddingResponse> embedding(EmbeddingRequest request) {
        return new RequestExecutor(this.openAiApi.embeddings(request), r -> r);
    }

    @Experimental
    public SyncOrAsync<List<Float>> embedding(String input) {
        EmbeddingRequest request = EmbeddingRequest.builder().input(input).build();
        return new RequestExecutor(this.openAiApi.embeddings(request), EmbeddingResponse::embedding);
    }

    public SyncOrAsync<ModerationResponse> moderation(ModerationRequest request) {
        return new RequestExecutor(this.openAiApi.moderations(request), r -> r);
    }

    @Experimental
    public SyncOrAsync<ModerationResult> moderation(String input) {
        ModerationRequest request = ModerationRequest.builder().input(input).build();
        return new RequestExecutor(this.openAiApi.moderations(request), r -> r.results().get(0));
    }

    public static class Builder {
        private String url = "https://api.openai.com/";
        private String apiKey;
        private Duration timeout = Duration.ofSeconds(60L);
        private boolean logRequests;
        private boolean logResponses;
        private boolean logStreamingResponses;

        private Builder() {
        }

        public Builder url(String url) {
            if (url == null || url.trim().isEmpty()) {
                throw new IllegalArgumentException("URL cannot be null or empty");
            }
            this.url = url.endsWith("/") ? url : url + "/";
            return this;
        }

        public Builder apiKey(String apiKey) {
            if (apiKey == null || apiKey.trim().isEmpty()) {
                throw new IllegalArgumentException("API key cannot be null or empty. API keys can be generated here: https://platform.openai.com/account/api-keys");
            }
            this.apiKey = apiKey;
            return this;
        }

        public Builder timeout(Duration timeout) {
            if (timeout == null) {
                throw new IllegalArgumentException("Timeout cannot be null");
            }
            this.timeout = timeout;
            return this;
        }

        public Builder logRequests() {
            this.logRequests = true;
            return this;
        }

        public Builder logResponses() {
            this.logResponses = true;
            return this;
        }

        public Builder logStreamingResponses() {
            this.logStreamingResponses = true;
            return this;
        }

        public OpenAiClient build() {
            return new OpenAiClient(this);
        }
    }
}

