/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j.chat;

import com.google.gson.annotations.SerializedName;
import dev.ai4j.openai4j.chat.JsonSchemaElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class JsonEnumSchema
extends JsonSchemaElement {
    private final String description;
    @SerializedName(value="enum")
    private final List<String> enumValues;

    public JsonEnumSchema(Builder builder) {
        super("string");
        this.description = builder.description;
        this.enumValues = new ArrayList<String>(builder.enumValues);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof JsonEnumSchema && this.equalTo((JsonEnumSchema)another);
    }

    private boolean equalTo(JsonEnumSchema another) {
        return Objects.equals(this.description, another.description) && Objects.equals(this.enumValues, another.enumValues);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.enumValues);
        return h;
    }

    public String toString() {
        return "JsonEnumSchema{description=" + this.description + ", enumValues=" + this.enumValues + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String description;
        private List<String> enumValues;

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder enumValues(List<String> enumValues) {
            this.enumValues = enumValues;
            return this;
        }

        public Builder enumValues(Class<?> enumClass) {
            if (!enumClass.isEnum()) {
                throw new RuntimeException("Class " + enumClass.getName() + " must be enum");
            }
            List<String> enumValues = Arrays.stream(enumClass.getEnumConstants()).map(Object::toString).collect(Collectors.toList());
            return this.enumValues(enumValues);
        }

        public JsonEnumSchema build() {
            return new JsonEnumSchema(this);
        }
    }
}

