/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j.chat;

import dev.ai4j.openai4j.chat.FunctionCall;
import dev.ai4j.openai4j.chat.Message;
import dev.ai4j.openai4j.chat.Role;
import dev.ai4j.openai4j.chat.ToolCall;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class AssistantMessage
implements Message {
    private final Role role = Role.ASSISTANT;
    private final String content;
    private final String name;
    private final List<ToolCall> toolCalls;
    private final Boolean refusal;
    @Deprecated
    private final FunctionCall functionCall;

    private AssistantMessage(Builder builder) {
        this.content = builder.content;
        this.name = builder.name;
        this.toolCalls = builder.toolCalls;
        this.refusal = builder.refusal;
        this.functionCall = builder.functionCall;
    }

    @Override
    public Role role() {
        return this.role;
    }

    public String content() {
        return this.content;
    }

    public String name() {
        return this.name;
    }

    public List<ToolCall> toolCalls() {
        return this.toolCalls;
    }

    public Boolean refusal() {
        return this.refusal;
    }

    @Deprecated
    public FunctionCall functionCall() {
        return this.functionCall;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AssistantMessage && this.equalTo((AssistantMessage)another);
    }

    private boolean equalTo(AssistantMessage another) {
        return Objects.equals((Object)this.role, (Object)another.role) && Objects.equals(this.content, another.content) && Objects.equals(this.name, another.name) && Objects.equals(this.toolCalls, another.toolCalls) && Objects.equals(this.refusal, another.refusal) && Objects.equals(this.functionCall, another.functionCall);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.role);
        h += (h << 5) + Objects.hashCode(this.content);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.toolCalls);
        h += (h << 5) + Objects.hashCode(this.refusal);
        h += (h << 5) + Objects.hashCode(this.functionCall);
        return h;
    }

    public String toString() {
        return "AssistantMessage{role=" + (Object)((Object)this.role) + ", content=" + this.content + ", name=" + this.name + ", toolCalls=" + this.toolCalls + ", refusal=" + this.refusal + ", functionCall=" + this.functionCall + "}";
    }

    public static AssistantMessage from(String content) {
        return AssistantMessage.builder().content(content).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String content;
        private String name;
        private List<ToolCall> toolCalls;
        private Boolean refusal;
        @Deprecated
        private FunctionCall functionCall;

        private Builder() {
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder toolCalls(ToolCall ... toolCalls) {
            return this.toolCalls(Arrays.asList(toolCalls));
        }

        public Builder toolCalls(List<ToolCall> toolCalls) {
            if (toolCalls != null) {
                this.toolCalls = Collections.unmodifiableList(toolCalls);
            }
            return this;
        }

        public Builder refusal(Boolean refusal) {
            this.refusal = refusal;
            return this;
        }

        @Deprecated
        public Builder functionCall(FunctionCall functionCall) {
            this.functionCall = functionCall;
            return this;
        }

        public AssistantMessage build() {
            return new AssistantMessage(this);
        }
    }
}

