/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j.chat;

import dev.ai4j.openai4j.chat.JsonObjectSchema;
import java.util.Objects;

public class JsonSchema {
    private final String name;
    private final Boolean strict;
    private final JsonObjectSchema schema;

    public JsonSchema(Builder builder) {
        this.name = builder.name;
        this.strict = builder.strict;
        this.schema = builder.schema;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof JsonSchema && this.equalTo((JsonSchema)another);
    }

    private boolean equalTo(JsonSchema another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.strict, another.strict) && Objects.equals(this.schema, another.schema);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.strict);
        h += (h << 5) + Objects.hashCode(this.schema);
        return h;
    }

    public String toString() {
        return "JsonSchema{name=" + this.name + ", strict=" + this.strict + ", schema=" + this.schema + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private Boolean strict;
        private JsonObjectSchema schema;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder strict(Boolean strict) {
            this.strict = strict;
            return this;
        }

        public Builder schema(JsonObjectSchema schema) {
            this.schema = schema;
            return this;
        }

        public JsonSchema build() {
            return new JsonSchema(this);
        }
    }
}

