/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j.chat;

import dev.ai4j.openai4j.Experimental;
import dev.ai4j.openai4j.chat.ChatCompletionChoice;
import dev.ai4j.openai4j.shared.Usage;
import java.util.Collections;
import java.util.List;

public final class ChatCompletionResponse {
    private final String id;
    private final Integer created;
    private final String model;
    private final List<ChatCompletionChoice> choices;
    private final Usage usage;

    private ChatCompletionResponse(Builder builder) {
        this.id = builder.id;
        this.created = builder.created;
        this.model = builder.model;
        this.choices = builder.choices;
        this.usage = builder.usage;
    }

    public String id() {
        return this.id;
    }

    public Integer created() {
        return this.created;
    }

    public String model() {
        return this.model;
    }

    public List<ChatCompletionChoice> choices() {
        return this.choices;
    }

    public Usage usage() {
        return this.usage;
    }

    @Experimental
    public String content() {
        return this.choices().get(0).message().content();
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatCompletionResponse && this.equalTo((ChatCompletionResponse)another);
    }

    private boolean equalTo(ChatCompletionResponse another) {
        return this.id.equals(another.id) && this.created.equals(another.created) && this.model.equals(another.model) && this.choices.equals(another.choices) && this.usage.equals(another.usage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.created.hashCode();
        h += (h << 5) + this.model.hashCode();
        h += (h << 5) + this.choices.hashCode();
        h += (h << 5) + this.usage.hashCode();
        return h;
    }

    public String toString() {
        return "ChatCompletionResponse{id=" + this.id + ", created=" + this.created + ", model=" + this.model + ", choices=" + this.choices + ", usage=" + this.usage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer created;
        private String model;
        private List<ChatCompletionChoice> choices;
        private Usage usage;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder created(Integer created) {
            this.created = created;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder choices(List<ChatCompletionChoice> choices) {
            if (choices == null) {
                return this;
            }
            this.choices = Collections.unmodifiableList(choices);
            return this;
        }

        public Builder usage(Usage usage) {
            this.usage = usage;
            return this;
        }

        public ChatCompletionResponse build() {
            return new ChatCompletionResponse(this);
        }
    }
}

