/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j.chat;

import dev.ai4j.openai4j.chat.Delta;
import dev.ai4j.openai4j.chat.Message;

public final class ChatCompletionChoice {
    private final Integer index;
    private final Message message;
    private final Delta delta;
    private final String finishReason;

    private ChatCompletionChoice(Builder builder) {
        this.index = builder.index;
        this.message = builder.message;
        this.delta = builder.delta;
        this.finishReason = builder.finishReason;
    }

    public Integer index() {
        return this.index;
    }

    public Message message() {
        return this.message;
    }

    public Delta delta() {
        return this.delta;
    }

    public String finishReason() {
        return this.finishReason;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatCompletionChoice && this.equalTo(0, (ChatCompletionChoice)another);
    }

    private boolean equalTo(int synthetic, ChatCompletionChoice another) {
        return this.index.equals(another.index) && this.message.equals(another.message) && this.delta.equals(another.delta) && this.finishReason.equals(another.finishReason);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.index.hashCode();
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + this.delta.hashCode();
        h += (h << 5) + this.finishReason.hashCode();
        return h;
    }

    public String toString() {
        return "ChatCompletionChoice{index=" + this.index + ", message=" + this.message + ", delta=" + this.delta + ", finishReason=" + this.finishReason + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer index;
        private Message message;
        private Delta delta;
        private String finishReason;

        private Builder() {
        }

        public Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public Builder message(Message message) {
            this.message = message;
            return this;
        }

        public Builder delta(Delta delta) {
            this.delta = delta;
            return this;
        }

        public Builder finishReason(String finishReason) {
            this.finishReason = finishReason;
            return this;
        }

        public ChatCompletionChoice build() {
            return new ChatCompletionChoice(this);
        }
    }
}

