/*
 * Decompiled with CFR 0.152.
 */
package mva3.adapter;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.ListUpdateCallback;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;
import mva3.adapter.decorator.Decorator;
import mva3.adapter.decorator.SectionPositionType;
import mva3.adapter.internal.Notifier;
import mva3.adapter.internal.RecyclerItem;
import mva3.adapter.util.Mode;

public abstract class Section
implements ListUpdateCallback {
    public static final String SELECTION_PAYLOAD = "selection_payload";
    public static final String ITEM_EXPANSION_PAYLOAD = "item_expansion_payload";
    public static final String SECTION_EXPANSION_PAYLOAD = "section_expansion_payload";
    @NonNull
    Mode selectionMode = Mode.INHERIT;
    @NonNull
    Mode expansionMode = Mode.INHERIT;
    @NonNull
    Mode sectionExpansionMode = Mode.INHERIT;
    private int spanCount = Integer.MAX_VALUE;
    private List<Decorator> decorators = new ArrayList<Decorator>();
    private Notifier notifier;
    private boolean isSectionHidden = false;

    public void addDecorator(Decorator decorator) {
        this.addDecorator(decorator, -1);
    }

    public void addDecorator(Decorator decorator, int priority) {
        if (null == this.decorators) {
            this.decorators = new ArrayList<Decorator>();
        }
        if (priority >= 0 && this.decorators.size() > priority) {
            this.decorators.add(priority, decorator);
        } else {
            this.decorators.add(decorator);
        }
    }

    public void hideSection() {
        this.hideSection(true);
    }

    public boolean isSectionHidden() {
        return this.isSectionHidden;
    }

    public void removeAllDecorators() {
        this.decorators.clear();
    }

    public boolean removeDecorator(Decorator decorator) {
        return this.decorators.remove(decorator);
    }

    public void removeDecorator(int index) {
        this.decorators.remove(index);
    }

    public void setExpansionMode(@NonNull Mode expansionMode) {
        this.expansionMode = expansionMode;
    }

    public void setSectionExpansionMode(@NonNull Mode sectionExpansionMode) {
        this.sectionExpansionMode = sectionExpansionMode;
    }

    public void setSelectionMode(@NonNull Mode selectionMode) {
        this.selectionMode = selectionMode;
    }

    public void setSpanCount(int spanCount) {
        this.spanCount = spanCount;
    }

    public void showSection() {
        this.showSection(true);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void onInserted(int position, int count) {
        this.onDataSetChanged();
        if (null != this.notifier && this.isSectionVisible()) {
            this.notifier.notifySectionRangeInserted(this, position, count);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void onRemoved(int position, int count) {
        this.onDataSetChanged();
        if (null != this.notifier) {
            this.notifier.notifySectionRangeRemoved(this, position, count);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void onMoved(int fromPosition, int toPosition) {
        this.onDataSetChanged();
        if (null != this.notifier && this.isSectionVisible()) {
            this.notifier.notifySectionItemMoved(this, fromPosition, toPosition);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void onChanged(int position, int count, Object payload) {
        this.onDataSetChanged();
        if (null != this.notifier && this.isSectionVisible()) {
            this.notifier.notifySectionRangeChanged(this, position, count, payload);
        }
    }

    int getMaxSpanCount(int itemPosition, int spanCount) {
        return this.spanCount == Integer.MAX_VALUE ? spanCount : this.spanCount;
    }

    boolean isSectionVisible() {
        return !this.isSectionHidden;
    }

    void setNotifier(Notifier notifier) {
        this.notifier = notifier;
    }

    Notifier getNotifier() {
        return this.notifier;
    }

    void collapseSection() {
    }

    boolean isSectionExpanded(int itemPosition) {
        return false;
    }

    SectionPositionType getSectionPositionType(int adapterPosition, int sectionPosition, int size) {
        return size - 1 == sectionPosition ? SectionPositionType.LAST : (sectionPosition == 0 ? SectionPositionType.FIRST : SectionPositionType.MIDDLE);
    }

    void drawDecoration(int itemPosition, @NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, View child, int adapterPosition) {
        if (this.decorators.size() > 0) {
            for (Decorator decorator : this.decorators) {
                decorator.onDraw(canvas, parent, state, child, adapterPosition);
            }
        }
    }

    void drawDecorationOver(int itemPosition, @NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, View child, int adapterPosition) {
        if (this.decorators.size() > 0) {
            for (Decorator decorator : this.decorators) {
                decorator.onDrawOver(canvas, parent, state, child, adapterPosition);
            }
        }
    }

    void getDecorationOffsets(int itemPosition, @NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, int adapterPosition) {
        if (this.decorators.size() > 0) {
            for (Decorator decorator : this.decorators) {
                decorator.getItemOffsets(outRect, view, parent, state, adapterPosition);
            }
        }
    }

    boolean isReverseLayout(RecyclerView.LayoutManager layoutManager) {
        return layoutManager instanceof LinearLayoutManager && ((LinearLayoutManager)layoutManager).getReverseLayout();
    }

    boolean isVertical(RecyclerView.LayoutManager layoutManager) {
        return layoutManager instanceof LinearLayoutManager && ((LinearLayoutManager)layoutManager).getOrientation() == 1;
    }

    void onItemClicked(int position) {
    }

    void onDataSetChanged() {
    }

    void showSection(boolean notify) {
        if (this.isSectionHidden) {
            this.isSectionHidden = false;
            this.onDataSetChanged();
            if (notify) {
                this.onInserted(0, this.getCount());
            }
        }
    }

    void hideSection(boolean notify) {
        if (!this.isSectionHidden) {
            int count = this.getCount();
            this.isSectionHidden = true;
            if (notify) {
                this.onRemoved(0, count);
            }
        }
    }

    @NonNull
    Mode getModeToHonor(@NonNull Mode parentMode, @NonNull Mode childMode) {
        return childMode != Mode.INHERIT ? childMode : parentMode;
    }

    abstract Object getItem(int var1);

    abstract int getCount();

    abstract boolean isItemSelected(int var1);

    abstract void onItemSelectionToggled(int var1, @NonNull Mode var2);

    abstract void clearAllSelections();

    abstract boolean isItemExpanded(int var1);

    abstract void onItemExpansionToggled(int var1, @NonNull Mode var2);

    abstract void collapseAllItems();

    abstract int onSectionExpansionToggled(int var1, @NonNull Mode var2);

    abstract int getPositionType(int var1, int var2, RecyclerView.LayoutManager var3);

    abstract void onItemDismiss(int var1);

    abstract boolean move(int var1, int var2);

    abstract RecyclerItem startMovingItem(int var1);

    abstract void finishMovingItem(int var1, RecyclerItem var2);
}

